// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        msgbox.h
//
// Purpose:     interface to message boxes
//
// Created:     19 Jan 94   Michael Pichler
//
// Changed:     23 Feb 94   Michael Pichler
//
//
//</file>



#ifndef harmony_widgets_msgbox_h
#define harmony_widgets_msgbox_h


#include "wtranslate.h"

#include <InterViews/enter-scope.h>
class Glyph;
class Window;


// function multiLineLabel () -- moved to glyphutil.h


// class MessageBox
//
// MessageBox::message opens a modal dialog, i.e. all input for the
// application is grabbed during the dialog, and returns which
// button was pressed
//
// style name: MessageBox
//
// style attributes: font (IV)


class MessageBox
{
  public:
    enum
    {
      Ok = 0x1, Yes = 0x2, No = 0x4, Cancel = 0x8, Help = 0x10,
      NumDefined = 5,                   // number of defined bits
      // some typical combinations
      OkCancelHelp = Ok | Cancel | Help,
      YesNoHelp = Yes | No | Help
    };

    static int message(                 // message dialog
      HgLanguage::Language language,    //   language of button labels (as defined in hyperg/language.h)
      Window* parentwin,                //   parent window for alignment (nil means no alignment)
      const char* msg,                  //   message text (may contain '\n' chars for multiline text)
      const char* title = 0,            //   window title (default: same as application window)
      int buttons = OkCancelHelp,       //   the buttons the dialog contains
      int defbutton = Ok                //   the default button (return)
    );

    static void sorryNotImplemented(    // reporting unimplemented feature
      HgLanguage::Language language,    //   language of "OK" label (as defined in hyperg/language.h)
      Window* parentwin,                //   parent window for alignment (nil means no alignment)
      const char* title = 0             //   optional window title
    );

  private:
    static WTranslate::StrSym label_ [NumDefined];
};



#endif
