/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                  File: X_ide_mouse.c
 *                Author: He, Taosong
 *                  Date: 1/18/93
 *           Description: X routines for driving input device mouse
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */

/******************************************************************/
/*                  VolVis include file                           */
/******************************************************************/
#include "C_volvis.h"
#include "C_ide.h"

/*
 *        Procedure Name: X_check_event
 *          Return Value: void
 *       Input Variables: drawingarea window: window;
 *                        XEvent: *theEvent; 
 *      Output Variables: the index of the window: window_index;
 *      Update Variables:
 *      Global Variables: IDE_vd_active[C_MAX_WINDOW_NUMBER] to control
 *                        whether to track the mouse position. 
 *           Description: If the machine can handle the kb event in the 
 *                        drawingarea, get the mouse position when the pointer
 *                        is moved. Otherwise, this procedure also monitor the
 *                        other event occuring in the drawingarea and insert
 *                        them in the appopriate selection queue.  
 */

void X_check_event( theDisplay, window, theEvent, window_index) 
Display *theDisplay;
Window  window;
XEvent  *theEvent;
int     *window_index;
 {
#ifndef C_KBHAND
  extern void C_insert_select();
#endif

  extern void monitor_mouse_motion();
  extern void process_event();
  extern void get_next_event();
  extern void X_get_window_index();
  extern Window        root_window;
  extern int           IDE_vd_active[C_MAX_WINDOW_NUMBER];

  int x_cor, y_cor;

  X_get_window_index(window, window_index);

  XSelectInput(theDisplay, root_window, PointerMotionMask );
  XSelectInput(theDisplay, window, PointerMotionMask | ButtonPressMask |
                                        EnterWindowMask   | LeaveWindowMask |
                                        KeyPressMask);

  get_next_event(theEvent);

  switch (theEvent->type)
        {
#ifndef C_KBHAND
      case KeyPress:
            if  (theEvent->xkey.window == window)
              C_insert_select(C_KEYBOARD, theEvent->xkey.keycode, theEvent->xkey.state, *window_index);
            break;
      case ButtonPress:
            if  (theEvent->xbutton.window == window) 
              {
                if (theEvent->xbutton.button== Button1) 
                  {
                    C_insert_select(C_MOUSE, MOUSE_LEFT_BUTTON, -1, *window_index);
                  }
                else if (theEvent->xbutton.button==Button2)
                  {
                  C_insert_select(C_MOUSE, MOUSE_MIDDLE_BUTTON, -1, *window_index);
                  }
                else if (theEvent->xbutton.button==Button3)
                  {
                    C_insert_select(C_MOUSE,MOUSE_RIGHT_BUTTON, -1, *window_index);
                  }
             }
           break;
#endif

      case MotionNotify:
            if (IDE_vd_active[*window_index])
            {
               x_cor = theEvent->xmotion.x;
               y_cor = theEvent->xmotion.y;
               monitor_mouse_motion(x_cor, y_cor);
            }
            break;
     default:
           process_event();
           break;
      }
}
 


