/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: GL_nav_proj_geom.c
 *		      Author: 
 *			Date: 
 *		 Description: GL Drawing Routines For The Navigator 
 *			      Projection Drawing Areas - Displays
 *			      Volumes Of Type C_GEOMETRIC_DATA
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <math.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>

#include "C_volvis.h"
#include "C_navigator.h"
#include "C_nav_draw.h"

extern	C_World		world;
extern	C_View		view;
extern	C_NavInfo	nav_info;


void nav_project_geo_volume( ed_info, volume )
C_ExtraDrawInfo	ed_info;
C_Volume	*volume;
{
	C_GeoData	*geo_data;
	C_FPosition	*vptr;
	C_Polygon	*polygon;
	float		v[8][3];
	int		loop;

	geo_data = volume->data.geo_data;

	switch ( geo_data->geo_type )
	{
	  case C_SPHERE:

		v[0][0]= v[3][0] = v[4][0] = v[7][0] = 
                v[0][1]= v[1][1] = v[4][1] = v[5][1] =
                v[0][2]= v[1][2] = v[2][2] = v[3][2] = 0.0;
 
                v[1][0]= v[2][0]= v[5][0]= v[6][0]= volume->x_size_units;
                v[2][1]= v[3][1]= v[6][1]= v[7][1]= volume->y_size_units;
                v[4][2]= v[5][2]= v[6][2]= v[7][2]= volume->z_size_units;
 
		C_Draw_Shaded_Rect(ed_info, 0,4,7,3,0);
		C_Draw_Shaded_Rect(ed_info, 1,1,2,6,5);
		C_Draw_Shaded_Rect(ed_info, 2,0,1,5,4);
		C_Draw_Shaded_Rect(ed_info, 3,3,7,6,2);
		C_Draw_Shaded_Rect(ed_info, 4,0,3,2,1);
		C_Draw_Shaded_Rect(ed_info, 5,4,5,6,7);

		break;

	  case C_POLYGON:
	
		polygon = geo_data->geo_object.polygon;
		vptr = polygon->vertices;

		
		for (loop = 0; loop < polygon->num_vertices; loop++ )
		{
			v[loop][0] = vptr->x * volume->x_size_units;
			v[loop][1] = vptr->y * volume->y_size_units;
			v[loop][2] = vptr->z * volume->z_size_units;
			vptr++;
		}

		C_Draw_Shaded_Rect(ed_info, 0,0,1,2,3);
			
		break;

	  default:
		printf("Can't project that type of geo data!!!\n");
	}

}

