/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                      File: MOTIF_popup_choice.c
 *                    Author: Jiang(John) Qian
 *                      Date: 6/22/93
 *               Description: Creates a pop up error dialog, the user
 *                            has to click on the ok button inorder to
 *                            proceed.
 *      Modification History:
 *
 *              Who?            When?           Why?
 *      --------------------------------------------------------------------
 *
 */

#include <X11/Intrinsic.h>
#include <Xm/DialogS.h>
#include <Xm/SelectioB.h>
#include <Xm/MessageB.h>
#include <Xm/RowColumn.h>
#include <Xm/PushBG.h>
#include <Xm/PushB.h>
#include <Xm/LabelG.h>
#include <Xm/Xm.h>
#include <Xm/PanedW.h>
#include <Xm/Form.h>
#include <Xm/Text.h> 

#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_help.h"

#define YES	    1
#define	NO	    2

extern Widget           vv_toplevel;
extern C_WindowDefs     window_defs;
extern XtAppContext	vv_app_context;



/*
 *        Procedure Name: C_popup_choices
 *          Return Value: return_value	- the choice made by user
 *       Input Variables: message	- the message string to display
 *			  num_choices	- number of choices for user
 *			  choices	- the name of those choices
 *			  level		- the user level
 *      Output Variables: none
 *      Update Variables: none
 *      Global Variables: vv_toplevel - the top level shell which is the
 *                                      parent of error dialog.
 *                        window_defs - used to set up colors.
 *			  vv_app_context  - used to simulate main loop
 *
 *           Description: This function creates a popup dialog with a 
 *			  given number of buttons and button labels.  It
 *			  display a message in a scroll text arrea.  The
 *			  user has to click one of the buttons to proceed.
 *			  This function returns the choice user made.
 */

int C_popup_choices(message,num_choices, choices,level)
char  *message;			/* the message to display */
int   num_choices;		/* number of choices user have */
char  *choices[];		/* the name of those choices */
int   level;			/* the user level */
{
  static Widget  message_dialog;	/* the message dialog */
  int	  i,n;
  static int return_value;	    /* the value to return */
  Arg	  args[20];
  XmString  yes,no,text;

  void	response();		/* callback function when user clicks a button */

	if (!message_dialog)
	{

	    yes = XmStringCreateSimple(choices[0]);
	    no =  XmStringCreateSimple(choices[1]);
	    text = XmStringCreateSimple(message);

	    n=0;
	    /* only this application is disabled while dialog is up */
	    XtSetArg( args[n], XmNdialogStyle, 
			    XmDIALOG_FULL_APPLICATION_MODAL);	n++;
	    XtSetArg( args[n], XmNokLabelString, yes );		n++;
	    XtSetArg( args[n], XmNcancelLabelString, no);	n++;
	    XtSetArg( args[n], XmNmessageString, text);		n++;
	    C_Set_Color_Dialog(args,n,window_defs);
	    message_dialog = XmCreateQuestionDialog(vv_toplevel, "dialog",
						    args, n);

	    XtSetSensitive(XmMessageBoxGetChild(message_dialog, 
 					XmDIALOG_HELP_BUTTON), False);
	    XtAddCallback(message_dialog, XmNokCallback, 
					response, &return_value);
	    XtAddCallback(message_dialog, XmNcancelCallback, 
					response, &return_value);

	    XmStringFree(yes);
	    XmStringFree(no);
	    XmStringFree(text);

	}

	return_value = 0;
  
	XtManageChild(message_dialog);
	/* popup the dialog */
	XtPopup(XtParent(message_dialog), XtGrabNone);

	/* while the user hasn't click the button, simulate main loop */
	while(return_value == 0)
		XtAppProcessEvent(vv_app_context, XtIMAll);
	/* only the user clicks a button, pop down dialog */
	XtPopdown(XtParent(message_dialog));

/*  the following statement causes bus error, but was included in the 
    example. Supposingly cause dialog to exit better.


    XSync(XtDisplay(message_dialogs),0);
    XmUpdateDisplay(vv_toplevel);
*/
	return_value --;

	return return_value;
}


void response(w, return_value,cbs)
Widget w;
int *return_value;
XmAnyCallbackStruct *cbs;
{
  switch (cbs->reason)
  {
    case XmCR_OK:
	  *return_value = YES;
	  break;
    case XmCR_CANCEL: 
	  *return_value = NO;
	  break;
  }
}




