/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: MOTIF_oco_ui.c
 *		      Author: Lisa Sobierajski 
 *			Date: 03/07/92
 *		 Description: Motif Windowing Routines Of The Object Properties 
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <math.h>
#include <Xm/Xm.h>

#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_oco.h"


/* Global Variables For Motif Windowing */


void oco_data_prop_callback( w, volume_index, call_data )
Widget			w;
int			volume_index;
XtPointer		call_data;
{
	extern void		oco_create_scandata8bit_prop_display();
	extern void		oco_create_geodata_prop_display();

	extern C_World			world;
	extern C_ObjectControlInfo	oco_info;

	if ( oco_info.volume_info[volume_index]->data.volume_data_displayed )
	{
		if (XtIsManaged( oco_info.volume_info[
			volume_index]->data.volume_data_displayed))
		   XtUnmanageChild(oco_info.volume_info[
			volume_index]->data.volume_data_displayed);

		XtManageChild( oco_info.volume_info[
			volume_index]->data.volume_data_displayed );	
	}
	else
	{
	    switch ( world.volume[volume_index]->data_type )	 
	    {
		case C_SCALAR_DATA_8BIT:
			oco_create_scandata8bit_prop_display( volume_index );
			break;

		case C_GEOMETRIC_DATA:
			oco_create_geodata_prop_display( volume_index );
			break;

		default:

			C_error_message("Unknown Data Type!!!/n");
			break;
	    }
	}
}
