/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: MOTIF_oco_ui.c
 *		      Author: Lisa Sobierajski 
 *			Date: 03/07/92
 *		 Description: Motif Windowing Routines Of The Object Properties 
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <math.h>
#include <Xm/Xm.h>

#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_oco.h"


void oco_modify_callback( w, client_data, call_data )
Widget          w;
XtPointer       client_data;
XtPointer       call_data;
{
	extern void oco_create_world_display();
	extern void oco_create_view_display();
	extern void oco_create_volume_display();
	extern void oco_create_light_display();

	extern C_World			world;
	extern C_ObjectControlInfo	oco_info;

	int				n;

	n = oco_info.active_object;

	if (n == 0)
	{
	    if (!oco_info.world_info.world_displayed)
	    {
		oco_create_world_display();
	    }
	    else
	    {
		if (XtIsManaged( oco_info.world_info.world_displayed ) )
			XtUnmanageChild( oco_info.world_info.world_displayed );

		XtManageChild( oco_info.world_info.world_displayed );
	    }
	}
	else if (n == 1)
	{
            if (!oco_info.view_info.view_displayed)
            {
		oco_create_view_display();
            }
            else
            {
                if (XtIsManaged( oco_info.view_info.view_displayed ) )
                        XtUnmanageChild( oco_info.view_info.view_displayed );

                XtManageChild( oco_info.view_info.view_displayed );
            }
        }
	else if (n < world.num_volumes + 2)
	{
	    if ( !oco_info.volume_info[n-2] ) 
	    {
		oco_create_volume_display(n-2);
	    }
	    else
	    {
		if (XtIsManaged(oco_info.volume_info[n-2]->volume_displayed ))
			XtUnmanageChild( 
				oco_info.volume_info[n-2]->volume_displayed );

		XtManageChild( oco_info.volume_info[n-2]->volume_displayed );
	    }
	}
	else
	{
	    if (!oco_info.light_info[n - (world.num_volumes + 2)])
	    {
		oco_create_light_display(n - (world.num_volumes+2));
	    }
	    else
	    {
		if (XtIsManaged( 
		    oco_info.light_info[n - 
		    (world.num_volumes + 2)]->light_displayed )) 
			XtUnmanageChild( 
			    oco_info.light_info[
			    n - (world.num_volumes + 2)]->light_displayed );

		XtManageChild( oco_info.light_info[
		    n - (world.num_volumes + 2)]->light_displayed );
	    }
	}
}

