/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *                  File: MOTIF_nav_ui.c
 *                Author: Rick Avila 
 *                  Date: 06/29/93
 *           Description: Motif Windowing Routines For The Navigator. 
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */

#include <stdio.h>
#include <string.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <X11/StringDefs.h>
#include <Xm/ToggleBG.h>
#include <Xm/ToggleB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/LabelG.h>
#include <Xm/BulletinB.h>
#include <Xm/DialogS.h>
#include <Xm/Frame.h>

#include "C_volvis.h"
#include "C_navigator.h"
#include "MOTIF_windefs.h"
#include "C_help.h"

/* Global Variable Declarations */
Widget nav_ct_bbdialog = NULL;	/* The parent widget for the   */
				/* navigator control window    */ 
Widget nav_wf_bbdialog = NULL; 	/* The parent widget for the   */
				/* navigator wireframe window  */
Widget nav_pj_bbdialog = NULL;	/* The parent widget for the   */
				/* navigator projection window */

C_NavInfo	nav_info;


/*
 *        Procedure Name: create_nav_window
 *          Return Value: none 
 *       Input Variables: none
 *      Output Variables: none
 *      Update Variables: none
 *      Global Variables: window_defs     - window appearance definitions
 *			  vv_toplevel	  - VolVis toplevel Shell Widget 
 *			  nav_bbdialog	  - The parent widget of Navigator   
 *
 *           Description: This procedure creates all the button Widgets in the
 *			  navigator main selection window and adds the
 *			  activation call back function to them.
 *
 */

void create_nav_window()
{
	/***    External Variables  ***/
	extern C_WindowDefs	window_defs;

	/* Global Variables For Motif Windowing */
	extern Widget           vv_toplevel;
	extern Widget           nav_bbdialog;

	/***    Internal Routines  ***/
	void nav_button_CB();
	/***    External Routines  ***/
        extern void     close_callback();
        extern void     help_callback();

	/***    Local Variables     ***/
        Widget          nav_frame;
        Widget          nav_rowcol;
        Widget          nav_button;

        XmString        label_string;
        Arg             args[10];       /* Argument List */
        int             n;              /* Argument Count */

 	/********************************************************/
        /* Create The Navigator Main Selection Bulletin Board   */
        /********************************************************/

	n=0;
        XtSetArg( args[n], XmNautoUnmanage, False ); n++;
        label_string = XmStringCreate( "Navigator", XmSTRING_DEFAULT_CHARSET);
        XtSetArg( args[n], XmNdialogTitle, label_string ); n++;
	C_Set_Color_Dialog( args, n, window_defs );
        nav_bbdialog = XmCreateBulletinBoardDialog(vv_toplevel, 
				"Navigator Window Selections", args, n);

        /***************************************/
        /* Create The Frame For Window Buttons */
        /***************************************/
        n=0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        nav_frame = XmCreateFrame( nav_bbdialog, "nav_frame", args, n );
        XtManageChild( nav_frame );

        /***********************************/
        /* Create A RowCol For The Buttons */
        /***********************************/
        n=0;
        C_Set_Color_RowColumn( args, n, window_defs );
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        nav_rowcol = XmCreateRowColumn(nav_frame, "nav_rowcol", args, n);
        XtManageChild( nav_rowcol );

        /************************************/
        /* Create The Control Window Button */
        /************************************/
        n=0;
        C_Set_Color_Button( args, n, window_defs );
        nav_button = XtCreateManagedWidget( "Manual Control",
                xmPushButtonWidgetClass, nav_rowcol, args, n );
        XtAddCallback( nav_button, XmNactivateCallback, nav_button_CB, 0 );

        /***************************************/
        /* Create The Wire Frame Window Button */
        /***************************************/
        n=0;
        C_Set_Color_Button( args, n, window_defs );
        nav_button = XtCreateManagedWidget( "Wireframe",
                xmPushButtonWidgetClass, nav_rowcol, args, n );
        XtAddCallback( nav_button, XmNactivateCallback, nav_button_CB, 1 );

        /***************************************/
        /* Create The Projection Window Button */
        /***************************************/
        n=0;
        C_Set_Color_Button( args, n, window_defs );
        nav_button = XtCreateManagedWidget( "Projection",
                xmPushButtonWidgetClass, nav_rowcol, args, n );
	XtAddCallback( nav_button, XmNactivateCallback, nav_button_CB, 2 );

        /********************************************/
        /* Create The Frame For Close & Help Button */
        /********************************************/
        n=0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 100 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        nav_frame = XmCreateFrame( nav_bbdialog, "nav_frame", args, n );
        XtManageChild( nav_frame );

        /************************************************/
        /* Create A RowCol For The Close & Help Buttons */
        /************************************************/
        n=0;
        C_Set_Color_RowColumn( args, n, window_defs );
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        nav_rowcol = XmCreateRowColumn(nav_frame, "nav_rowcol", args, n);
        XtManageChild( nav_rowcol );

        /****************************/
        /* Create The Close Buttons */
        /****************************/
        n=0;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 60 ); n++;
        C_Set_Color_Button( args, n, window_defs );
        nav_button = XtCreateManagedWidget( "Close", xmPushButtonWidgetClass,
                                nav_rowcol, args, n );
        XtAddCallback(  nav_button, XmNactivateCallback,
                        close_callback, nav_bbdialog );

        /***************************/
        /* Create The Help Buttons */
        /***************************/
        n=0;
        XtSetArg( args[n], XmNx, 110 ); n++;
        XtSetArg( args[n], XmNy, 60 ); n++;
        C_Set_Color_Button( args, n, window_defs );
        nav_button = XtCreateManagedWidget( "Help", xmPushButtonWidgetClass,
                                nav_rowcol, args, n );
        XtAddCallback(  nav_button, XmNactivateCallback,
                        help_callback, C_NAV_HELP );
}


/*
 *        Procedure Name: nav_button_CB
 *          Return Value: none 
 *       Input Variables: Widget 	w
 *			  int 		client_data
 *			  caddr_t 	call_data 
 *      Output Variables: none
 *      Update Variables: none
 *      Global Variables: Widget nav_ct_bbdialog - The parent widget for the 
 *						   "Control Window" 
 *			  Widget nav_wf_bbdialog - The parent widget for the
 *						   "Wireframe Window"
 *			  Widget nav_pj_bbdialog - The parent widget for the 
 *						   "Navigation Window"
 *
 *           Description: This call back routine will call different window
 *			  creation routine depends on the input.
 */

void nav_button_CB(w, client_data, call_data)
Widget w;
int client_data;
caddr_t call_data;
{
	/***    External Routines   ***/
	extern void nav_create_ct_window(); /* Creates Control Window */
	extern void nav_create_wf_window(); /* Creates Wireframe Window */
	extern void nav_create_pj_window(); /* Creates Navigation Projection */
					    /* Window */
#ifndef NO_IDE
	extern void C_tokenizer();
        extern void nav_fly();
	extern void register_application();
#endif


	switch (client_data)
	{
           case 0 :		      /* Control Window button is selected */ 
		if( !nav_ct_bbdialog )
                	nav_create_ct_window();

 		XtManageChild( nav_ct_bbdialog );
		break;
           case 1 :		      /* Wireframe Window button is selected */
		if( !nav_wf_bbdialog )
                	nav_create_wf_window();

 		XtManageChild( nav_wf_bbdialog );

/***		C_tokenizer(nav_info.wf_win_info.drawing_area);
****/
		break;
           case 2 :		      /* Navigation Window button is selected */
		if( !nav_pj_bbdialog )
                	nav_create_pj_window();

 		XtManageChild( nav_pj_bbdialog );

#ifndef NO_IDE
		C_tokenizer(nav_info.pj_win_info.drawing_area);
                register_application(nav_info.pj_win_info.drawing_area,nav_fly);
#endif

		break;
	   default:
		printf("Error. Unknow selection!!!\n"); 
		break;
	}
}

void nav_expose_projection_win()
{
	extern void	create_nav_window();
	extern void	nav_create_pj_window();
	extern Widget	nav_bbdialog;
	extern Widget	nav_pj_bbdialog;

#ifndef NO_IDE
	extern void C_tokenizer();
        extern void nav_fly();
	extern void register_application();
#endif

	/* Pop Up Navigator Projection Window */
	if( !nav_bbdialog )
	{
		create_nav_window();
		XtManageChild( nav_bbdialog );
	}

	/* Create The Navigator Projection Window */
	if( !nav_info.pj_win_info.drawing_area )
	{
		nav_create_pj_window();

		XtManageChild( nav_pj_bbdialog );
		XmUpdateDisplay( nav_pj_bbdialog );

#ifndef NO_IDE
		C_tokenizer(nav_info.pj_win_info.drawing_area);
                register_application(nav_info.pj_win_info.drawing_area,nav_fly);
#endif
	}

	/* Manage The Nav Projection Dialog And Process All Exposure Events */
	if( !XtIsManaged(nav_pj_bbdialog) )
	{
		XtManageChild( nav_pj_bbdialog );
		XmUpdateDisplay( nav_pj_bbdialog );
	}
}


/****************************************************************/
/*                                                              */
/*           Update Every Navigator Display Routine             */
/*                                                              */
/****************************************************************/
void nav_update()
{
        Arg             args[10];       /* Argument List */
        int             n;              /* Argument Count */
	int		new_pos;

	extern void	nav_wireframe_draw();
	extern void	nav_wireframe_key_draw();
	extern void	nav_projection_draw();
	extern C_View	view;

        nav_wireframe_draw( C_NAV_WIREFRAME );

/**** This does NOT need to be updated - expose events will do 
        nav_wireframe_key_draw();
****/

	/* Resize Navigator Projection Window If View Size Has Changed */
	if( nav_pj_bbdialog )
	{
	   if( (nav_info.pj_win_info.width_pixels != view.width_pixels) ||
	       (nav_info.pj_win_info.height_pixels != view.height_pixels) )
	   {
		/************************************************/
		/* Resize The Navigator Projection Drawing Area */
		/************************************************/
		n=0;
        	XtSetArg( args[n], XmNwidth, view.width_pixels ); n++;
        	XtSetArg( args[n], XmNheight, view.height_pixels ); n++;
		XtSetValues( nav_info.pj_win_info.drawing_area, args, n );

		/*******************************/
		/* Reposition The Slider Frame */
		/*******************************/
		if( view.width_pixels > 200 )
			new_pos = view.width_pixels + 20;
		else
			new_pos = 220;

		n=0;
		XtSetArg( args[n], XmNx, new_pos ); n++;
		XtSetArg( args[n], XmNheight, view.height_pixels ); n++;
		XtSetValues(  nav_info.pj_win_info.slider_frame, args, n );

		/*******************************/
		/* Reposition The Button Frame */
		/*******************************/
		if( view.height_pixels > 200 )
			new_pos = view.height_pixels + 20;
		else
			new_pos = 220;

		n=0;
		XtSetArg( args[n], XmNy, new_pos ); n++;
		XtSetValues(  nav_info.pj_win_info.button_frame, args, n );

		/***********************************************************/
		/* Set The New Width & Height Into The Navigator Structure */
		/***********************************************************/
		nav_info.pj_win_info.width_pixels = view.width_pixels;
		nav_info.pj_win_info.height_pixels = view.height_pixels;
	   }
	}

        nav_projection_draw( C_NAV_PROJECTION );
}

