/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: MOTIF_main.c
 *		      Author: Rick Avila
 *			Date: 03/07/92
 *		 Description: Motif Windowing Routines Of VolVis
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/BulletinB.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/DrawingA.h>

#include "C_volvis.h"
#include "MOTIF_windefs.h"

#define C_FONT "-adobe-helvetica-bold-r-normal--14-140-75-75-p-82-iso8859-1"


#include "bitmaps/fio_bitmap"
#include "bitmaps/fil_bitmap"
#include "bitmaps/oco_bitmap"
#include "bitmaps/ivi_bitmap"
#include "bitmaps/ren_bitmap"
#include "bitmaps/nav_bitmap"
#include "bitmaps/ani_bitmap"
#include "bitmaps/mea_bitmap"
#include "bitmaps/ide_bitmap"
#include "bitmaps/mes_bitmap"
#include "bitmaps/pre_bitmap"
#include "bitmaps/icon_bitmap"

/* Global Variables For Motif Windowing */
Widget		vv_toplevel;	/* VolVis toplevel Shell Widget */
Widget		vv_rowcol;	/* VolVis Bulletin Board Widget */
XtAppContext	vv_app_context;	/* VolVis Application Context */

Widget		fio_bbdialog;	/* File I/O Bulletin Board Dialog */
Widget		fil_bbdialog;	/* Bulletin Board Dialog */
Widget		nav_bbdialog;	/* Bulletin Board Dialog */
Widget		oco_bbdialog;	/* Bulletin Board Dialog */
Widget		ren_bbdialog;	/* Bulletin Board Dialog */
Widget		ivi_bbdialog;	/* Bulletin Board Dialog */
Widget		ani_bbdialog;	/* Bulletin Board Dialog */
Widget		mea_bbdialog;	/* Bulletin Board Dialog */
Widget		ide_bbdialog;	/* Bulletin Board Dialog */
Widget		mes_bbdialog;	/* Bulletin Board Dialog */
Widget		pre_bbdialog;	/* Bulletin Board Dialog */
Widget		exi_bbdialog;	/* Bulletin Board Dialog */
Widget		ivi_pulldown;	/* A Pulldown Widget for Image Control */
Widget		ivi_active_opt[C_MAX_IMAGES]; /*Options for the Active Image*/

C_WindowDefs	window_defs;

C_initialize_windowing_system( argc, argv )
unsigned int	argc;
char		**argv;
{
extern void C_ide_initialize();

	Arg		args[20];	/* Argument List */
	int		n;		/* Argument Count */

	int		screen;		/* Default Screen */
	Display		*display;	/* Display of vv_toplevel */
	XFontStruct	*font_struct;	/* X Font Structure */
	Colormap	cmap;		/* Temporary Colormap Pointer */
	XColor		junk, junk2;	/* junk color needed for  */
					/* XAllocNamedColor       */
	XColor		*colors;	/* 8 Bit Color Cube Colors */
					/* Plus Grey Ramp */
	unsigned long	*pixels;	/* Pixel Indeces For *colors */
	int		i, j, k;	/* Color Cube Loop Variables */
	int		index;		/* Color Cube Offset */
	void		get_vis_depth();/* Attempts To Get Visual & Depth */

	/* Button Declarations */
	Widget		vv_fio_button;	/* File I/O Button Widget */
	Widget		vv_fil_button;	/* Filters Button Widget */
	Widget		vv_nav_button;	/* Navigator Button Widget */
	Widget		vv_oco_button;	/* Object Properties Button Widget */
	Widget		vv_ren_button;	/* Rendering Button Widget */
	Widget		vv_ivi_button;	/* Image Control Button Widget */
	Widget		vv_ani_button;	/* Animator Button Widget */
	Widget		vv_mea_button;	/* Measurements Button Widget */
	Widget		vv_ide_button;	/* Input Devices Button Widget */
	Widget		vv_mes_button;	/* Messages Button Widget */
	Widget		vv_pre_button;	/* Preferences Button Widget */
	Widget		vv_exi_button;	/* Exit Button Widget */

	Pixmap		pixmap;

	/* Callback Declarations */
	void		fio_callback();	/* File I/O Button Callback */
	void		fil_callback();	/* Filters Button Callback */
	void		nav_callback();	/* Navigator Button Callback */
	void		oco_callback();	/* Object Properties Button Callback */
	void		ren_callback();	/* Rendering Button Callback */
	void		ivi_callback();	/* Image Control Button Callback */
	void		ani_callback();	/* Animator Button Callback */
	void		mea_callback();	/* Measurements Button Callback */
	void		ide_callback();	/* Input Devices Button Callback */
	void		mes_callback();	/* Measurements Button Callback */
	void		pre_callback();	/* Preferences Button Callback */
	void		exi_callback();	/* Exit Button Callback */

	/********************************************************/
	/*  Make sure the environment variable VOLVIS_HOME      */
	/*  has been set.				        */
	/********************************************************/
	if (!getenv("VOLVIS_HOME") )
	{
	  fprintf(stderr,"Please set the VOLVIS_HOME environment variable\n");
	  fprintf(stderr,"to the directory where VolVis has been installed.\n");
	  fprintf(stderr,"This can be done in csh using:\n");
	  fprintf(stderr,"\tsetenv VOLVIS_HOME <path>\n");
	  exit(0);
	}
	/**************************/
	/* Initialize The Toolkit */
	/**************************/
	XtToolkitInitialize();

	/******************************/
	/* Create Application Context */
	/******************************/
	vv_app_context = XtCreateApplicationContext();

	/****************/
	/* Open Display */
	/****************/
	display = XtOpenDisplay( vv_app_context, "", "VolVis 0.1", "VolVis",
				(XrmOptionDescList)NULL, 0,
				(Cardinal*)&argc, (String*)argv );

	/******************/
	/* Get The Screen */
	/******************/
	screen = DefaultScreen( display );

	/**********************/
	/* Get Visual & Depth */
	/**********************/
	get_vis_depth( display, screen, &window_defs );

	/*******************/
	/* Create Colormap */
	/*******************/
	window_defs.colormap = XCreateColormap(display, 
						RootWindow(display, screen),
						window_defs.visual, AllocNone );

	/********************/
	/* Create Font List */
	/********************/
	font_struct = XLoadQueryFont( display, C_FONT );
	window_defs.font_list = XmFontListCreate( font_struct, 
						  XmSTRING_DEFAULT_CHARSET );

	/*************************/
	/* Create Toplevel Shell */
	/*************************/
	n=0;
	XtSetArg( args[n], XmNdepth, window_defs.depth ); n++;
	XtSetArg( args[n], XmNcolormap, window_defs.colormap ); n++;
	XtSetArg( args[n], XmNvisual, window_defs.visual ); n++;
	XtSetArg( args[n], XmNdefaultFontList, window_defs.font_list ); n++;
	XtSetArg( args[n], XmNkeyboardFocusPolicy, XmEXPLICIT ); n++;
	vv_toplevel = XtAppCreateShell(
			vv_app_context, "VolVis 1.0", 
			applicationShellWidgetClass,
			display, args, n );

	pixmap = XCreateBitmapFromData( XtDisplay( vv_toplevel ),
		RootWindowOfScreen( XtScreen( vv_toplevel ) ),
		icon_bitmap_bits, icon_bitmap_width, icon_bitmap_height );

	XtVaSetValues( vv_toplevel, XmNiconPixmap, pixmap, NULL );

	/********************************/
	/* Initialize Colors To Be Used */
	/********************************/
	cmap = window_defs.colormap;

	if( window_defs.depth == 24 )
	{
		XLookupColor( 	display, cmap, "BlueViolet", &junk, &junk2 );
		window_defs.button_foreground.pixel = C_Get_Pixel( junk2 );

		XLookupColor( 	display, cmap, "Grey75", &junk, &junk2 );
		window_defs.button_background.pixel = C_Get_Pixel( junk2 );

		XLookupColor( 	display, cmap, "Red", &junk, &junk2 );
		window_defs.button_highlight.pixel = C_Get_Pixel( junk2 );

		XLookupColor( 	display, cmap, "Grey90", &junk, &junk2 );
		window_defs.button_top_shadow.pixel = C_Get_Pixel( junk2 );

		XLookupColor( 	display, cmap, "Grey60", &junk, &junk2 );
		window_defs.button_bottom_shadow.pixel = C_Get_Pixel( junk2 );

		XLookupColor( 	display, cmap, "LightPink", &junk, &junk2 );
		window_defs.button_arm.pixel = C_Get_Pixel( junk2 );

		XLookupColor( 	display, cmap, "Red", &junk, &junk2 );
		window_defs.button_exit.pixel = C_Get_Pixel( junk2 );

		XLookupColor( 	display, cmap, "Grey75", &junk, &junk2 );
		window_defs.window_foreground.pixel = C_Get_Pixel( junk2 );

		XLookupColor( 	display, cmap, "BlueViolet", &junk, &junk2 );
		window_defs.window_background.pixel = C_Get_Pixel( junk2 );

		XLookupColor( 	display, cmap, "MediumPurple1", &junk, &junk2 );
		window_defs.window_top_shadow.pixel = C_Get_Pixel( junk2 );

		XLookupColor( 	display, cmap, "MediumPurple4", &junk, &junk2 );
		window_defs.window_bottom_shadow.pixel = C_Get_Pixel( junk2 );

                XLookupColor(   display, cmap, "Black", &junk, &junk2 );       
		window_defs.icon_foreground.pixel = C_Get_Pixel( junk2 );

	}
	else if( window_defs.depth == 8 )
	{
		XAllocNamedColor( display, cmap, "BlueViolet", &junk, &junk2 );
		window_defs.button_foreground = junk2;

		XAllocNamedColor( display, cmap, "Grey75", &junk, &junk2 );
		window_defs.button_background = junk2;

		XAllocNamedColor( display, cmap, "Red", &junk, &junk2 );
		window_defs.button_highlight = junk2;

		XAllocNamedColor( display, cmap, "Grey90", &junk, &junk2 );
		window_defs.button_top_shadow = junk2;

		XAllocNamedColor( display, cmap, "Grey60", &junk, &junk2 );
		window_defs.button_bottom_shadow = junk2;

		XAllocNamedColor( display, cmap, "LightPink", &junk, &junk2 );
		window_defs.button_arm = junk2;

		XAllocNamedColor( display, cmap, "Red", &junk, &junk2 );
		window_defs.button_exit = junk2;

		XAllocNamedColor( display, cmap, "Grey75", &junk, &junk2 );
		window_defs.window_foreground = junk2;

		XAllocNamedColor( display, cmap, "BlueViolet", &junk, &junk2 );
		window_defs.window_background = junk2;

		XAllocNamedColor( display, cmap, "MediumPurple1",&junk,&junk2 );
		window_defs.window_top_shadow = junk2;

		XAllocNamedColor( display, cmap, "MediumPurple4", &junk,&junk2);
		window_defs.window_bottom_shadow = junk2;

                XAllocNamedColor( display, cmap, "Black", &junk,&junk2);
		window_defs.icon_foreground = junk2;

		/**********************************************************/
		/* Allocate 64 Colors From RGB Color Cube & 64 Grey Scale */
		/* Colors So That We Can Show Approximate Colors In       */
		/* Color Selection Areas 				  */
		/**********************************************************/

		/*********************************/
		/* Create Color And Pixel Arrays */
		/*********************************/
		colors = (XColor *)malloc( 189 * sizeof(XColor) );

		if( !colors )
		{
			C_error_message("Could NOT Allocate Color Memory");
			C_error_message("System Must Terminate");
			exit( C_ERROR );
		}

		pixels = (unsigned long *)malloc( 189 * sizeof(long) );

		if( !pixels )
		{
			C_error_message("Could NOT Allocate Pixel Memory");
			C_error_message("System Must Terminate");
			exit( C_ERROR );
		}

		/**********************************/
		/* Allocate 189 Contiguous Colors */
		/**********************************/
		if( !XAllocColorCells(display, cmap, True, 0, 0, pixels, 189) )
		{
			C_error_message("Could NOT Allocate 200 Colors");
			C_error_message("System Must Terminate");
			exit( C_ERROR );
		}

		window_defs.first_color_index = *pixels;
		window_defs.first_grey_index  = *pixels + 125;

		/**************************************/
		/* Create The 5x5x5 Color Cube Colors */
		/**************************************/
		index = 0;
		for( i=0; i<5; i++ ) /* Red Loop   */
		for( j=0; j<5; j++ ) /* Green Loop */
		for( k=0; k<5; k++ ) /* Blue Loop  */
		{
			colors[index].pixel = pixels[0] + index;

			/* Mult By 255/4 = 63.75 To Get A Value In 0-255 */
			/* Shift By 8 To Get To A Value In 0-65535 */
			colors[index].red   = ((int)(i*63.75) << 8);
			colors[index].green = ((int)(j*63.75) << 8);
			colors[index].blue  = ((int)(k*63.75) << 8);
			colors[index].flags = DoRed|DoGreen|DoBlue;
			index++;
		}

		/*****************************/
		/* Create The 64 Grey Colors */
		/*****************************/
		for( i=0; i<64; i++ )
		{
			index = i + 125;

			colors[index].pixel = pixels[0] + 125 + i;

			/* Shift By 2 To Get Value In 0-255 */
			/* Shift By 8 To Get Value In 0-65535 */
			colors[index].red   = (i << 10);
			colors[index].green = (i << 10);
			colors[index].blue  = (i << 10);
			colors[index].flags = DoRed|DoGreen|DoBlue;
		}

		XStoreColors( display, cmap, colors, 189 );

		free( colors );
		free( pixels );
	}

	/* Create A RowColumn Widget In Which To Place VolVis Buttons */
	/****************************************/
	/*     Create The RowColumn Widget 	*/
	/****************************************/
	n=0;
	C_Set_Color_RowColumn( args, n, window_defs );
	XtSetArg( args[n], XmNtopAttachment, XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNleftAttachment, XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNrightAttachment, XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNbottomAttachment, XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNresizeWidth, TRUE ); n++;
	XtSetArg( args[n], XmNresizeHeight, TRUE ); n++;
	vv_rowcol = XmCreateRowColumn( vv_toplevel, "rc", args, n );
	XtManageChild( vv_rowcol );

	/****************************************/
	/*     Create The File I/O Button 	*/
	/****************************************/
	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	pixmap = XCreatePixmapFromBitmapData( XtDisplay( vv_toplevel ),
		RootWindowOfScreen( XtScreen( vv_toplevel ) ),
		fio_bitmap_bits, fio_bitmap_width, fio_bitmap_height,
		window_defs.button_foreground.pixel, 
		window_defs.button_background.pixel, window_defs.depth );
	XtSetArg( args[n], XmNlabelType, XmPIXMAP ); n++;
	XtSetArg( args[n], XmNlabelPixmap, pixmap ); n++;
	vv_fio_button = XtCreateManagedWidget( "File I/O", 
			xmPushButtonWidgetClass, vv_rowcol, args, n );
	XtAddCallback( vv_fio_button, XmNactivateCallback, fio_callback, NULL );

	/****************************************/
	/*     Create The Filters Button 	*/
	/****************************************/
	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	pixmap = XCreatePixmapFromBitmapData( XtDisplay( vv_toplevel ),
		RootWindowOfScreen( XtScreen( vv_toplevel ) ),
		fil_bitmap_bits, fil_bitmap_width, fil_bitmap_height,
		window_defs.button_foreground.pixel, 
		window_defs.button_background.pixel, window_defs.depth );

	XtSetArg( args[n], XmNlabelType, XmPIXMAP ); n++;
	XtSetArg( args[n], XmNlabelPixmap, pixmap ); n++;
	vv_fil_button = XtCreateManagedWidget( "Filters", 
			xmPushButtonWidgetClass, vv_rowcol, args, n );
	XtAddCallback( vv_fil_button, XmNactivateCallback, fil_callback, NULL );


	/************************************************/
	/*     Create The Object Control Button 	*/
	/************************************************/
	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	pixmap = XCreatePixmapFromBitmapData( XtDisplay( vv_toplevel ),
		RootWindowOfScreen( XtScreen( vv_toplevel ) ),
		oco_bitmap_bits, oco_bitmap_width, oco_bitmap_height,
		window_defs.button_foreground.pixel, 
		window_defs.button_background.pixel, window_defs.depth );

	XtSetArg( args[n], XmNlabelType, XmPIXMAP ); n++;
	XtSetArg( args[n], XmNlabelPixmap, pixmap ); n++;
	vv_oco_button = XtCreateManagedWidget( "Object Control", 
			xmPushButtonWidgetClass, vv_rowcol, args, n );
	XtAddCallback( vv_oco_button, XmNactivateCallback, oco_callback, NULL );

	/****************************************/
	/*     Create The Image Control Button 	*/
	/****************************************/
	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	pixmap = XCreatePixmapFromBitmapData( XtDisplay( vv_toplevel ),
		RootWindowOfScreen( XtScreen( vv_toplevel ) ),
		ivi_bitmap_bits, ivi_bitmap_width, ivi_bitmap_height,
		window_defs.button_foreground.pixel, 
		window_defs.button_background.pixel, window_defs.depth );

	XtSetArg( args[n], XmNlabelType, XmPIXMAP ); n++;
	XtSetArg( args[n], XmNlabelPixmap, pixmap ); n++;
	vv_ivi_button = XtCreateManagedWidget( "Image Control", 
			xmPushButtonWidgetClass, vv_rowcol, args, n );
	XtAddCallback( vv_ivi_button, XmNactivateCallback, ivi_callback, NULL );

	/****************************************/
	/*     Create The Rendering Button 	*/
	/****************************************/
	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	pixmap = XCreatePixmapFromBitmapData( XtDisplay( vv_toplevel ),
		RootWindowOfScreen( XtScreen( vv_toplevel ) ),
		ren_bitmap_bits, ren_bitmap_width, ren_bitmap_height,
		window_defs.button_foreground.pixel, 
		window_defs.button_background.pixel, window_defs.depth );

	XtSetArg( args[n], XmNlabelType, XmPIXMAP ); n++;
	XtSetArg( args[n], XmNlabelPixmap, pixmap ); n++;
	vv_ren_button = XtCreateManagedWidget( "Rendering", 
			xmPushButtonWidgetClass, vv_rowcol, args, n );
	XtAddCallback( vv_ren_button, XmNactivateCallback, ren_callback, NULL );

	/****************************************/
	/*     Create The Navigator Button 	*/
	/****************************************/
	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	pixmap = XCreatePixmapFromBitmapData( XtDisplay( vv_toplevel ),
		RootWindowOfScreen( XtScreen( vv_toplevel ) ),
		nav_bitmap_bits, nav_bitmap_width, nav_bitmap_height,
		window_defs.button_foreground.pixel, 
		window_defs.button_background.pixel, window_defs.depth );

	XtSetArg( args[n], XmNlabelType, XmPIXMAP ); n++;
	XtSetArg( args[n], XmNlabelPixmap, pixmap ); n++;
	vv_nav_button = XtCreateManagedWidget( "Navigator", 
			xmPushButtonWidgetClass, vv_rowcol, args, n );
	XtAddCallback( vv_nav_button, XmNactivateCallback, nav_callback, NULL );

	/****************************************/
	/*     Create The Animator Button 	*/
	/****************************************/
	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	pixmap = XCreatePixmapFromBitmapData( XtDisplay( vv_toplevel ),
		RootWindowOfScreen( XtScreen( vv_toplevel ) ),
		ani_bitmap_bits, ani_bitmap_width, ani_bitmap_height,
		window_defs.button_foreground.pixel, 
		window_defs.button_background.pixel, window_defs.depth );

	XtSetArg( args[n], XmNlabelType, XmPIXMAP ); n++;
	XtSetArg( args[n], XmNlabelPixmap, pixmap ); n++;
	vv_ani_button = XtCreateManagedWidget( "Animator", 
			xmPushButtonWidgetClass, vv_rowcol, args, n );
	XtAddCallback( vv_ani_button, XmNactivateCallback, ani_callback, NULL );

	/****************************************/
	/*     Create The Measurements Button 	*/
	/****************************************/
	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	pixmap = XCreatePixmapFromBitmapData( XtDisplay( vv_toplevel ),
		RootWindowOfScreen( XtScreen( vv_toplevel ) ),
		mea_bitmap_bits, mea_bitmap_width, mea_bitmap_height,
		window_defs.button_foreground.pixel, 
		window_defs.button_background.pixel, window_defs.depth );

	XtSetArg( args[n], XmNlabelType, XmPIXMAP ); n++;
	XtSetArg( args[n], XmNlabelPixmap, pixmap ); n++;
	vv_mea_button = XtCreateManagedWidget( "Measurements", 
			xmPushButtonWidgetClass, vv_rowcol, args, n );
	XtAddCallback( vv_mea_button, XmNactivateCallback, mea_callback, NULL );

	/****************************************/
	/*     Create The Input Devices Button 	*/
	/****************************************/
	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	pixmap = XCreatePixmapFromBitmapData( XtDisplay( vv_toplevel ),
		RootWindowOfScreen( XtScreen( vv_toplevel ) ),
		ide_bitmap_bits, ide_bitmap_width, ide_bitmap_height,
		window_defs.button_foreground.pixel, 
		window_defs.button_background.pixel, window_defs.depth );

	XtSetArg( args[n], XmNlabelType, XmPIXMAP ); n++;
	XtSetArg( args[n], XmNlabelPixmap, pixmap ); n++;
	vv_ide_button = XtCreateManagedWidget( "Input Devices", 
			xmPushButtonWidgetClass, vv_rowcol, args, n );
	XtAddCallback( vv_ide_button, XmNactivateCallback, ide_callback, NULL );

	/****************************************/
	/*     Create The Messages Button 	*/
	/****************************************/
	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	pixmap = XCreatePixmapFromBitmapData( XtDisplay( vv_toplevel ),
		RootWindowOfScreen( XtScreen( vv_toplevel ) ),
		mes_bitmap_bits, mes_bitmap_width, mes_bitmap_height,
		window_defs.button_foreground.pixel, 
		window_defs.button_background.pixel, window_defs.depth );

	XtSetArg( args[n], XmNlabelType, XmPIXMAP ); n++;
	XtSetArg( args[n], XmNlabelPixmap, pixmap ); n++;
	vv_mes_button = XtCreateManagedWidget( "Messages", 
			xmPushButtonWidgetClass, vv_rowcol, args, n );
	XtAddCallback( vv_mes_button, XmNactivateCallback, mes_callback, NULL );

	/****************************************/
	/*     Create The Preferences Button 	*/
	/****************************************/
	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	pixmap = XCreatePixmapFromBitmapData( XtDisplay( vv_toplevel ),
		RootWindowOfScreen( XtScreen( vv_toplevel ) ),
		pre_bitmap_bits, pre_bitmap_width, pre_bitmap_height,
		window_defs.button_foreground.pixel, 
		window_defs.button_background.pixel, window_defs.depth );

	XtSetArg( args[n], XmNlabelType, XmPIXMAP ); n++;
	XtSetArg( args[n], XmNlabelPixmap, pixmap ); n++;
	vv_pre_button = XtCreateManagedWidget( "Preferences", 
			xmPushButtonWidgetClass, vv_rowcol, args, n );
	XtAddCallback( vv_pre_button, XmNactivateCallback, pre_callback, NULL );

	/********************************/
	/*     Create The Exit Button 	*/
	/********************************/
	n = 0;
	C_Set_Color_Exit_Button( args, n, window_defs );
	vv_exi_button = XtCreateManagedWidget( "Exit", 
			xmPushButtonWidgetClass, vv_rowcol, args, n );
	XtAddCallback( vv_exi_button, XmNactivateCallback, exi_callback, NULL );

	/* Realize The VolVis toplevel Widget And Enter The Main Loop */
	XtRealizeWidget( vv_toplevel );
#ifndef NO_IDE
C_ide_initialize();
#endif
	XtAppMainLoop( vv_app_context );
}


void get_vis_depth( dsp, screen, win_defs )
Display		*dsp;
int		screen;
C_WindowDefs	*win_defs;
{
	XVisualInfo	vinfo;
	int		visual_found = FALSE;

	/********************************************/
	/* Attempt To Get A 24 Bit TrueColor Visual */
	/********************************************/
	if( XMatchVisualInfo(dsp, screen, 24, TrueColor, &vinfo) )
	{
		C_message("24 Bit TrueColor Visual Found\n");

		win_defs->visual 	= vinfo.visual;
		win_defs->depth  	= 24;
		win_defs->visual_class 	= TrueColor;

		return;
	}
	else
	{
		C_message("Could NOT Access A 24 bit TrueColor Visual\n");
	}

	/**********************************************/
	/* Attempt To Get A 24 Bit DirectColor Visual */
	/**********************************************/
	if( XMatchVisualInfo(dsp, screen, 24, DirectColor, &vinfo) )
	{
		C_message("24 Bit DirectColor Visual Found\n");

		win_defs->visual 	= vinfo.visual;
		win_defs->depth  	= 24;
		win_defs->visual_class 	= DirectColor;

		return;
	}
	else
	{
		C_message("Could NOT Access A 24 bit DirectColor Visual\n");
	}


	/*********************************************/
	/* Attempt To Get A 8 Bit PseudoColor Visual */
	/*********************************************/
	if( XMatchVisualInfo(dsp, screen, 8, PseudoColor, &vinfo) )
	{
		C_message("8 Bit PseudoColor Visual Found\n");

		win_defs->visual 	= vinfo.visual;
		win_defs->depth  	= 8;
		win_defs->visual_class 	= PseudoColor;

		return;
	}
	else
	{
		C_error_message("Could NOT Access An 8 Bit Visual");
		exit( C_ERROR );
	}
}

/****************************************************************/
/*								*/
/* 		VolVis toplevel CallBack Routines		*/
/*								*/
/****************************************************************/

void fio_callback( w, client_data, call_data )
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	extern void create_fio_window();

	/* Determine If The File I/O Bboard Dialog Should Be Created */
	if( !fio_bbdialog )
	{
		create_fio_window();
	}

	/* This Pops Up The Dialog - Use XtUnmanageChild To Pop Down! */
	XtManageChild( fio_bbdialog );
}


void fil_callback( w, client_data, call_data )
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	Arg		args[10];	/* Argument List */
	int		n;		/* Argument Count */

	/* Determine If The Filters Bboard Dialog Should Be Created */
	if( !fil_bbdialog )
	{
		n=0;
		XtSetArg( args[n], XmNautoUnmanage, False ); n++;
		C_Set_Color_Dialog( args, n, window_defs );
		fil_bbdialog = XmCreateBulletinBoardDialog( vv_toplevel,
			       "Filters", args, n );
	}

	/* This Pops Up The Dialog - Use XtUnmanageChild To Pop Down! */
	XtManageChild( fil_bbdialog );

}

void nav_callback( w, client_data, call_data )
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	extern	void	create_nav_window();

	/* Determine If The Navigator Bboard Dialog Should Be Created */
	if( !nav_bbdialog )
	{
		create_nav_window();
	}

	/* This Pops Up The Dialog - Use XtUnmanageChild To Pop Down! */
	XtManageChild( nav_bbdialog );

}

void oco_callback( w, client_data, call_data )
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	Arg		args[10];	/* Argument List */
	int		n;		/* Argument Count */

	/* Determine If The Object Properties Bboard Dialog Should Be Created */
	if( !oco_bbdialog )
	{
		create_oco_window();
	}

	/* This Pops Up The Dialog - Use XtUnmanageChild To Pop Down! */
	XtManageChild( oco_bbdialog );
}


void ren_callback( w, client_data, call_data )
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	extern	void	create_ren_window();

	/* Determine If The Rendering Bboard Dialog Should Be Created */
	if( !ren_bbdialog )
	{
		create_ren_window();
	}

	/* This Pops Up The Dialog - Use XtUnmanageChild To Pop Down! */
	XtManageChild( ren_bbdialog );

}

void ivi_callback( w, client_data, call_data )
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	extern void	create_ivi_window();

	/* Determine If The Image Control Bboard Dialog Should Be Created */
	if( !ivi_bbdialog )
	{
		create_ivi_window();
	}

	/* This Pops Up The Dialog - Use XtUnmanageChild To Pop Down! */
	XtManageChild( ivi_bbdialog );
}

void ani_callback( w, client_data, call_data )
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	extern void	create_ani_window(); 

	/* Determine If The Animator Bboard Dialog Should Be Created */
	if( !ani_bbdialog )
	{
		create_ani_window();
	}

	/* This Pops Up The Dialog - Use XtUnmanageChild To Pop Down! */
	XtManageChild( ani_bbdialog );
}

void mea_callback( w, client_data, call_data )
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	extern void	create_mea_window();

	/* Determine If The Measurements Bboard Dialog Should Be Created */
	if( !mea_bbdialog )
	{
		create_mea_window();
	}
	/* This Pops Up The Dialog - Use XtUnmanageChild To Pop Down! */
	XtManageChild( mea_bbdialog );
}

void ide_callback( w, client_data, call_data )
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
#ifndef NO_IDE
	Arg		args[10];	/* Argument List */
	int		n;		/* Argument Count */

	/* Determine If The Input Devices Bboard Dialog Should Be Created */
	if( !ide_bbdialog )
		create_ide_window();

	/* This Pops Up The Dialog - Use XtUnmanageChild To Pop Down! */
	XtManageChild( ide_bbdialog );
#endif
}

void pre_callback( w, client_data, call_data )
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	extern void create_pre_window();

	Arg		args[10];	/* Argument List */
	int		n;		/* Argument Count */

	/* Determine If The Preferences Bboard Dialog Should Be Created */
	if( !pre_bbdialog )
	{
		create_pre_window();

		n=0;
		XtSetArg( args[n], XmNautoUnmanage, False ); n++;
		C_Set_Color_Dialog( args, n, window_defs );
		pre_bbdialog = XmCreateBulletinBoardDialog( vv_toplevel,
			       "Preferences", args, n );
	}

	/* This Pops Up The Dialog - Use XtUnmanageChild To Pop Down! */
	XtManageChild( pre_bbdialog );
}

void exi_callback( w, client_data, call_data )
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	Arg		args[10];	/* Argument List */
	int		n;		/* Argument Count */

	exit( 1 );
}

void close_callback( w, client_data, call_data )
Widget		w;
Widget		client_data;
caddr_t		call_data;
{
	XtUnmanageChild( client_data );
}

