/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                  File:   MOTIF_ide_spaceball.c
 *                Author: He, Taosong
 *                  Date: 1/18/93
 *           Description: MOTIF routines for driving input device spaceball
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/PanedW.h>
#include <Xm/Scale.h>
#include <Xm/RowColumn.h>
#include <Xm/DrawingA.h>
#include <Xm/Label.h>
#include <X11/Xutil.h>
#include <varargs.h>
#include <Xm/PushB.h>
#include <Xm/BulletinB.h>
#include <Xm/DialogS.h>

#include "C_volvis.h"
#include "C_ide.h"
#include "MOTIF_windefs.h"


void spaceball_report_token(str)
char *str;
{
 extern void C_ide_report_token();
 extern Widget spaceball_token_bulletin;

  C_ide_report_token(str, spaceball_token_bulletin);
}



int C_init_spaceball()
{
   extern int gl_init_spaceball();

   return(gl_init_spaceball());
}

void C_quit_spaceball()
{
   extern gl_quit_spaceball();

   gl_quit_spaceball();
}


void spaceball_start_control(drawingarea, id)
Widget drawingarea;
XtIntervalId id;
{
    extern int monitor_timeout;
    extern XtAppContext     vv_app_context;
    extern int spaceball_test_button(); 
    extern void selection_panel_control();
    Device_Event event;
    int button;

    button = spaceball_test_button();



    if (button != -1)
     {
        event.xspacebut.type = SPACEBALLBUTTON;
        event.xspacebut.button = button;
        selection_panel_control(drawingarea, 0, &event);
     }

    if (monitor_timeout) 
      XtAppAddTimeOut(vv_app_context, SPACEBALL_TIMEOUT, 
                      spaceball_start_control, drawingarea); 
}

 
void C_ide_fill_in_spaceball_token(drawingarea)
{
  extern int  IDE_vd_active[C_MAX_WINDOW_NUMBER];
  extern void selection_panel_control();
  extern void get_data_from_spaceball();
  extern void generate_spaceball_token();
  extern void get_data_from_spaceball();
  Device_Event event;

  int window_index;
  int button;
  int flag;
  int stop;
  short trans_data[3], rota_data[3], period;

  get_data_from_spaceball(&flag, &button, trans_data, rota_data, &period);

  switch (flag)
   {
     case 1: 
        event.xspacebut.type = SPACEBALLBUTTON;
        event.xspacebut.button = button;
        selection_panel_control(drawingarea, 1, &event);        
        break;
     case 0:
        generate_spaceball_token(trans_data, rota_data, period);
        break;
     default:
        break;
   }

}


