/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*                  File: MOTIF_ide_communication.c
/*                  File: MOTIF_ide_token.c
 *                Author: He, Taosong
 *                  Date: 1/18/93
 *           Description: MOTIF  routines for tokenizer
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */
/******************************************************************/
/*               The MOTIF include file                           */
/******************************************************************/

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/PanedW.h>
#include <Xm/DrawingA.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/BulletinB.h>
#include <Xm/DialogS.h>
#include <X11/Xutil.h>

/******************************************************************/
/*                The standard C include file                     */
/******************************************************************/

#include <varargs.h>
#include <stdio.h>
#include <sys/wait.h>
#include <signal.h>

/******************************************************************/
/*                  VolVis include file                           */
/******************************************************************/

#include "C_ide.h"
#include "C_volvis.h"
#include "MOTIF_windefs.h"

extern int ide_data_pipeline[C_MAX_RD_NUMBER][2];

extern int ide_selection_pipeline[2];

extern int ide_start_end_pipeline[2];


void ide_background(drawingarea, window_index)
Widget drawingarea;
int window_index;
{
extern void C_activate_selection_queue();
extern void C_flush_select();
extern void child_drop_handler();
extern void mouse_get_token();
extern void spaceball_get_token();
extern int C_init_spaceball();
extern void background_monitor();

extern C_IDE_VD_configuration       IDE_active_config;
extern int ide_start_end_pipeline[2];

extern Widget vv_toplevel;
extern int    IDE_current_window_number;

int temp;
int i;


   XtAddEventHandler(drawingarea, LeaveWindowMask, FALSE,
                    child_drop_handler, window_index);

   C_flush_select(drawingarea);

   read(ide_start_end_pipeline[1], &temp, 5000);
   temp = 1;
   write(ide_start_end_pipeline[1], &temp, sizeof(int));

   C_activate_selection_queue(drawingarea);

   

   for (i= 0; i < C_CURRENT_RD_NUMBER; i++)
           {
             if (IDE_active_config.device_involved[i])
                {
                 switch (i)
                  {
                   case C_MOUSE:
                     mouse_get_token(drawingarea, window_index);
                     break;
                   case C_SPACEBALL:
                     if (C_init_spaceball())
                        spaceball_get_token(drawingarea, NULL);
                     break;
                   default:
                    break;
                  }
                }
             }
           background_monitor(drawingarea, window_index);
          
}

int C_ide_test_end(drawingarea)
Widget drawingarea;
{
   extern C_IDE_window_information IDE_active_window_information;
   extern int  IDE_vd_active[C_MAX_WINDOW_NUMBER];
   extern Widget vv_toplevel;
   extern int ide_start_end_pipeline[2];
   extern void IDE_add_start_end_handler();
   extern void IDE_add_leave_enter();

   int temp;

   union wait status;

   read(ide_start_end_pipeline[0], &temp, sizeof(int));

   if (temp != 2)
    {
      temp = -1;
      write(ide_start_end_pipeline[1], &temp, sizeof(int));
      return(0);
    }
   else
    {
      XFlush(XtDisplay(vv_toplevel));
      temp = 3;
      write(ide_start_end_pipeline[1], &temp, sizeof(int));
      if (wait(&status)==-1) printf("\n communication error\n");
      IDE_vd_active[IDE_active_window_information.window_index] = 0;
      IDE_add_leave_enter(drawingarea);
      IDE_add_start_end_handler(drawingarea);
      return(1);
    }
}


