/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *                  File: C_update_world_extent.c
 *                Author: Hui Chen 
 *                  Date: 04/18/92
 *           Description: Contain device-independent routine 
 *			  C_update_world_extent() to find
 *			  and update the limits of the "World". 
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */

# include <math.h>
# include <stdio.h>
# include <string.h>

#include "C_volvis.h"

/*
 *        Procedure Name: C_update_world_extent
 *          Return Value: void
 *       Input Variables: none
 *      Output Variables: none
 *      Update Variables: none
 *      Global Variables: extern C_World  world
 *			  extern C_View  view
 *    			  C_World_Extent  world_extent
 *           Description: Device-independent routine to find
 *			  and update the limits of the "World". 
 */

C_World_Extent	world_extent;

void C_update_world_extent()
{
	extern C_World  world;
	extern C_View  view;

	int i;
	float WminX, WminY, WminZ, WmaxX, WmaxY, WmaxZ;

	WmaxX = WminX = world.orig_c_sys.origin.x;
	WmaxY = WminY = world.orig_c_sys.origin.y;
	WmaxZ = WminZ = world.orig_c_sys.origin.z;
	
	if (WminX > (world.orig_c_sys.origin.x 
		     + world.orig_c_sys.x_axis.x))
	   WminX = world.orig_c_sys.origin.x 
		     + world.orig_c_sys.x_axis.x;
	if (WmaxX < (world.orig_c_sys.origin.x 
		     + world.orig_c_sys.x_axis.x))
	   WmaxX = world.orig_c_sys.origin.x 
		     + world.orig_c_sys.x_axis.x;

	if (WminX > (world.orig_c_sys.origin.x 
		     + world.orig_c_sys.y_axis.x))
	   WminX = world.orig_c_sys.origin.x 
		     + world.orig_c_sys.y_axis.x;
	if (WmaxX < (world.orig_c_sys.origin.x 
		     + world.orig_c_sys.y_axis.x))
	   WmaxX = world.orig_c_sys.origin.x 
		     + world.orig_c_sys.y_axis.x;

	if (WminX > (world.orig_c_sys.origin.x 
		     + world.orig_c_sys.z_axis.x))
	   WminX = world.orig_c_sys.origin.x 
		     + world.orig_c_sys.z_axis.x;
	if (WmaxX < (world.orig_c_sys.origin.x 
		     + world.orig_c_sys.z_axis.x))
	   WmaxX = world.orig_c_sys.origin.x 
		     + world.orig_c_sys.y_axis.x;

	if (WminY > (world.orig_c_sys.origin.y 
		     + world.orig_c_sys.x_axis.y))
	   WminY = world.orig_c_sys.origin.y 
		     + world.orig_c_sys.x_axis.y;
	if (WmaxY < (world.orig_c_sys.origin.x 
		     + world.orig_c_sys.x_axis.y))
	   WmaxY = world.orig_c_sys.origin.y 
		     + world.orig_c_sys.x_axis.y;

	if (WminY > (world.orig_c_sys.origin.y 
		     + world.orig_c_sys.y_axis.y))
	   WminY = world.orig_c_sys.origin.y 
		     + world.orig_c_sys.y_axis.y;
	if (WmaxY < (world.orig_c_sys.origin.x 
		     + world.orig_c_sys.y_axis.y))
	   WmaxY = world.orig_c_sys.origin.y 
		     + world.orig_c_sys.y_axis.y;

	if (WminY > (world.orig_c_sys.origin.y 
		     + world.orig_c_sys.z_axis.y))
	   WminY = world.orig_c_sys.origin.y 
		     + world.orig_c_sys.z_axis.y;
	if (WmaxY < (world.orig_c_sys.origin.x 
		     + world.orig_c_sys.z_axis.y))
	   WmaxY = world.orig_c_sys.origin.y 
		     + world.orig_c_sys.z_axis.y;

	if (WminZ > (world.orig_c_sys.origin.z 
		     + world.orig_c_sys.x_axis.z))
	   WminZ = world.orig_c_sys.origin.z 
		     + world.orig_c_sys.x_axis.z;
	if (WmaxZ < (world.orig_c_sys.origin.z 
		     + world.orig_c_sys.x_axis.z))
	   WmaxZ = world.orig_c_sys.origin.z 
		     + world.orig_c_sys.x_axis.z;

	if (WminZ > (world.orig_c_sys.origin.z 
		     + world.orig_c_sys.y_axis.z))
	   WminZ = world.orig_c_sys.origin.z 
		     + world.orig_c_sys.y_axis.z;
	if (WmaxZ < (world.orig_c_sys.origin.z 
		     + world.orig_c_sys.y_axis.z))
	   WmaxZ = world.orig_c_sys.origin.z 
		     + world.orig_c_sys.y_axis.z;

	if (WminZ > (world.orig_c_sys.origin.z 
		     + world.orig_c_sys.z_axis.z))
	   WminZ = world.orig_c_sys.origin.z 
		     + world.orig_c_sys.z_axis.z;
	if (WmaxZ < (world.orig_c_sys.origin.z 
		     + world.orig_c_sys.z_axis.z))
	   WmaxZ = world.orig_c_sys.origin.z 
		     + world.orig_c_sys.z_axis.z;

	for (i=0; i<world.num_volumes; i++) {
	    if (WminX > world.volume[i]->c_sys.origin.x)
	       WminX = world.volume[i]->c_sys.origin.x;
	    if (WmaxX < world.volume[i]->c_sys.origin.x)
	       WmaxX = world.volume[i]->c_sys.origin.x;
	    if (WminY > world.volume[i]->c_sys.origin.y)
	       WminY = world.volume[i]->c_sys.origin.y;
	    if (WmaxY < world.volume[i]->c_sys.origin.y)
	       WmaxY = world.volume[i]->c_sys.origin.y;
	    if (WminZ > world.volume[i]->c_sys.origin.z)
	       WminZ = world.volume[i]->c_sys.origin.z;
	    if (WmaxZ < world.volume[i]->c_sys.origin.z)
	       WmaxZ = world.volume[i]->c_sys.origin.z;
	    if (WminX > (world.volume[i]->c_sys.origin.x
			 + world.volume[i]->c_sys.x_axis.x
			 * world.volume[i]->x_size_units))
	       WminX = (world.volume[i]->c_sys.origin.x
			 + world.volume[i]->c_sys.x_axis.x
			 * world.volume[i]->x_size_units);
	    if (WmaxX < (world.volume[i]->c_sys.origin.x
			 + world.volume[i]->c_sys.x_axis.x
			 * world.volume[i]->x_size_units))
	       WmaxX = (world.volume[i]->c_sys.origin.x
			 + world.volume[i]->c_sys.x_axis.x
			 * world.volume[i]->x_size_units);

	    if (WminX > (world.volume[i]->c_sys.origin.x
			 + world.volume[i]->c_sys.y_axis.x
			 * world.volume[i]->y_size_units))
	       WminX = (world.volume[i]->c_sys.origin.x
			 + world.volume[i]->c_sys.y_axis.x
			 * world.volume[i]->y_size_units);
	    if (WmaxX < (world.volume[i]->c_sys.origin.x
			 + world.volume[i]->c_sys.y_axis.x
			 * world.volume[i]->y_size_units))
	       WmaxX = (world.volume[i]->c_sys.origin.x
			 + world.volume[i]->c_sys.y_axis.x
			 * world.volume[i]->y_size_units);

	    if (WminX > (world.volume[i]->c_sys.origin.x
			 + world.volume[i]->c_sys.z_axis.x
			 * world.volume[i]->z_size_units))
	       WminX = (world.volume[i]->c_sys.origin.x
			 + world.volume[i]->c_sys.z_axis.x
			 * world.volume[i]->z_size_units);
	    if (WmaxX < (world.volume[i]->c_sys.origin.x
			 + world.volume[i]->c_sys.z_axis.x
			 * world.volume[i]->z_size_units))
	       WmaxX = (world.volume[i]->c_sys.origin.x
			 + world.volume[i]->c_sys.z_axis.x
			 * world.volume[i]->z_size_units);

	    if (WminY > (world.volume[i]->c_sys.origin.y
			 + world.volume[i]->c_sys.x_axis.y
			 * world.volume[i]->x_size_units))
	       WminY = (world.volume[i]->c_sys.origin.y
			 + world.volume[i]->c_sys.x_axis.y
			 * world.volume[i]->x_size_units);
	    if (WmaxY < (world.volume[i]->c_sys.origin.y
			 + world.volume[i]->c_sys.x_axis.y
			 * world.volume[i]->x_size_units))
	       WmaxY = (world.volume[i]->c_sys.origin.y
			 + world.volume[i]->c_sys.x_axis.y
			 * world.volume[i]->x_size_units);

	    if (WminY > (world.volume[i]->c_sys.origin.y
			 + world.volume[i]->c_sys.y_axis.y
			 * world.volume[i]->y_size_units))
	       WminY = (world.volume[i]->c_sys.origin.y
			 + world.volume[i]->c_sys.y_axis.y
			 * world.volume[i]->y_size_units);
	    if (WmaxY < (world.volume[i]->c_sys.origin.y
			 + world.volume[i]->c_sys.y_axis.y
			 * world.volume[i]->y_size_units))
	       WmaxY = (world.volume[i]->c_sys.origin.y
			 + world.volume[i]->c_sys.y_axis.y
			 * world.volume[i]->y_size_units);

	    if (WminY > (world.volume[i]->c_sys.origin.y
			 + world.volume[i]->c_sys.z_axis.y
			 * world.volume[i]->z_size_units))
	       WminY = (world.volume[i]->c_sys.origin.y
			 + world.volume[i]->c_sys.z_axis.y
			 * world.volume[i]->z_size_units);
	    if (WmaxY < (world.volume[i]->c_sys.origin.y
			 + world.volume[i]->c_sys.z_axis.y
			 * world.volume[i]->z_size_units))
	       WmaxY = (world.volume[i]->c_sys.origin.y
			 + world.volume[i]->c_sys.z_axis.y
			 * world.volume[i]->z_size_units);

	    if (WminZ > (world.volume[i]->c_sys.origin.z
			 + world.volume[i]->c_sys.x_axis.z
			 * world.volume[i]->x_size_units))
	       WminZ = (world.volume[i]->c_sys.origin.z
			 + world.volume[i]->c_sys.x_axis.z
			 * world.volume[i]->x_size_units);
	    if (WmaxZ < (world.volume[i]->c_sys.origin.z
			 + world.volume[i]->c_sys.x_axis.z
			 * world.volume[i]->x_size_units))
	       WmaxZ = (world.volume[i]->c_sys.origin.z
			 + world.volume[i]->c_sys.x_axis.z
			 * world.volume[i]->x_size_units);

	    if (WminZ > (world.volume[i]->c_sys.origin.z
			 + world.volume[i]->c_sys.y_axis.z
			 * world.volume[i]->y_size_units))
	       WminZ = (world.volume[i]->c_sys.origin.z
			 + world.volume[i]->c_sys.y_axis.z
			 * world.volume[i]->y_size_units);
	    if (WmaxZ < (world.volume[i]->c_sys.origin.z
			 + world.volume[i]->c_sys.y_axis.z
			 * world.volume[i]->y_size_units))
	       WmaxZ = (world.volume[i]->c_sys.origin.z
			 + world.volume[i]->c_sys.y_axis.z
			 * world.volume[i]->y_size_units);

	    if (WminZ > (world.volume[i]->c_sys.origin.z
			 + world.volume[i]->c_sys.z_axis.z
			 * world.volume[i]->z_size_units))
	       WminZ = (world.volume[i]->c_sys.origin.z
			 + world.volume[i]->c_sys.z_axis.z
			 * world.volume[i]->z_size_units);
	    if (WmaxZ < (world.volume[i]->c_sys.origin.z
			 + world.volume[i]->c_sys.z_axis.z
			 * world.volume[i]->z_size_units))
	       WmaxZ = (world.volume[i]->c_sys.origin.z
			 + world.volume[i]->c_sys.z_axis.z
			 * world.volume[i]->z_size_units);
	}

	for (i=0; i<world.num_lights; i++) {
	  if (world.light[i]->light_type == C_POINT_LIGHT) {
	    if (WminX > world.light[i]->light.light_point->light_pos.x)
	       WminX = world.light[i]->light.light_point->light_pos.x;
	    if (WmaxX < world.light[i]->light.light_point->light_pos.x)
	       WmaxX = world.light[i]->light.light_point->light_pos.x;
	    if (WminY > world.light[i]->light.light_point->light_pos.y)
	       WminY = world.light[i]->light.light_point->light_pos.y;
	    if (WmaxY < world.light[i]->light.light_point->light_pos.y)
	       WmaxY = world.light[i]->light.light_point->light_pos.y;
	    if (WminZ > world.light[i]->light.light_point->light_pos.z)
	       WminZ = world.light[i]->light.light_point->light_pos.z;
	    if (WmaxZ < world.light[i]->light.light_point->light_pos.z)
	       WmaxZ = world.light[i]->light.light_point->light_pos.z;
	  }
	  else {
	    if (WminX > world.light[i]->light.light_volume->c_sys.origin.x)
	       WminX = world.light[i]->light.light_volume->c_sys.origin.x;
	    if (WmaxX < world.light[i]->light.light_volume->c_sys.origin.x)
	       WmaxX = world.light[i]->light.light_volume->c_sys.origin.x;
	    if (WminY > world.light[i]->light.light_volume->c_sys.origin.y)
	       WminY = world.light[i]->light.light_volume->c_sys.origin.y;
	    if (WmaxY < world.light[i]->light.light_volume->c_sys.origin.y)
	       WmaxY = world.light[i]->light.light_volume->c_sys.origin.y;
	    if (WminZ > world.light[i]->light.light_volume->c_sys.origin.z)
	       WminZ = world.light[i]->light.light_volume->c_sys.origin.z;
	    if (WmaxZ < world.light[i]->light.light_volume->c_sys.origin.z)
	       WmaxZ = world.light[i]->light.light_volume->c_sys.origin.z;

	    if (WminX > (world.light[i]->light.light_volume->c_sys.origin.x
			 + world.light[i]->light.light_volume->c_sys.x_axis.x
			 * world.light[i]->light.light_volume->x_size_units))
	       WminX = (world.light[i]->light.light_volume->c_sys.origin.x
			 + world.light[i]->light.light_volume->c_sys.x_axis.x
			 * world.light[i]->light.light_volume->x_size_units);
	    if (WmaxX < (world.light[i]->light.light_volume->c_sys.origin.x
			 + world.light[i]->light.light_volume->c_sys.x_axis.x
			 * world.light[i]->light.light_volume->x_size_units))
	       WmaxX = (world.light[i]->light.light_volume->c_sys.origin.x
			 + world.light[i]->light.light_volume->c_sys.x_axis.x
			 * world.light[i]->light.light_volume->x_size_units);

	    if (WminX > (world.light[i]->light.light_volume->c_sys.origin.x
			 + world.light[i]->light.light_volume->c_sys.y_axis.x
			 * world.light[i]->light.light_volume->y_size_units))
	       WminX = (world.light[i]->light.light_volume->c_sys.origin.x
			 + world.light[i]->light.light_volume->c_sys.y_axis.x
			 * world.light[i]->light.light_volume->y_size_units);
	    if (WmaxX < (world.light[i]->light.light_volume->c_sys.origin.x
			 + world.light[i]->light.light_volume->c_sys.y_axis.x
			 * world.light[i]->light.light_volume->y_size_units))
	       WmaxX = (world.light[i]->light.light_volume->c_sys.origin.x
			 + world.light[i]->light.light_volume->c_sys.y_axis.x
			 * world.light[i]->light.light_volume->y_size_units);

	    if (WminX > (world.light[i]->light.light_volume->c_sys.origin.x
			 + world.light[i]->light.light_volume->c_sys.z_axis.x
			 * world.light[i]->light.light_volume->z_size_units))
	       WminX = (world.light[i]->light.light_volume->c_sys.origin.x
			 + world.light[i]->light.light_volume->c_sys.z_axis.x
			 * world.light[i]->light.light_volume->z_size_units);
	    if (WmaxX < (world.light[i]->light.light_volume->c_sys.origin.x
			 + world.light[i]->light.light_volume->c_sys.z_axis.x
			 * world.light[i]->light.light_volume->z_size_units))
	       WmaxX = (world.light[i]->light.light_volume->c_sys.origin.x
			 + world.light[i]->light.light_volume->c_sys.z_axis.x
			 * world.light[i]->light.light_volume->z_size_units);

	    if (WminY > (world.light[i]->light.light_volume->c_sys.origin.y
			 + world.light[i]->light.light_volume->c_sys.x_axis.y
			 * world.light[i]->light.light_volume->x_size_units))
	       WminY = (world.light[i]->light.light_volume->c_sys.origin.y
			 + world.light[i]->light.light_volume->c_sys.x_axis.y
			 * world.light[i]->light.light_volume->x_size_units);
	    if (WmaxY < (world.light[i]->light.light_volume->c_sys.origin.y
			 + world.light[i]->light.light_volume->c_sys.x_axis.y
			 * world.light[i]->light.light_volume->x_size_units))
	       WmaxY = (world.light[i]->light.light_volume->c_sys.origin.y
			 + world.light[i]->light.light_volume->c_sys.x_axis.y
			 * world.light[i]->light.light_volume->x_size_units);

	    if (WminY > (world.light[i]->light.light_volume->c_sys.origin.y
			 + world.light[i]->light.light_volume->c_sys.y_axis.y
			 * world.light[i]->light.light_volume->y_size_units))
	       WminY = (world.light[i]->light.light_volume->c_sys.origin.y
			 + world.light[i]->light.light_volume->c_sys.y_axis.y
			 * world.light[i]->light.light_volume->y_size_units);
	    if (WmaxY < (world.light[i]->light.light_volume->c_sys.origin.y
			 + world.light[i]->light.light_volume->c_sys.y_axis.y
			 * world.light[i]->light.light_volume->y_size_units))
	       WmaxY = (world.light[i]->light.light_volume->c_sys.origin.y
			 + world.light[i]->light.light_volume->c_sys.y_axis.y
			 * world.light[i]->light.light_volume->y_size_units);

	    if (WminY > (world.light[i]->light.light_volume->c_sys.origin.y
			 + world.light[i]->light.light_volume->c_sys.z_axis.y
			 * world.light[i]->light.light_volume->z_size_units))
	       WminY = (world.light[i]->light.light_volume->c_sys.origin.y
			 + world.light[i]->light.light_volume->c_sys.z_axis.y
			 * world.light[i]->light.light_volume->z_size_units);
	    if (WmaxY < (world.light[i]->light.light_volume->c_sys.origin.y
			 + world.light[i]->light.light_volume->c_sys.z_axis.y
			 * world.light[i]->light.light_volume->z_size_units))
	       WmaxY = (world.light[i]->light.light_volume->c_sys.origin.y
			 + world.light[i]->light.light_volume->c_sys.z_axis.y
			 * world.light[i]->light.light_volume->z_size_units);

	    if (WminZ > (world.light[i]->light.light_volume->c_sys.origin.z
			 + world.light[i]->light.light_volume->c_sys.x_axis.z
			 * world.light[i]->light.light_volume->x_size_units))
	       WminZ = (world.light[i]->light.light_volume->c_sys.origin.z
			 + world.light[i]->light.light_volume->c_sys.x_axis.z
			 * world.light[i]->light.light_volume->x_size_units);
	    if (WmaxZ < (world.light[i]->light.light_volume->c_sys.origin.z
			 + world.light[i]->light.light_volume->c_sys.x_axis.z
			 * world.light[i]->light.light_volume->x_size_units))
	       WmaxZ = (world.light[i]->light.light_volume->c_sys.origin.z
			 + world.light[i]->light.light_volume->c_sys.x_axis.z
			 * world.light[i]->light.light_volume->x_size_units);

	    if (WminZ > (world.light[i]->light.light_volume->c_sys.origin.z
			 + world.light[i]->light.light_volume->c_sys.y_axis.z
			 * world.light[i]->light.light_volume->y_size_units))
	       WminZ = (world.light[i]->light.light_volume->c_sys.origin.z
			 + world.light[i]->light.light_volume->c_sys.y_axis.z
			 * world.light[i]->light.light_volume->y_size_units);
	    if (WmaxZ < (world.light[i]->light.light_volume->c_sys.origin.z
			 + world.light[i]->light.light_volume->c_sys.y_axis.z
			 * world.light[i]->light.light_volume->y_size_units))
	       WmaxZ = (world.light[i]->light.light_volume->c_sys.origin.z
			 + world.light[i]->light.light_volume->c_sys.y_axis.z
			 * world.light[i]->light.light_volume->y_size_units);

	    if (WminZ > (world.light[i]->light.light_volume->c_sys.origin.z
			 + world.light[i]->light.light_volume->c_sys.z_axis.z
			 * world.light[i]->light.light_volume->z_size_units))
	       WminZ = (world.light[i]->light.light_volume->c_sys.origin.z
			 + world.light[i]->light.light_volume->c_sys.z_axis.z
			 * world.light[i]->light.light_volume->z_size_units);
	    if (WmaxZ < (world.light[i]->light.light_volume->c_sys.origin.z
			 + world.light[i]->light.light_volume->c_sys.z_axis.z
			 * world.light[i]->light.light_volume->z_size_units))
	       WmaxZ = (world.light[i]->light.light_volume->c_sys.origin.z
			 + world.light[i]->light.light_volume->c_sys.z_axis.z
			 * world.light[i]->light.light_volume->z_size_units);
	  }
	}

	if (WminX > view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.)
	    WminX = view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.;

	if (WmaxX < view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.)
	    WmaxX = view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.;

	if (WminY > view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.)
	    WminY = view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.;

	if (WmaxY < view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.)
	    WmaxY = view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.;

	if (WminZ > view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2.)
	    WminZ = view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2.; 

	if (WmaxZ < view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2.)
	    WmaxZ = view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2.; 


	if (WminX > view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.
		     + view.c_sys.x_axis.x * view.width_units)
	    WminX = view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.
		     + view.c_sys.x_axis.x * view.width_units;

	if (WmaxX < view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.
		     + view.c_sys.x_axis.x * view.width_units)
	    WmaxX = view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.
		     + view.c_sys.x_axis.x * view.width_units;

	if (WminX > view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.
		     + view.c_sys.y_axis.x * view.height_units)
	    WminX = view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.
		     + view.c_sys.y_axis.x * view.height_units;

	if (WmaxX < view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.
		     + view.c_sys.y_axis.x * view.height_units)
	    WmaxX = view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.
		     + view.c_sys.y_axis.x * view.height_units;

	if (WminX > view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.
		     + view.c_sys.z_axis.x)
	    WminX = view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.
		     + view.c_sys.z_axis.x;

	if (WmaxX < view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.
		     + view.c_sys.z_axis.x)
	    WmaxX = view.c_sys.origin.x -
                     (view.c_sys.x_axis.x * view.width_units
                     + view.c_sys.y_axis.x * view.height_units)/2.
		     + view.c_sys.z_axis.x;

	if (WminY > view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.
		     + view.c_sys.x_axis.y * view.width_units)
	    WminY = view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.
		     + view.c_sys.x_axis.y * view.width_units;

	if (WmaxY < view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.
		     + view.c_sys.x_axis.y * view.width_units)
	    WmaxY = view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.
		     + view.c_sys.x_axis.y * view.width_units;

	if (WminY > view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.
		     + view.c_sys.y_axis.y * view.height_units)
	    WminY = view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.
		     + view.c_sys.y_axis.y * view.height_units;

	if (WmaxY < view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.
		     + view.c_sys.y_axis.y * view.height_units)
	    WmaxY = view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.
		     + view.c_sys.y_axis.y * view.height_units;

	if (WminY > view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.
		     + view.c_sys.z_axis.y)
	    WminY = view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.
		     + view.c_sys.z_axis.y;

	if (WmaxY < view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.
		     + view.c_sys.z_axis.y)
	    WmaxY = view.c_sys.origin.y -
                     (view.c_sys.x_axis.y * view.width_units
                     + view.c_sys.y_axis.y * view.height_units)/2.
		     + view.c_sys.z_axis.y;

	if (WminZ > view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2.
		     + view.c_sys.x_axis.z * view.width_units)
	    WminZ = view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2.
		     + view.c_sys.x_axis.z * view.width_units; 

	if (WmaxZ < view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2.
		     + view.c_sys.x_axis.z * view.width_units)
	    WmaxZ = view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2. 
		     + view.c_sys.x_axis.z * view.width_units; 

	if (WminZ > view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2.
		     + view.c_sys.y_axis.z * view.height_units)
	    WminZ = view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2.
		     + view.c_sys.y_axis.z * view.height_units; 

	if (WmaxZ < view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2.
		     + view.c_sys.y_axis.z * view.height_units)
	    WmaxZ = view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2. 
		     + view.c_sys.y_axis.z * view.height_units; 

	if (WminZ > view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2.
		     + view.c_sys.z_axis.z)
	    WminZ = view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2.
		     + view.c_sys.z_axis.z; 

	if (WmaxZ < view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2.
		     + view.c_sys.z_axis.z)
	    WmaxZ = view.c_sys.origin.z -
                     (view.c_sys.x_axis.z * view.width_units
                     + view.c_sys.y_axis.z * view.height_units)/2. 
		     + view.c_sys.z_axis.z; 

	world_extent.minx = WminX;
	world_extent.miny = WminY;
	world_extent.minz = WminZ;
	world_extent.maxx = WmaxX;
	world_extent.maxy = WmaxY;
	world_extent.maxz = WmaxZ;
}

