/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: C_update_system.c
 *		      Author: Lisa Sobierajski 
 *			Date: 6/19/93 
 *		 Description: Routines for Updating VolVis
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include "C_volvis.h"


void C_update_system( reason )
C_UpdateReason		reason;
{
	extern void	update_oco_active_opt();
	extern void	update_ivi_active_opt();
	extern void	nav_update();
	extern void	oco_update_view_display();
	extern void	update_oco_control_window();
	extern void	nav_ct_update_opt();
	extern void	oco_destroy_all_mofify_windows();
	extern void	oco_update_all_mofify_windows();

	switch( reason )
	{
	    case C_IMAGE_CREATED:

		update_ivi_active_opt();
		break;

	    case C_IMAGE_DELETED:

		update_ivi_active_opt();
		break;

	    case C_LIGHT_CREATED:

		update_oco_active_opt();
		update_oco_control_window();
		nav_update();
	    	break;

	    case C_LIGHT_DELETED:

		update_oco_active_opt();
		update_oco_control_window();
		nav_update();
	    	break;

	    case C_LIGHT_MODIFIED:

		nav_update();
		break;

	    case C_MAJOR_ENVIRONMENT_CHANGE:

		oco_destroy_all_modify_windows();
		update_oco_active_opt();
		update_oco_control_window();
		nav_update();
	    	break;

	    case C_MINOR_ENVIRONMENT_CHANGE:

		oco_update_all_modify_windows();
		update_oco_active_opt();
		update_oco_control_window();
		nav_update();
	    	break;

	    case C_VIEW_MODIFIED:

		nav_update();
		oco_update_view_display();
		break;

	    case C_VOLUME_CREATED:

		update_oco_active_opt();
		update_oco_control_window();
		update_mea_volume_opt();
		nav_ct_update_opt();
		nav_update();
	    	break;

	    case C_VOLUME_DELETED:

		update_oco_active_opt();
		update_oco_control_window();
		update_mea_volume_opt();
		nav_ct_update_opt();
		nav_update();
	    	break;

	    case C_VOLUME_SHADING_MODIFIED:

		update_oco_control_window();
		nav_update();
	    	break;

	    case C_VOLUME_COLOR_MODIFIED:

		update_oco_control_window();
		nav_update();
	    	break;

	    case C_VOLUME_DATAPROPS_MODIFIED:

		update_oco_control_window();
		nav_update();
	    	break;

	    case C_VOLUME_MODIFIED:

		update_oco_control_window();
		nav_update();
	    	break;
	}
}
