/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                      File: C_ide_init.c
 *                    Author: Rick Avila & Morita
 *                      Date: 03/07/92
 *               Description: Motif Windowing Routines Of VolVis
 *      Modification History:
 *
 *              Who?            When?           Why?
 *      --------------------------------------------------------------------
 *       Theodossiou Andreas  03/93-05/93   cse528 project
 */



/******************************************************************/
/*                The standard C include files                    */
/******************************************************************/

#include <stdio.h>
#include <string.h>


/******************************************************************/
/*                  VolVis include files                          */
/******************************************************************/
#include "C_ide.h"

/* Global Variables for program "accounting" */
C_IDE_simulation_method C_ide_simulation_method; /* Holds the device specific variables */

/*
 *        Procedure Name:  C_ide_init
 *          Return Value:  void
 *       Input Variables:  none
 *      Output Variables:  none
 *      Update Variables:  none
 *           Description:  Initialization of the three above variables
 */
void C_ide_initialize()
{
  extern C_IDE_dataglove_vpl_simulation C_ide_dataglove_vpl_simulation;

  extern int C_init_dataglove();
  extern void temp_init_operation();
  extern void C_generate_kb_map();
  extern void C_generate_mouse_map_common();
  extern void C_generate_spaceball_map_common();
  int i;


  C_ide_simulation_method.mode = C_SCREEN;
  C_ide_simulation_method.unit = C_NORMALIZED;

  /* Mouse default settings */

  C_ide_simulation_method.mouse.trans_simu = C_Traid_Mouse;
  C_ide_simulation_method.mouse.rot_simu = C_Trackball;
  C_ide_simulation_method.mouse.trans_rot_simu = C_Manual;
  C_ide_simulation_method.mouse.simulate_switch_simu = 1;


  /* Spaceball default settings */

  C_ide_simulation_method.spaceball.translate_dominate = 0;
  C_ide_simulation_method.spaceball.rotation_dominate = 0;
  C_ide_simulation_method.spaceball.acceleration_velocity_mode = 
                                           C_VELOCITY_MODE;
  C_ide_simulation_method.spaceball.rotation_rate = 0.003;
  C_ide_simulation_method.spaceball.translation_rate = 0.01;

temp_init_operation();  
  C_generate_kb_map();
  C_generate_mouse_map_common();
  C_generate_spaceball_map_common();
  
}

