/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *                  File: C_navigator.h
 *                Author: Rick Avila & Hui Chen
 *                  Date:
 *           Description:
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */

#ifdef C_MOTIF
#include <Xm/Xm.h>
#endif

/************************************************************************/
/*                                                                      */
/*                      Navigator Constants                             */
/*                                                                      */
/************************************************************************/
#define	C_NAV_MAX_FLY_SPEED		200.0	/* Maximum Fly Speed */
#define C_NAV_MIN_FLY_SPEED    	       -200.0	/* Minimum Fly Speed */
#define C_NAV_INIT_FLY_SPEED		 20.0	/* Initial Fly Speed */
#define C_NAV_INIT_FLY_SPEED_STEP	  5.0	/* Initial Fly Speed Step */
#define C_NAV_INIT_FLY_ROTATE_STEP	 20.0	/* Initial Fly Rotate Step */

#define C_PERSPECTIVE_VIEW_SCALE	10.0	/* View Scale For WireFrame */

#define C_MOVE    0
#define C_DRAW    1

#define	C_NAV_SINGLE_LIGHT	0
#define C_NAV_WHOLE_LIGHT	1

#define C_POS_X_FACE		0x01
#define C_NEG_X_FACE		0x02
#define C_POS_Y_FACE		0x04
#define C_NEG_Y_FACE		0x08
#define C_POS_Z_FACE		0x10
#define C_NEG_Z_FACE		0x20

#define	C_Is_Pos_X_Face(x)	((x)&C_POS_X_FACE)
#define	C_Is_Neg_X_Face(x)	((x)&C_NEG_X_FACE)
#define	C_Is_Pos_Y_Face(x)	((x)&C_POS_Y_FACE)
#define	C_Is_Neg_Y_Face(x)	((x)&C_NEG_Y_FACE)
#define	C_Is_Pos_Z_Face(x)	((x)&C_POS_Z_FACE)
#define	C_Is_Neg_Z_Face(x)	((x)&C_NEG_Z_FACE)

#define	C_Set_Pos_X_Face(x)	x = ((x)|C_POS_X_FACE)
#define	C_Set_Neg_X_Face(x)	x = ((x)|C_NEG_X_FACE)
#define	C_Set_Pos_Y_Face(x)	x = ((x)|C_POS_Y_FACE)
#define	C_Set_Neg_Y_Face(x)	x = ((x)|C_NEG_Y_FACE)
#define	C_Set_Pos_Z_Face(x)	x = ((x)|C_POS_Z_FACE)
#define	C_Set_Neg_Z_Face(x)	x = ((x)|C_NEG_Z_FACE)

/************************************************************************/
/*                                                                      */
/*				Navigator Enums				*/
/*                                                                      */
/************************************************************************/

/************************************************************************/
/*	Various Projection Types Supported By Navigator Windows		*/
/************************************************************************/
typedef enum
{
	C_NAV_PROJECTION,	/* Navigator Projection Window Projection */
	C_NAV_WIREFRAME,	/* Navigator Wireframe Window Projection */
	C_NAV_WIREFRAME_KEY,	/* Navigator Wireframe Key Window Projection */
        C_PARC_FRONT_PROJECTION,/* PARC Front Polygon Projection */
	C_PARC_BACK_PROJECTION	/* PARC Back Polygon Projection */
				/* Note: PARC Projections Use Navigator */
				/* Projection Window */
} C_NavProjectionType;

typedef enum
{
	C_NAV_NOFLY,
	C_NAV_FLYTHROUGH
} C_NavFlyStatus;

/*      Transformations Supported By The Navigator                      */
typedef enum
{
        C_TRANSLATE,
        C_ROTATE,
        C_SCALE
} C_TransformType;

/*      Coordinate Systems Supported By The Navigator                   */
typedef enum
{
        C_LOCAL_COORD,
        C_GLOBAL_COORD
} C_CoordType;

/*      Reference Points Supported By The Navigator                     */
typedef enum
{
        C_ORIGIN_REF,
        C_CENTER_REF,
        C_OTHER_REF
} C_ReferenceType;

/************************************************************************/
/*                                                                      */
/*                      Navigator Typedefs                              */
/*                                                                      */
/************************************************************************/

typedef struct
{
	C_X_Display	*display;
	C_X_Window	window;
	C_X_Pixmap	pixmap;
	C_X_GC		gc;
	float		near_plane;
	float		far_plane;
	int		width_pixels;
	int		height_pixels;
	C_Matrix	vol_to_view_matrix;
	C_Matrix	projection_matrix;
	int		fildes;
	int		depth;
	int		first_color_index;
} C_ExtraDrawInfo;

typedef struct
{
	/****************************************************************/
	/*	Windowing Variables Used Within Navigator 		*/
	/****************************************************************/
        C_UIWin         drawing_area;	/* Projection Drawing Area */
	C_UIWin		slider_frame;	/* Projection Slider Frame */
	C_UIWin		button_frame;	/* Projection Button Frame */
	C_UIWin		velocity_slider;/* Flight Velocity Slider */

	/****************************************************************/
	/* 	File Descriptors For Drawing Into A Starbase Window 	*/
	/****************************************************************/
	int 		fildes;		/* Projection Area */		

	/****************************************************************/
	/*	Graphics Contexts For Drawing Into A X Graphics Window	*/
	/****************************************************************/
	C_X_GC 		gc;		/* Projection Area */		
	C_X_Pixmap 	pixmap;		/* Projection Area */		

	int		width_pixels;	/* Width In Pixels */
	int		height_pixels;	/* Height In Pixels */
        long            max_zbuf;	/* Max ZBuffer Value */
        long            min_zbuf;	/* Min ZBuffer Value */
	float		near_plane[C_MAX_VOLUMES];/* Near Plane For Each Vol */
	float		far_plane[C_MAX_VOLUMES]; /* Far Plane For Each Vol */
        long		*zfront[C_MAX_VOLUMES];/* Nearest Distances To Polys */
        long		*zback[C_MAX_VOLUMES];/* Farthest Distances To Polys */
	C_Matrix	vol_to_view_matrix; /* transformation from local     */
					    /* volume in units to local      */
					    /* view in units		     */
	C_Matrix	projection_matrix;  /* perspective matrix + scaling  */
					    /* and translation to put it in  */
					    /* the range of 0 - width, and   */
					    /* 0 - height (in pixels)	     */

} C_NavProjectionWinInfo;

typedef struct
{
	/****************************************************************/
	/*	Windowing Variables Used Within Navigator 		*/
	/****************************************************************/
        C_UIWin         drawing_area;	/* Wireframe Drawing Area */

	/****************************************************************/
	/* 	File Descriptors For Drawing Into A Starbase Window 	*/
	/****************************************************************/
	int 		fildes;		/* Wireframe Area */

	/****************************************************************/
	/*	Graphics Contexts For Drawing Into A X Graphics Window	*/
	/****************************************************************/
	C_X_GC 		gc;		/* Wireframe Area */
	C_X_Pixmap	pixmap;
	C_Matrix	vol_to_view_matrix;
	C_Matrix	projection_matrix;

	C_View		view;		/* View From Wireframe Window */

        long            max_zbuf;	/* Wireframe Max ZBuffer Value */

} C_NavWireframeWinInfo;

typedef struct
{
	/****************************************************************/
	/*	Windowing Variables Used Within Navigator 		*/
	/****************************************************************/
	C_UIWin		drawing_area;	/* Wireframe Key Drawing Area */

	/****************************************************************/
	/* 	File Descriptors For Drawing Into A Starbase Window 	*/
	/****************************************************************/
	int		fildes;		/* Wireframe Key Area */

	/****************************************************************/
	/*	Graphics Contexts For Drawing Inot A X Graphics Window	*/
	/****************************************************************/
	C_X_GC		gc;		/* Wireframe Key Area */
	C_X_Pixmap	pixmap;

	C_Matrix	vol_to_view_matrix;
	C_Matrix	projection_matrix;

        long            max_zbuf;	/* Wireframe Max ZBuffer Value */
	int		width_pixels;	/* Width In Pixels */
	int		height_pixels;	/* Height In Pixels */
} C_NavWireframeKeyWinInfo;

typedef struct
{
	/****************************************************************/
	/*	Windowing Variables Used Within Navigator 		*/
	/****************************************************************/
	C_UIWin		vol[C_MAX_VOLUMES];
	C_UIWin		pulldown;
	C_UIWin		sub_menu;

	int	current_volume;	/* Currently Volume In Options Window */
	int	current_side;	/* Current Side In Options Window */
	int	previous_vol;	/* Previously Selected Volume In Options Win */	
	int	num_volumes;	/* Number Of Volumes In Options Menu */

} C_NavProjectionOptionsInfo;

typedef struct
{
	/*********************************/
	/* Projection Window Information */
	/*********************************/
	C_NavProjectionWinInfo		pj_win_info;

	/*********************************/
	/*  Wireframe Window Information */
	/*********************************/
	C_NavWireframeWinInfo		wf_win_info;

	/************************************/
	/* Wireframe Key Window Information */
	/************************************/
	C_NavWireframeKeyWinInfo	wf_key_win_info;

	/*****************************************/
	/* Projection Options Window Information */
	/*****************************************/
	C_NavProjectionOptionsInfo	pj_opt_win_info;

	/**********************************/
	/* Additional Navigator Variables */
	/**********************************/
	float	fly_speed;	/* Speed At Which To Fly Through Scene*/
	float	speed_step;	/* Increment Speed By +- This Amount */
	float	rotate_step;	/* Rotate By This Amount For Full Win */
	int	save_next_flight; /* Save Next Flight As Flight File */

} C_NavInfo;

typedef struct
{
        C_TransformType         nav_mode;
        C_CoordType             nav_coord;
        C_ReferenceType         nav_ref;
        int                     nav_option;
} C_Nav_Global;

typedef struct
{
        C_Nav_Global    global;
        C_FPosition     trans_amt;
        C_FPosition     ref_point;
} C_NavCWParam;

typedef struct
{
        C_Nav_Global    nav_global;     /* control global selection parameter */
        C_UIWin nav_text[3];             /* transfer amounts */
        C_UIWin nav_other_text[3];       /* reference point  */
        C_UIWin nav_label[3];            /* transfer amount labels */
        char *nav_label_name[3];

        C_UIWin nav_global_toggle;       /* global reference coord button */
        C_UIWin nav_local_toggle;        /* local reference coord button  */

        C_UIWin nav_global_rc;           /* all global ref. coord options */
        C_UIWin nav_pulldown;            /* all global ref. coord options */
        C_UIWin nav_option_menu;         /* all global ref. coord options */
        C_UIWin nav_options[C_MAX_VOLUMES+C_MAX_LIGHTS+1];   

        C_UIWin nav_ref_radiobox;        /* contains ref. point select buttons*/

        C_UIWin nav_bb;                  /* contains area for ref. point input*/
} C_NavCWInfo;

typedef struct
{
        int     name;
        int     axis;
        int     hlr;
} C_WF_Setup;

