/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



#include <X11/Intrinsic.h>
#include <Xm/Xm.h>

typedef struct
{
        Widget          red_slider;
        Widget          green_slider;
        Widget          blue_slider;
        Widget          draw_area;
        Display         *display;
} C_ColorSelectInfo;


typedef struct
{
	Visual			*visual;
	int			depth;
	Colormap		colormap;
	XmFontList		font_list;

	XColor			button_foreground,
				button_background,
				button_highlight,
				button_top_shadow,
				button_bottom_shadow,
				button_arm,
				button_exit;

	XColor			window_foreground,
				window_background,
				window_top_shadow,
				window_bottom_shadow;
				
} C_WindowDefs;

# define  C_Set_Color_Button( args, n, win )				\
									\
  XtSetArg( args[n], XmNforeground, win.button_foreground.pixel  ); 	\
  n++;									\
  XtSetArg( args[n], XmNbackground, win.button_background.pixel ); 	\
  n++;									\
  XtSetArg(args[n],XmNbottomShadowColor,win.button_bottom_shadow.pixel);\
  n++;									\
  XtSetArg( args[n], XmNtopShadowColor, win.button_top_shadow.pixel  ); \
  n++;									\
  XtSetArg( args[n], XmNhighlightColor, win.button_highlight.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNarmColor, win.button_arm.pixel  ); 		\
  n++;									\
  XtSetArg( args[n], XmNshadowThickness, 6 ); 				\
  n++

# define  C_Set_Color_Label( args, n, win )				\
									\
  XtSetArg( args[n], XmNforeground, win.button_background.pixel  ); 	\
  n++;									\
  XtSetArg( args[n], XmNbackground, win.window_background.pixel ); 	\
  n++

# define  C_Set_Color_PullDown( args, n, win )				\
									\
  XtSetArg( args[n], XmNvisual, win.visual );				\
  n++;									\
  XtSetArg( args[n], XmNdepth, win.depth );				\
  n++;									\
  XtSetArg( args[n], XmNcolormap, win.colormap );			\
  n++;									\
  XtSetArg( args[n], XmNdefaultFontList, win.font_list );		\
  n++;									\
  XtSetArg( args[n], XmNforeground, win.button_background.pixel  ); 	\
  n++;									\
  XtSetArg( args[n], XmNbackground, win.window_background.pixel ); 	\
  n++;									\
  XtSetArg(args[n],XmNbottomShadowColor,win.window_bottom_shadow.pixel);\
  n++;									\
  XtSetArg( args[n], XmNtopShadowColor, win.window_top_shadow.pixel  ); \
  n++;									\
  XtSetArg( args[n], XmNhighlightColor, win.button_highlight.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNshadowThickness, 3 ); 				\
  n++

# define  C_Set_Color_OptionMenu( args, n, win )			\
									\
  XtSetArg( args[n], XmNforeground, win.button_background.pixel  ); 	\
  n++;									\
  XtSetArg( args[n], XmNbackground, win.window_background.pixel ); 	\
  n++;									\
  XtSetArg(args[n],XmNbottomShadowColor,win.window_bottom_shadow.pixel);\
  n++;									\
  XtSetArg( args[n], XmNtopShadowColor, win.window_top_shadow.pixel  ); \
  n++;									\
  XtSetArg( args[n], XmNhighlightColor, win.button_highlight.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNshadowThickness, 3 ); 				\
  n++

# define  C_Set_Color_Text( args, n, win )				\
									\
  XtSetArg( args[n], XmNforeground, win.button_foreground.pixel  ); 	\
  n++;									\
  XtSetArg( args[n], XmNbackground, win.button_background.pixel ); 	\
  n++;									\
  XtSetArg(args[n],XmNbottomShadowColor,win.button_bottom_shadow.pixel);\
  n++;									\
  XtSetArg( args[n], XmNtopShadowColor, win.button_top_shadow.pixel  ); \
  n++;									\
  XtSetArg( args[n], XmNhighlightColor, win.button_highlight.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNarmColor, win.button_arm.pixel  ); 		\
  n++;									\
  XtSetArg( args[n], XmNshadowThickness, 3 ); 				\
  n++

# define  C_Set_Color_Exit_Button( args, n, win )				\
									\
  XtSetArg( args[n], XmNforeground, win.button_exit.pixel  ); 		\
  n++;									\
  XtSetArg( args[n], XmNbackground, win.button_background.pixel ); 	\
  n++;									\
  XtSetArg(args[n],XmNbottomShadowColor,win.button_bottom_shadow.pixel);\
  n++;									\
  XtSetArg( args[n], XmNtopShadowColor, win.button_top_shadow.pixel  ); \
  n++;									\
  XtSetArg( args[n], XmNhighlightColor, win.button_highlight.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNarmColor, win.button_arm.pixel  ); 		\
  n++;									\
  XtSetArg( args[n], XmNshadowThickness, 6 ); 				\
  n++

# define  C_Set_Color_Frame( args, n, win )				\
									\
  XtSetArg( args[n], XmNforeground, win.window_foreground.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNbackground, win.window_background.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNtopShadowColor, win.button_top_shadow.pixel  ); \
  n++;									\
  XtSetArg( args[n], XmNhighlightColor, win.button_highlight.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNshadowType, XmSHADOW_ETCHED_IN );		\
  n++;									\
  XtSetArg( args[n], XmNshadowThickness, 3 ); 				\
  n++

# define  C_Set_Color_RowColumn( args, n, win )				\
									\
  XtSetArg( args[n], XmNforeground, win.window_foreground.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNbackground, win.window_background.pixel ); 	\
  n++;									\
  XtSetArg(args[n],XmNbottomShadowColor,win.window_bottom_shadow.pixel);\
  n++;									\
  XtSetArg( args[n], XmNtopShadowColor, win.window_top_shadow.pixel  ); \
  n++;									\
  XtSetArg( args[n], XmNshadowThickness, 0 ); 				\
  n++

# define  C_Set_Color_Dialog( args, n, win )				\
									\
  XtSetArg( args[n], XmNvisual, win.visual );				\
  n++;									\
  XtSetArg( args[n], XmNdepth, win.depth );				\
  n++;									\
  XtSetArg( args[n], XmNcolormap, win.colormap );			\
  n++;									\
  XtSetArg( args[n], XmNdefaultFontList, win.font_list );		\
  n++;									\
  XtSetArg( args[n], XmNforeground, win.window_foreground.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNbackground, win.window_background.pixel ); 	\
  n++;									\
  XtSetArg(args[n],XmNbottomShadowColor,win.window_bottom_shadow.pixel);\
  n++;									\
  XtSetArg( args[n], XmNtopShadowColor, win.window_top_shadow.pixel  ); \
  n++;									\
  XtSetArg( args[n], XmNshadowThickness, 3 ); 				\
  n++;									\
  XtSetArg( args[n], XmNhighlightColor, win.button_highlight.pixel ); 	\
  n++

# define  C_Set_Color_Bboard( args, n, win )				\
									\
  XtSetArg( args[n], XmNforeground, win.window_foreground.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNbackground, win.window_background.pixel ); 	\
  n++;									\
  XtSetArg(args[n],XmNbottomShadowColor,win.window_bottom_shadow.pixel);\
  n++;									\
  XtSetArg( args[n], XmNtopShadowColor, win.window_top_shadow.pixel  ); \
  n++;									\
  XtSetArg( args[n], XmNhighlightColor, win.button_highlight.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNselectColor, win.button_highlight.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNshadowThickness, 0 ); 				\
  n++

# define  C_Set_Color_Scale( args, n, win )				\
									\
  XtSetArg( args[n], XmNforeground, win.window_foreground.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNbackground, win.window_background.pixel ); 	\
  n++;									\
  XtSetArg(args[n],XmNbottomShadowColor,win.window_bottom_shadow.pixel);\
  n++;									\
  XtSetArg( args[n], XmNtopShadowColor, win.window_top_shadow.pixel  ); \
  n++;									\
  XtSetArg( args[n], XmNhighlightColor, win.button_highlight.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNshadowThickness, 0 ); 				\
  n++

# define  C_Set_Color_ToggleButton( args, n, win )			\
									\
  XtSetArg( args[n], XmNforeground, win.window_foreground.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNbackground, win.window_background.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNhighlightColor, win.button_highlight.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNselectColor, win.button_highlight.pixel ); 	\
  n++;									\
  XtSetArg(args[n],XmNbottomShadowColor,win.window_bottom_shadow.pixel);\
  n++;									\
  XtSetArg( args[n], XmNtopShadowColor, win.window_top_shadow.pixel  ); \
  n++;									\
  XtSetArg( args[n], XmNshadowThickness, 0 ); 				\
  n++

# define  C_Set_Color_ToggleGadget( args, n, win )			\
									\
  XtSetArg( args[n], XmNselectColor, win.button_highlight.pixel ); 	\
  n++

# define  C_Set_Color_RadioBox( args, n, win )				\
									\
  XtSetArg( args[n], XmNforeground, win.window_foreground.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNbackground, win.window_background.pixel ); 	\
  n++;									\
  XtSetArg( args[n], XmNshadowThickness, 3 ); 				\
  n++

# define  C_Set_Color_ScrollWindow( args, n, win )                      \
                                                                        \
  XtSetArg( args[n], XmNforeground, win.window_foreground.pixel );      \
  n++;                                                                  \
  XtSetArg( args[n], XmNbackground, win.window_background.pixel );      \
  n++;                                                                  \
  XtSetArg( args[n], XmNborderWidth,0);                                 \
  n++;                                                                  \
  XtSetArg( args[n], XmNbottomShadowColor,win.button_bottom_shadow.pixel);\
  n++;                                                                  \
  XtSetArg( args[n], XmNtopShadowColor, win.button_top_shadow.pixel  ); \
  n++;                                                                  \
  XtSetArg( args[n], XmNshadowThickness, 3 );                           \
  n++

# define  C_Set_Color_ScrollBar( args, n, win )                      \
                                                                        \
  XtSetArg( args[n], XmNforeground, win.window_foreground.pixel );      \
  n++;                                                                  \
  XtSetArg( args[n], XmNbackground, win.window_background.pixel );      \
  n++;                                                                  \
  XtSetArg( args[n], XmNborderWidth,0);                                 \
  n++;                                                                  \
  XtSetArg( args[n], XmNbottomShadowColor,win.button_bottom_shadow.pixel);\
  n++;                                                                  \
  XtSetArg( args[n], XmNtopShadowColor, win.button_top_shadow.pixel  ); \
  n++;                                                                  \
  XtSetArg( args[n], XmNshadowThickness, 1 );                           \
  n++

# define  C_Set_Color_Canvas( args, n, win )                            \
                                                                        \
  XtSetArg( args[n], XmNforeground, win.button_foreground.pixel  );     \
  n++;                                                                  \
  XtSetArg( args[n], XmNbackground, win.button_background.pixel );      \
  n++

# define  C_Set_Color_DrawnButton( args, n, win )                       \
                                                                        \
  XtSetArg( args[n], XmNforeground, win.button_foreground.pixel  );     \
  n++;                                                                  \
  XtSetArg( args[n], XmNbackground, win.button_background.pixel );      \
  n++;                                                                  \
  XtSetArg( args[n], XmNhighlightColor, win.button_highlight.pixel );   \
  n++

