/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *			File: C_fio.h
 *		      Author: 
 *			Date: //92
 *		 Description: Routines Of VolVis
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/BulletinB.h>
#include <Xm/PushB.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/Text.h>
#include <Xm/List.h>
#include <Xm/ScrolledW.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>

#define	C_ICON_WIDTH		120	/* the width of the icon 	   */
#define C_ICON_HEIGHT       	120	/* the height of the icon          */
#define C_ICON_IMAGE_HEIGHT 	100	/* the height of image on the icon */
#define C_ICON_IMAGE_WIDTH  	100	/* the width of image on the icon  */
#define C_MAX_ICON_PER_WINDOW   6       /* max number of icons pre window  */
#define C_FIO_MAXFILES      	200     /* max number of files in a directory*/

/* directions we move into a slice file */
#define C_XY_Z          	1	/* moving in Z direction */	
#define C_XZ_Y          	2	/* moving in Y direction */
#define C_YZ_X          	3	/* moving in X direction */

typedef struct {
        char        	filename[C_MAX_STRING];
        char        	pathname[C_MAX_STRING];
        Widget      	canvas;
        Widget      	message;
        Widget      	scrollbar;
        Widget      	path_text;
        Widget      	file_text;
}Fio_Dialog_Info;

typedef struct {
        int         		x_voxels;
        int         		y_voxels;
        int         		z_voxels;
        int         		bits_per_voxel;
        float       		x_units;
        float       		y_units;
        float       		z_units;
        C_UnitType  		unit_type;
        C_DataOrigin        	data_origin;
        C_DataModification  	data_modification;
        C_CompressionType   	data_compression;
}Slice_Header_Info;

typedef struct
{
        int             references;
        int             xres;
        int             yres;
        int             zres;

}Texture_Header_Info;

typedef struct
{
        float           	compute_time;
        int             	compute_shadows;
        int             	levels_of_reflection;
        int             	levels_of_transmission;
        int             	levels_of_indirect_light;
        int             	width;
        int             	height;
        int             	depth;
        C_RenderingType     	render_type;
        C_ImageAccuracy     	image_accuracy;
        C_CompressionType   	compress_type;
} Image_Header_Info;

typedef struct
{
	int		x_voxels;
	int		y_voxels;
 	int		z_voxels;
	C_UnitType	unit_type;
	float		x_unit;
	float		y_unit;
	float		z_unit;
	float		fun_x_min;
	float		fun_x_max;
	float		fun_y_min;
	float		fun_y_max;
	float		fun_z_min;
	float		fun_z_max;
 	float		map_to_0;
 	float		map_to_255;
	float		segment_at;
	int		invert_function_value;
	char		function[560];
} Function_Header_Info; 		

typedef struct
{
        unsigned char   *red;
        unsigned char   *green;
        unsigned char   *blue;
} Texture_Data;

typedef struct {
        char              	*filename;
        char              	*path;
        Widget            	button;
        GC                	gc;
        unsigned char     	*icon_8_data;
        unsigned int      	*icon_24_data;
        Slice_Header_Info       slice_info;
        Texture_Header_Info     texture_info;
        Image_Header_Info       image_info;
	Function_Header_Info	function_info;
	int		  	used_bitmap;
	C_FileType		file_type;
	int			valid_file;
	char			error_msg[C_MAX_STRING];

}Icon_Info;                   /* all information about one icon */

typedef struct
{
        C_FileType      	save_type;
        C_FileType      	load_type;
	int			num_load_icon;
	int			last_load_icon;
	int			num_save_icon;
	int			last_save_icon;
	int			current_save_icon;
	Pixmap			fun_pixmap;
	Pixmap			env_pixmap;
	Pixmap			error_pixmap;
	Fio_Dialog_Info 	*load_data;
	Fio_Dialog_Info		*save_data;
} C_FileIOInfo;


