/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                  File: C_enums.h
 *                Author: Lisa Sobierajski & Rick Avila
 *                  Date:
 *           Description:
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */

/************************************************************************/
/*                                                                      */
/*	                      Enums					*/
/*                                                                      */
/************************************************************************/

/*	Data types supported by these algorithms.  C_SCANNED_DATA	*/
/*	is used for medical, biological, and scan converted  data,	*/
/*	while C_GEOMETRIC_DATA is used for data with geometric		*/
/*	descriptions.							*/
typedef enum
{
	C_SCALAR_DATA_8BIT,
	C_SCALAR_DATA_16BIT,
	C_SCALAR_DATA_32BIT,
	C_GEOMETRIC_DATA
} C_DataType;

typedef enum
{
	C_BIORAD_CONFOCAL_DATA,
	C_MAGNETIC_RESONANCE_DATA,
	C_COMPUTED_TOMOGRAPHY_DATA,
	C_SIMULATION_DATA,
	C_BINARY_VOXELIZED_DATA,
	C_FUZZY_VOXELIZED_DATA,
	C_FUN_VOXELIZED_DATA,
	C_OTHER_DATA_ORIGIN
} C_DataOrigin;	

typedef enum
{
	C_ORIGINAL_DATA,
	C_RESAMPLED_DATA,
	C_RESAMPLED_FILTERED_DATA,
	C_FILTERED_DATA,
	C_OTHER_DATA_MODIFICATION
} C_DataModification;

/*	File types which are supported by the load and save functions   */
typedef enum
{
	C_SLICE_FILE,
	C_TEXTURE_FILE,
	C_IMAGE_FILE,
	C_ANIMATION_FILE,
	C_FUNCTION_FILE,
	C_GEOMETRIC_FILE,
	C_ENVIRONMENT_FILE
} C_FileType;

/*	User levels	*/
typedef enum
{
        C_BEGINNER,
        C_PROFICIENT

} C_UserType;


/*	Segmentation types supported. 					*/
/*	C_OPACITY_ARRAY	- An array of opacity values specifies the	*/
/*			  opacity value for each possible voxel value.	*/
typedef enum
{
	C_ISO_SURFACE,
	C_SCALAR_OPACITY,
	C_SCALAR_GRADIENT_OPACITY
} C_SegType;

/*	Local shading model types for a volume:				*/
/*	C_SIMPLE_SHADE  - Only one set of values for the whole volume	*/
/*	C_ARRAY_SHADE   - An array of shading parameters indexed by     */
/*			  the object color (3 bits red, 3 bits green,   */
/*			  2 bits blue)					*/
typedef enum
{
	C_SIMPLE_SHADE,
	C_ARRAY_SHADE,
	C_NO_SHADE
} C_ShadeType;

/*	Color types for volumes supported. 				*/
/*	C_TEXTURE_COLOR	- Only use the texture given within the volume	*/
/*	C_SINGLE_COLOR	- Use a single color for the entire volume	*/
/*	C_COLOR_ARRAY	- Use an array of colors indexed by voxel value	*/
typedef enum
{
	C_TEXTURE_COLOR,
	C_SINGLE_COLOR,
	C_COLOR_ARRAY
} C_ColorType;

/*	Texture types supported.					*/
/*	C_????????	- To be added later...				*/
typedef enum
{
	C_NO_TEXTURE,
	C_VOLUME_TEXTURE,
	C_RAD_TEXTURE
} C_TextureType;

typedef enum
{
	C_PLANE_CUT,
	C_SPHERE_CUT,
	C_SIMPLE_BOX_CUT
} C_CutType;

typedef enum
{
	C_SHOW_SCALAR_VALUE,
	C_SHADE_SCALAR_VALUE,
	C_SHADE
} C_CutShadeType;

/*	Light types supported.						*/
/*	C_POINT_LIGHT	- A single point light source			*/
/*	C_VOLUME_LIGHT	- A volume acting as a light source		*/
typedef enum
{
	C_POINT_LIGHT,
	C_VOLUME_LIGHT
} C_LightType;

/*	Geometric objects supported					*/
/*	C_SPHERE	    - A solid sphere				*/
/*	C_HOLLOW_SPHERE	    - A hollow sphere				*/
/*	C_POLYGON	    - A convex polygon				*/
/*	C_MULTIPOLY	    - Multiple polygons for one solid object	*/
/*	C_HOLLOW_MULTIPOLY  - Multiple polygons for one hollow object	*/
/*	C_CONE		    - A solid cone				*/
/*	C_HOLLOW_CONE	    - A hollow cone				*/
/*	C_CYLINDER	    - A solid cylinder				*/
/*	C_HOLLOW_CYLINDER   - A hollow cylinder				*/
/*	C_SPRING	    - A solid spring				*/
/*	C_HOLLOW_SPRING	    - A hollow spring				*/
/*	C_TORUS		    - A solid torus				*/
/*	C_HOLLOW_TORUS 	    - A hollow torus				*/
typedef enum
{
	C_SPHERE,
	C_HOLLOW_SPHERE,
	C_POLYGON,
	C_MULTIPOLY,
	C_HOLLOW_MULTIPOLY,
	C_CONE,
	C_HOLLOW_CONE,
	C_CYLINDER,
	C_HOLLOW_CYLINDER,
	C_SPRING,
	C_HOLLOW_SPRING,
	C_TORUS,
	C_HOLLOW_TORUS
} C_GeoType;

/*	Matrix Multiplication types supported.				*/
/*	C_PRE_MULTIPLY	-						*/
/*	C_POST_MULTIPLY	-						*/
typedef enum
{
	C_PRE_MULTIPLY,
	C_POST_MULTIPLY
} C_MatMultType;

/*	Names for the six faces of a cube				*/
typedef enum
{
	C_PLUS_X_FACE,
	C_MINUS_X_FACE,
	C_PLUS_Y_FACE,
	C_MINUS_Y_FACE,
	C_PLUS_Z_FACE,
	C_MINUS_Z_FACE
} C_FaceType;

/*	Names for scan conversion increments - direction of the 	*/
/*	previous increment						*/
typedef enum
{
	C_X_STEP,
	C_Y_STEP,
	C_Z_STEP,
	C_UNDEFINED_STEP
} C_StepType;
 
/*	Projection types supported.					*/
typedef enum
{
	C_PARC,
	C_RAY_TRACE,
	C_VOLRAD
} C_ProjectionType;

typedef enum
{
	C_NO_SUPER_SAMPLE,
	C_LOW_SUPER_SAMPLE,
	C_MEDIUM_SUPER_SAMPLE,
	C_HIGH_SUPER_SAMPLE
} C_SuperSampleType;

typedef enum
{
	C_X_AXIS,
	C_Y_AXIS,
	C_Z_AXIS
} C_AxisType;

/*	Unit Types Supported For Data Input.				*/
/*	C_METER_UNIT		- A Unit Refers To A Meter 		*/
/*	C_MILLIMETER_UNIT	- A Unit Refers To A Millimeter 	*/
/*	C_MICRON_UNIT		- A Unit Refers To A Micron Distance	*/
/*	C_FOOT_UNIT		- A Unit Refers To A Foot Distance	*/
/*	C_INCH_UNIT		- A Unit Refers To An Inch Distance	*/
typedef enum
{
	C_METER_UNIT,
	C_MILLIMETER_UNIT,
	C_MICRON_UNIT,
	C_FOOT_UNIT,
	C_INCH_UNIT

} C_UnitType;

/*	Interpolation Types Supported During Scanned Data Input.	*/
/*	C_NO_INTERP		- Do Not Perform Interpolation		*/
/*	C_LINEAR_INTERP		- Linearly Interpolate Input Data 	*/
typedef enum
{
	C_NO_INTERP,
	C_LINEAR_INTERP
} C_InterpType;


typedef enum
{
        C_NO_COMPRESSION,
        C_RUN_LENGTH_ENCODE
} C_CompressionType;

/* PARC Subvolume & Object Surface Intersection flags */
typedef enum
{
	C_NOTHING_FOUND,
	C_LOW_FOUND,
	C_HIGH_FOUND,
	C_SURFACE_FOUND
} C_ParcSubdivideType;

typedef enum
{
	C_PARC_FRONT_FACE,
	C_PARC_BACK_FACE
} C_ParcFaceType;

typedef enum
{
	C_LOW_IMAGE_ACCURACY,
	C_MEDIUM_IMAGE_ACCURACY,
	C_HIGH_IMAGE_ACCURACY
} C_ImageAccuracy;

typedef enum
{
	C_PARC_RENDERING,
	C_RAYTRACE_RENDERING,
	C_PARC_RAYTRACE_RENDERING,
	C_NAVIGATOR_RENDERING,
	C_RADIOSITY_RENDERING
} C_RenderingType;

typedef enum
{
        C_NORMAL_STATUS,
        C_ERROR_STATUS,
        C_CANCEL_STATUS,
	C_MISMATCH_STATUS
} C_ReturnStatus;
 


typedef enum
{
        C_VOLUME_CREATED,
        C_VOLUME_DELETED,
        C_VOLUME_SHADING_MODIFIED,
        C_VOLUME_COLOR_MODIFIED,
        C_VOLUME_TEXTURE_MODIFIED,
        C_VOLUME_DATAPROPS_MODIFIED,
        C_VOLUME_LOCATION_MODIFIED,
        C_VOLUME_MODIFIED,
        C_LIGHT_CREATED,
        C_LIGHT_DELETED,
        C_LIGHT_COLOR_MODIFIED,
        C_LIGHT_LOCATION_MODIFIED,
        C_LIGHT_MODIFIED,
        C_IMAGE_CREATED,
        C_IMAGE_DELETED,
        C_IMAGE_MODIFIED,
        C_VIEW_MODIFIED,
	C_MAJOR_ENVIRONMENT_CHANGE,
	C_MINOR_ENVIRONMENT_CHANGE
} C_UpdateReason;

typedef enum
{
        C_MEA_INVALID,
        C_MEA_VALID
} C_MeasureFlag;
 

