
/* Copyright (C) 1992  AHPCRC, Univeristy of Minnesota
 * Earlier versions Copyright 1992,  Minnesota Supercomputer Center Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file named 'Copying'; if not, write to
 * the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139.
 */

/* Author:
 *	Ken Chin-Purcell (ken@ahpcrc.umn.edu)
 *	Army High Performance Computing Research Center (AHPCRC)
 *	Univeristy of Minnesota
 *
 * $Header: /usr/people/ken/gvl/bob/RCS/bob.h,v 2.2 92/10/27 16:50:13 ken Exp Locker: ken $
 *
 * $Log:	bob.h,v $
 * Revision 2.2  92/10/27  16:50:13  ken
 * Added basic point support
 * 
 * Revision 2.1  92/10/19  17:03:33  ken
 * *** empty log message ***
 * 
 * Revision 1.1  92/10/19  17:02:59  ken
 * Initial revision
 * 
 */


typedef struct _BobFile {
    char		*fname;
    XmString		listEntry;
    int			fd;
    int			shmid;
    unsigned char	*data;
    unsigned		dim[3];
    unsigned		offset;
    unsigned		blockSize;
    unsigned		nframe;
    unsigned		firstFrame;
} BobFile;

typedef struct _BobFrame {
    BobFile		*bobFile;
    unsigned		seek;
} BobFrame;

typedef struct _BobApp {
    Display		*display;
    XtAppContext	app;
    Widget		shell;

    int			running;
    int			help;
    int			debug;
    unsigned		fileSave;

    unsigned		fastRate;
    unsigned		fastStride[3];
    float		polyRate;
    Boolean		singleBuffer;
    int			fieldOfView;
    float		eyeSep;
    float		eyeDist;
    unsigned		blend;

    String		cmapName;
    String		amapName;
    String		defName;
    String		scaleText;
    String		bugAddress;
    String		followName;
    FILE		*followFile;

    Window		vwin;			/* vox window */
    unsigned		vwidth, vheight;
    Trackball		*vball;

    Window		fwin;			/* finder window */
    unsigned		fwidth, fheight;
    Trackball		*fball;
    
    Window		swin;			/* stereo window */
    unsigned		swidth, sheight;
    unsigned		stereo;

    BobFile		*file;
    unsigned		iframe;
    SkipList		fileList;
    SkipStack		frameList;
    SkipStack		dimList;
    SkipStack		pointList;

    unsigned		useRatio;
    int			parked;
    float		dimRatio[3];
    float		dimScale[3];
    unsigned		stride;
    unsigned		dataDim[3];
    unsigned		dataOffset[3];
    unsigned		voxDim[3][3];
    float		*voxPos[3][3];
    unsigned char	*cdata[3];
    unsigned char	*faces[3];

    float		*allpoint;
    unsigned		nallpoint;
    float		*point;
    unsigned		npoint;
    int			pstride;
    int			poffset;
    int			psize;
    String		pcolorName;
    float		pcolor[3];

    Atom		xaColormap;
    Atom		xaAlphamap;
    Atom		xaInterest;
    Atom		xaBobfile;
    Atom		xaRenderInfo;
    unsigned		ownSelect;
    
    XtWorkProcId	spinWP;
    XtWorkProcId	animateWP;

    Boolean		anBGR;
    Boolean		anPixmode;
    FILE		*anFile;
    char		*anFileName;
    unsigned		anOffset;
    unsigned		anFrame;
    unsigned		anStep;
    int			anFrameInc;
    unsigned		anWidth;
    unsigned		anHeight;
    unsigned		anImageSize;
    unsigned long	*anImage;
    int			anFollow;

    long		bgColor;		
    String		bgColorName;

    int			fog;
    float		fogDensity;

    float		afact;
    float		ctab[256][4];
    float		atab[256];
} BobApp;

extern BobApp		*bob;

#define CLASS_NAME	"Bob"
#define MEMFILE 	"/dev/mem/"

typedef enum _ButtonEnum {
    ButOpen, ButSave, ButStartCmap, ButStartAmap, ButQuit, 
    ButStereo, ButHome, ButFlipX, ButFlipY, ButFlipZ, 
    ButDimActive, ButDimApply, ButDimAdd, ButDimDelete,
    ButAnGo, ButAnDone, ButAxisX, ButAxisY, ButAxisZ,
    ButPoint, ButRender
} ButtonEnum;

typedef enum _ToggleEnum {
    TogBuffer, TogBright, TogBounds, TogAnnotate, TogSoft,
    TogInterpolate, TogColorBar, TogDimActive, TogAnSave, TogMaxVal
} ToggleEnum;

typedef enum _FileEnum {
    FileOK, FileCancel
} FileEnum;

typedef enum _ScaleEnum {
    ScaleAlpha, ScaleFrame,
    ScaleCenterX, ScaleCenterY, ScaleCenterZ, ScaleStride,
    ScaleSizeX, ScaleSizeY, ScaleSizeZ, ScaleSizeM
} ScaleEnum;

typedef enum _ListEnum {
    ListFile, ListDim
} ListEnum;


/* Prototypes */

/* bob.c */
void	CheckDimension (int dim [3 ], int *maxdim, int center [3 ], int *stride);
void	GetDimWidgets (int dim [3 ], int *maxdim, int center [3 ], int *stride);
void	SetDimWidgets (int dim [3 ], int *maxdim, int center [3 ], int *stride);
void	CoordinateDimensions (void);
void	AddDimEntry (char *dimline);
void	SetCurrentFile (BobFile *bfile);
void	SetFirstFile (void);
void	SaveAnimationFrame (void);
void	FollowInput (XtPointer cdata, int *fd, XtInputId *xid);
Boolean	SpinCB (XtPointer closure);
Boolean	AnimateCB (XtPointer closure);
void	VoxExposeCB (Widget w, XtPointer closure, XtPointer callData);
void	VoxInitCB (Widget w, XtPointer closure, XtPointer callData);
void	VoxResizeCB (Widget w, XtPointer closure, XtPointer callData);
void	VoxInputCB (Widget w, XtPointer closure, XtPointer callData);
void	StereoExposeCB (Widget w, XtPointer closure, XtPointer callData);
void	StereoInitCB (Widget w, XtPointer closure, XtPointer callData);
void	StereoResizeCB (Widget w, XtPointer closure, XtPointer callData);
void	StereoInputCB (Widget w, XtPointer closure, XtPointer callData);
void	FinderExposeCB (Widget w, XtPointer closure, XtPointer callData);
void	FinderInitCB (Widget w, XtPointer closure, XtPointer callData);
void	FinderResizeCB (Widget w, XtPointer closure, XtPointer callData);
void	FinderInputCB (Widget w, XtPointer closure, XtPointer callData);
void	ButtonCB (Widget w, XtPointer closure, XtPointer callData);
void	ToggleCB (Widget w, XtPointer closure, XtPointer callData);
void	FileCB (Widget w, XtPointer closure, XtPointer callData);
void	ListCB (Widget w, XtPointer closure, XtPointer callData);
void	ScaleCB (Widget w, XtPointer closure, XtPointer callData);
void	BugCB (Widget w, XtPointer closure, XtPointer callData);
int	main	(int argc, char *argv []);
