/* command line creator/analyzer for showpix */
#include "showpix.h"


int clp;
char cline[1000];

void buildcline(int argc, char **argv)
{
    int i, j;
    char c, *e;
    FILE *f;

    cline[0]=0;

    if ((e=getenv("SHOWPIX")) != NULL)
         strcat(cline, e);

    for (i=1; i<argc; i++) {
         strcat(cline, " ");

         if (argv[i][0] != '@')
              strcat(cline, argv[i]);
         else {
              /* add the file in the line */
              j=strlen(cline);

              f=fopen(argv[i]+1, "r");

              if (f==NULL) {
                   printf("%s, unable to open the file.", argv[i]);
                   exit(-1);
                   }

              while( (c=getc(f)) != EOF)
                   cline[j++]=c;

              fclose(f);

              cline[j]=0;
              }
         }

    clp=0;
    while (isspace(cline[clp]))
         clp++;
}



int nextchr(int *nc)
{
    int tc, cllp;

    if (isspace(cline[clp]))
         tc=' ';
    else
         tc=cline[clp];

    if (cline[clp]==0)
         *nc=0;
    else {
         cllp=clp+1;
         while(isspace(cline[cllp]))
              cllp++;
         *nc=cline[cllp];
         clp++;
         }


    return tc;
}



int nextarg(char *a)
{
    int i=0, nc, nnc, inp=0;

remake:
    while(isspace(cline[clp]))
         clp++;

    if ((nc=nextchr(&nnc)) == 0)
         return -1;

makearg:
    if (nc==0 || (nc==' ' && inp==0 && nnc!='('))
         goto endarg;

    a[i++]=nc;
    if (nc=='(')
         inp=1;
    if (nc==')')
         inp=0;

    if (nnc=='+')
         goto endarg;

    nc=nextchr(&nnc);
    goto makearg;

endarg:
    a[i]=0;

    if (0==strcmp(a, "+"))
         goto remake;

    return 1;
}



void setopt(int *whatopt, char c)
{
    if (c=='n')
         *whatopt=NO;
    else
         *whatopt=YES;
}



void analoption(char *s)
{
    int i;
    long l;

    if (0==strncmp(s, "-a", 2))
         setopt(&autosave, s[2]);
    else if (0==strcmp(s, "-r"))
         options=REDPLANE;
    else if (0==strcmp(s, "-g"))
         options=GREENPLANE;
    else if (0==strcmp(s, "-b"))
         options=BLUEPLANE;
    else if (0==strcmp(s, "-f"))
         options=FULLCOLORS;
    else if (0==strcmp(s, "-m"))
         options=MONOCHROME;
    else if (0==strncmp(s, "-c", 2))
         setopt(&centering, s[2]);
    else if (0==strncmp(s, "-s", 2))
         setopt(&showtitle, s[2]);
    else if (0==strcmp(s, "-k")) {
         imagewait=31536000L;
         titlewait=imagewait;
         }
    else if (0==strncmp(s, "-w", 2))
         if (1==sscanf(s+2, "%ld", &l))
              imagewait=l;
         else {
              returntotext();
              puts("The -w option expects a number.");
              exit(-1);
              }
    else if (0==strncmp(s, "-W", 2))
         if (1==sscanf(s+2, "%ld", &l))
              titlewait=l;
         else {
              returntotext();
              puts("The -W option expects number.");
              exit(-1);
              }

    else if (0==strncmp(s, "-tl", 3)) {
         options=TRICKYL;

         strcpy(trickyd, s+3);
         if (trickyd[0]==0) {
              trickyd[0]='0';
              trickyd[1]='2';
              trickyd[2]=0;
              }

         tricklen=strlen(trickyd);
         for (i=0; i<tricklen; i++) {
              if (trickyd[i]<'0' || trickyd[i]>'5') {
                   returntotext();
                   puts("Illegal value in tricky mode pattern.");
                   exit(-1);
                   }

              trickyd[i]-='0';
              }
         }

    else if (0==strcmp(s, "-ts"))
         options=TRICKYS;

    else if (0==strcmp(s, "-tS"))
         options=TRICKY2S;

    else if (0==strncmp(s, "-v", 2))
         if (1==sscanf(s+2, "%d", &i))
              videomode=i;
         else {
              returntotext();
              puts("The -v option expects a video adapter number.");
              exit(-1);
              }

    else {
         returntotext();
         printf("Unknown option %s.\n", s);
         exit(-1);
         }
}


int getnextname(char *n)
{
begin:
    if (nextarg(n)==-1)
         return -1;

    if (n[0]=='-') {
         analoption(n);
         goto begin;
         }

    return 1;
}
