		NAME	V320x200
		TITLE	Standard VGA - 320 x 200 image display.
		PAGE	132,60

		.MODEL	LARGE,C

		EXTRN	EMS_base:PROC
		EXTRN	EMS_map:PROC


VideoBufferSeg	=   	0A000H


GetEMSByte	MACRO	hdl, pag	;; Get next byte from EMS (remapping afterwards if required)
		local	blark
		lodsb			;; Get byte from DS:SI
		test	si,4000H	;; Check if we've got to the end of the page
		jz	blark
		inc	(pag)		;; Next page number
		push	ax
		mov	ax,(pag)
		push	ax
		mov	ax,(hdl)
		push	ax
		call	EMS_map
		add	sp,4
		pop	ax
		mov	si,base_ofs
blark:
		ENDM


		.CODE


		SUBTTL	vga320x200_decodeEMS
		PAGE

		COMMENT	$

Name:		vga320x200_decodeEMS

Function:	Decodes a VORT run-length encoded colour mapped image
		from EMS memory to PVGA front or back image buffer.

Caller:		Microsoft C

		void	vga320x200_decodeEMS(EMS_h, EMS_ofs, x, y, xlen, ylen)
		UINT	EMS_h;			/* EMS handle */
		ULONG	EMS_ofs;		/* linear offset with EMS pages */
		int	x, y, xlen, ylen;	/* position and size */

		$


public vga320x200_EMSdecode
vga320x200_EMSdecode	proc	uses di si ds es, EMS_h:WORD, EMS_ofs:DWORD, x:WORD, y:WORD, xlen:WORD, ylen:WORD
		LOCAL	j:WORD
		LOCAL	i:WORD
		LOCAL	pg:WORD
		LOCAL	base_ofs:WORD
		LOCAL	len_l:WORD
		LOCAL	len_h:WORD

		call	EMS_base	; Get address of page frame into DX:AX
		push	dx		; Save segment part of EMS base addr
		mov	si,ax		; Setup DS:SI with source data pointer
		mov	base_ofs,ax	; Save offset for later reference

					; Calculate page # and page offset
		mov	ax,WORD PTR (EMS_ofs)
		mov	dx,WORD PTR (EMS_ofs+2)
		mov	bx,ax
		and	bx,03FFFH	; Lower 14 bits are offset into page
		add	si,bx
		rcl	ax,1		; Upper 18 bits is page 
		rcl	dx,1
		rcl	ax,1
		rcl	dx,1
		mov	pg,dx
		push	dx
		mov	ax,EMS_h	; Map in starting page
		push	ax
		call	EMS_map		; Map in EMS page (we presume no errors)
		add	sp,4

		mov	ax,ylen		; Width of image
		mov	j,ax

		mov	ax,320		; Calc starting buffer offset of destination
		mul	y
		add	ax,x
		adc	dx,0		; dx:ax = y*320 + x;
		mov	di,ax
		mov	ax,VideoBufferSeg
		mov	es,ax		; Video offset is ES:DI

decode_it:
		pop	ds		; Load EMS base address segment
		mov	ch,0		; Zap high byte of repeat counter

		GetEMSByte EMS_h, pg	; Load 4 byte image length value (one byte at a time)
		mov	ah,al
		GetEMSByte EMS_h, pg
		xchg	ah,al
		mov	len_l,ax	; Save LSB

		GetEMSByte EMS_h, pg
		mov	ah,al
		GetEMSByte EMS_h, pg
		xchg	ah,al
		mov	len_h,ax	; Save MSB

decode_1:
		cmp	len_l,0
		jnz	bloot2		; Continue if not zero
		cmp	len_h,0
		jnz	bloot2
		jmp	decode_x	; Exit if no more bytes in image
bloot2:
		mov	bx,xlen		; X width
		push	di		; Save destination offset

decode_2:
		cmp	bx,0
		jnz	decode_2_1
		jmp	decode_10	; JIF finished this row
decode_2_1:
		; Put in a test for LEN_L == 0 ???
		sub	len_l,1		; One less byte in the image data
		jnc	bloot3
		dec	len_h
bloot3:
		GetEMSByte EMS_h, pg	; Get next byte (rnnnnnnn)
		mov	cl,al		; Run length (?nnnnnnn)
		test	al,80H		; Test top bit (r???????)
		jnz	decode_3	; JIF top bit set

		inc	cx		; Run of 0 bytes is actually a run of 1 byte
					; Set next "run" bytes of image to *(DS:SI)
		sub	bx,cx		; Calc bytes remaining on this row
		sub	len_l,1		; One less byte in the image data
		jnc	bloot4
		dec	len_h
bloot4:
		GetEMSByte EMS_h, pg	; Get value to replicate
		rep	stosb		; Replicate
		jmp	short decode_2	; Go for next bit of encoded image

decode_3:
		and	cl,07FH		; Zap top bit - make run length
		sub	bx,cx		; Calc bytes remaining on this row
		sub	len_l,cx	; Bytes remaining in image
		jnc	bloot5
		dec	len_h
bloot5:
		push	dx		; CX is bytes to copy - ensure we don't run over end of EMS page
		mov	dx,si
		add	dx,cx
		test	dx,04000H
		jz	decode_4	; JIF run will fit into current EMS page
					; We will run over into next page
		sub	dx,4000H	; # bytes into next page
		mov	cx,4000H	; # bytes to end of current page
		sub	cx,si
		jcxz	bloot6
		rep	movsb		; Copy the bytes
bloot6:
		mov	cx,dx		; Remainder to copy
		mov	si,base_ofs	; Start at beginning of new page
		push	cx
		push	es
		push	di
		inc	pg		; Map in next EMS page
		mov	ax,pg
		push	ax
		mov	ax,EMS_h
		push	ax
		call	EMS_map
		add	sp,4
		pop	di
		pop	es
		pop	cx
decode_4:
		pop	dx
		jcxz	bloot7		; Test for safety sake
		rep	movsb		; Copy bytes in image to video buffer
bloot7:
		jmp	decode_2	; Go for next bit of encoded image

decode_10:				; End of image line
		dec	j		; One less row
		; Test for j == 0 here ?
		pop	di		; Restore start of destination line we've just done
		add	di,320		; Next video buffer line
		jmp	decode_1

decode_x:
		ret

vga320x200_EMSdecode	endp


		end

