#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <unistd.h>
#include "art.h"

#define HOSTSFILE	"/usr/local/lib/vort/hosts"

extern char	*rindex();

typedef struct h {
	int	fd;
	int	x, y;
	int	xdiff, ydiff;
	int	busy;
} host;

/*
 * sendshort
 *
 *	send a short down a sockect
 */
sendshort(sock, i)
	int	sock, i;
{
	unsigned short	val;

	val = htons(i);
	write(sock, &val, sizeof(unsigned short));
}

/*
 * main driver for distributed dart.
 */
main(ac, av)
	int	ac;
	char	*av[];
{
	int			sock, pending;
	struct sockaddr_in	server;
	struct servent		*sp;
	struct hostent		*hp, *gethostbyname();
	unsigned short		len, screenx, screeny, preprocess;
	int			i, j, x, y, nc, xfragsize, yfragsize;
	int			xdiff, ydiff, nhosts;
	char			buf[1024], c, map[100 * 100 * 3];
	char			*p, *endp, *title, name[100];
	image			*im;
	long			imagestart;
	host			hosts[20];
	FILE			*infile;
	fd_set			readfds;

	if (ac < 4) {
		fprintf(stderr, "dart: usage dart file.scn xpixels ypixels [-n]\n");
		exit(1);
	}

	screenx = atoi(av[2]);
	screeny = atoi(av[3]);

	preprocess = (av[4] == (char *)NULL || strcmp(av[4], "-n") != 0);
		
	strcpy(name, av[1]);
	if ((p = rindex(name, '.')) == (char *)NULL) {
		fprintf(stderr, "dart: input file must end in .scn\n");
		exit(1);
	}

	strcpy(p, ".pix");

	if ((im = openimage(name, "w")) == (image *)NULL) {
		fprintf(stderr, "dart: can't open output file.\n");
		exit(1);
	}

	imagetype(im) = PIX_RGBA;

	imagewidth(im) = screenx;
	imageheight(im) = screeny;

	imagedate(im) = time(0);

	imagedepth(im) = 24;

	title = (char *)NULL;

	if (title == (char *)NULL)
		titlelength(im) = 0;
	else {    
		titlelength(im) = strlen(title) + 1;
		imagetitle(im) = title;
	}         

	/*
	 * output header and get start of image.
	 */
	writeheader(im);

	imagestart = tell(im->fd);

	sp = getservbyname("artd", "tcp");

	if (sp == (struct servent *)NULL) {
		fprintf(stderr, "dart: can't find service\n");
		exit(1);
	}

	if ((infile = fopen(HOSTSFILE, "r")) == (FILE *)NULL) {
		fprintf(stderr, "dart: can't open file %s\n", HOSTSFILE);
		close(sock);
		exit(1);
	}

	getwd(buf);

	nhosts = 0;

	while (fscanf(infile, "%s ", name) == 1) {

		bzero(&server, sizeof(server));

		if ((hp = gethostbyname(name)) == (struct hostent *)NULL) {
			printf("dart: can't find host %s\n", name);
			continue;
		}

		bcopy((char *)hp->h_addr, (char *)&server.sin_addr, hp->h_length);

		server.sin_family = hp->h_addrtype;
		server.sin_port = sp->s_port;

		hosts[nhosts].busy = 0;

		hosts[nhosts].fd = socket(hp->h_addrtype, SOCK_STREAM, 0);

		if (hosts[nhosts].fd > 0 && !(connect(hosts[nhosts].fd, (struct sockaddr *)&server, sizeof(server)) < 0)) {
			sendshort(hosts[nhosts].fd, strlen(buf));

			write(hosts[nhosts].fd, buf, strlen(buf));

			sendshort(hosts[nhosts].fd, strlen(av[1]));

			write(hosts[nhosts].fd, av[1], strlen(av[1]));

			sendshort(hosts[nhosts].fd, screenx);
			sendshort(hosts[nhosts].fd, screeny);

			sendshort(hosts[nhosts].fd, preprocess);

			xfragsize = yfragsize = 50;

			sendshort(hosts[nhosts].fd, xfragsize);
			sendshort(hosts[nhosts].fd, yfragsize);

			nhosts++;
		} else
			close(hosts[nhosts].fd);                          
	}

	fclose(infile);

	if (nhosts == 0) {
		fprintf(stderr, "dart: can't connect to any hosts\n");
		exit(1);
	}

	if ((infile = fopen(av[1], "r")) == (FILE *)NULL) {
		fprintf(stderr, "dart: can't open file %s\n", av[1]);
		for (i = 0; i != nhosts; i++)
			close(hosts[i].fd);
		exit(1);
	}

	fclose(infile);

	FD_ZERO(&readfds);
	for (i = 0; i != nhosts; i++)
		if (hosts[i].fd > 0)
			FD_SET(hosts[i].fd, &readfds);

	pending = 1;
	y = 0;
	x = 0;

	while (pending) {
		for (i = 0; i != nhosts; i++) {
			if (hosts[i].fd > 0 && FD_ISSET(hosts[i].fd, &readfds)) {
				if (x >= screenx) {
					x = 0;
					y += yfragsize;
				}

				if (y >= screeny) {
							/*
							 * do we have any fragments that
							 * didn't complete?
							 */
					for (j = 0; j != nhosts; j++) {
						if (hosts[j].fd < 0 && hosts[j].busy) {
							
							hosts[i].x = hosts[j].x;
							hosts[i].y = hosts[j].y;

							hosts[i].xdiff = hosts[j].xdiff;
							hosts[i].ydiff = hosts[j].ydiff;

							hosts[i].busy = 1;
							hosts[j].busy = 0;

							break;
						}
					}

							/* didn't find anything */
					if (!hosts[i].busy) {
						write(hosts[i].fd, "Q", 1);
						close(hosts[i].fd);
						hosts[i].fd = -1;
						continue;
					}
				}

				if (!hosts[i].busy) {
					if (y + yfragsize >= screeny)
						ydiff = screeny - y;
					else 
						ydiff = yfragsize;

					if (x + xfragsize >= screenx)
						xdiff = screenx - x;
					else
						xdiff = xfragsize;

					hosts[i].x = x;
					hosts[i].y = y;

					hosts[i].xdiff = xdiff;
					hosts[i].ydiff = ydiff;

					hosts[i].busy = 1;
				}

				write(hosts[i].fd, "F", 1);

				sendshort(hosts[i].fd, hosts[i].x);
				sendshort(hosts[i].fd, hosts[i].x + hosts[i].xdiff - 1);

				sendshort(hosts[i].fd, hosts[i].y);
				sendshort(hosts[i].fd, hosts[i].y + hosts[i].ydiff - 1);

				x += xfragsize;
			}
		}

		FD_ZERO(&readfds);
		pending = 0;
		for (i = 0; i != nhosts; i++)
			if (hosts[i].fd > 0) {
				pending = 1;
				FD_SET(hosts[i].fd, &readfds);
			}

		if (pending)
			if ((i = select((int)ulimit(4, 0L), &readfds, (fd_set *)NULL, (fd_set *)NULL, (struct timeval *)NULL)) < 0)
				perror("whoops");

		for (i = 0; i != nhosts; i++)
			if (hosts[i].fd > 0 && FD_ISSET(hosts[i].fd, &readfds))  {
				if (read(hosts[i].fd, &c, 1) != 1) {
					hosts[i].fd = -1;
					continue;
				}

						/* valid response? */
				if (c != 'D') {
					FD_CLR(hosts[i].fd, &readfds);
					continue;
				}

				hosts[i].busy = 0;

				/*
				 * if nc comes up less than zero then
				 * the daemon on the remote machine
				 * has probably gone barfo. Mark the
				 * host as busy but set fd to -1 so
				 * we know it didn't finish.
				 */
				p = map;
				endp = map + 4 * xfragsize * yfragsize;
				while (p != endp) {
					nc = read(hosts[i].fd, p, endp - p);
					if (nc < 0) {
						hosts[i].fd = -1;
						hosts[i].busy = 1;
						break;
					}
					p += nc;
				}

				/*
				 * write out the image data
				 */
				for (j = 0; j != hosts[i].ydiff; j++) {
					lseek(im->fd, (off_t)(imagestart + (((hosts[i].y + j) * screenx + hosts[i].x) * 4)), SEEK_SET); 
					write(im->fd, map + j * hosts[i].xdiff * 4, hosts[i].xdiff * 4);
				}
			}
	}

	close(im->fd);

	exit(0);
}
