#include <stdio.h>
#include <math.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include "vort.h"

#define	CMAPSIZE	256
#define	DEPTH		8

extern	char	*rindex();


/*
 * program to read in a color-mapped image and display it on the sun
 */
main(ac, av)
	int	ac;
	char	**av;
{
	Frame			frame;
	Canvas			canvas;
	char			*myname, name[BUFSIZ], buf[BUFSIZ];
	register int		i, j, x, y;
	unsigned short		h, w, wreal, w2;
	int			val, line_bytes, mag = 1;
	u_char			*line, *red, *green, *blue;
	u_char			*l, *p, *pp;
	register Pixwin		*pw;
	register Pixrect	*pr;
	image			*im;
	int			upsidedown;

        if ((myname = rindex(av[0],'/')) == NULL)
                myname = av[0];
        else
                *myname++;
        /*
         * Chech that we are in sunview....
         */
        if (getenv("WINDOW_ME") == NULL) {
                fprintf(stderr, "%s can only be run under sunview (suntools)\n", myname);
                fprintf(stderr, "on the same machine that is running sunview.\n");
                exit(1);
        }

	if (ac < 2 || ac > 4) {
		fprintf(stderr, "%s: usage %s [-m<n>] [-u] file.\n", myname, myname);
		exit(1);
	}

	upsidedown = 0;
	for (i = 1; i < ac && *av[i] == '-'; i++) {
		if (strncmp(av[i], "-m", 2) == 0) {		/* magnify */
			if (sscanf(av[i] , "-m%d", &mag) != 1) {
				fprintf(stderr, "%s: bad mag factor\n", myname);
				exit(1);
			}

			if (mag < 1 || mag > 5) {
				fprintf(stderr, "%s: bad mag factor\n", myname);
				exit(1);
			}
		} else if (strncmp(av[i], "-u", 2) == 0) {		/* show image upside down */
			upsidedown = 1;
		}
	} 

	if ((im = openimage(av[i], "r")) == (image *)NULL) {
		fprintf(stderr, "%s: can't open file %s.\n", myname, av[i]);
		exit(1);
	}

	strcpy(name, myname);
	strcat(name, ": ");

        if ((myname = rindex(av[i],'/')) == NULL)
                myname = av[i];
        else
                *myname++;

	if (titlelength(im) == 0)
		strcat(name, myname);
	else
		strcat(name, imagetitle(im));

	wreal = imagewidth(im);
	w = wreal * mag;
	h = mag * imageheight(im);

        w2 = w;
        if ((i = w % 4) != 0)
                w2 = (w / 4 + i) * 4;

	if ((pr = mem_create(w2, h, DEPTH)) == (Pixrect *)NULL) {
		fprintf(stderr, "Couldn't allocate Pixrect\n");
		exit(1);
	}

	line_bytes = mpr_linebytes(w2, DEPTH);
	p = (unsigned char *)mpr_d(pr)->md_image; /* Start of Pixrect */

	if (upsidedown)
		p += line_bytes * (h - 1);	/* Last line in Pixrect */

	frame = window_create(0, FRAME,
			WIN_HEIGHT, h,
			WIN_WIDTH, w,
			FRAME_LABEL, name,
		0);

	canvas = window_create(frame, CANVAS,
			CANVAS_RETAINED, TRUE,
			WIN_HEIGHT, h,
			WIN_WIDTH, w,
		0);

	window_fit(frame);

	pw = (Pixwin *)canvas_pixwin(canvas);

	sprintf(buf, "disp%d\n", getpid());

	y = h - 1;
	x = 0;
	val = -1;

	line = (u_char *)malloc(w2);
	l = line;

	if (colormapped(im)) {
		pw_setcmsname(pw, buf);
		pw_putcolormap(pw, 0, cmapsize(im), redmap(im), greenmap(im), bluemap(im));

		while (y >= 0) {
			readmappedline(im, line);
			if (mag == 1) {
				bcopy(l, p, line_bytes);
				if (upsidedown)
					p -= line_bytes;
				else
					p += line_bytes;
				y--;
			} else {
				for (j = 0; j < mag; j++) {
					pp = p;
					for (x = 0; x < wreal; x++) 
						for (i = 0; i < mag; i++)
							*pp++ = l[x];

					if (upsidedown)
						p -= line_bytes;
					else
						p += line_bytes;
				}
				y -= mag;
			}
		}
	} else {
		if (w2 < CMAPSIZE) {
			red = (u_char *)malloc(CMAPSIZE);
			green = (u_char *)malloc(CMAPSIZE);
			blue = (u_char *)malloc(CMAPSIZE);
		} else {
			red = (u_char *)malloc(w2);
			green = (u_char *)malloc(w2);
			blue = (u_char *)malloc(w2);
		}

		for (i = 0; i < CMAPSIZE; i++)
			red[i] = green[i] = blue[i] = i;

		pw_setcmsname(pw, buf);
		pw_putcolormap(pw, 0, CMAPSIZE, red, green, blue);

		while (y >= 0) {
			readrgbline(im, red, green, blue);
			for (x = 0; x < w; x++) 
				line[x] = red[x] * 0.3 + green[x] * 0.59 + blue[x] * 0.11;

			if (mag == 1) {
				bcopy(l, p, line_bytes);
				if (upsidedown)
					p -= line_bytes;
				else
					p += line_bytes;
				y--;
			} else {
				for (j = 0; j < mag; j++) {
					pp = p;
					for (x = 0; x < wreal; x++) 
						for (i = 0; i < mag; i++)
							*pp++ = l[x];

					if (upsidedown)
						p -= line_bytes;
					else
						p += line_bytes;
				}
				y -= mag;
			}
		}
	}

	pw_batch_on(pw);
	pw_rop(pw, 0, 0, w, h, PIX_SRC | PIX_DONTCLIP, pr, 0, 0);
	pw_batch_off(pw);

	window_main_loop(frame);

	exit(0);
}
