/* Showpix 3.0, display VORT images on (nearly) any adapter  */

#define DEF_VARS

#include <dos.h>
#include <time.h>
#include <conio.h>
#include <graph.h>
#include <malloc.h>
#include "showpix.h"
#include "extra.h"


int readkey(long wsecs)
{
    int k;
    long t;

    t=time((long *)NULL);
    t+=wsecs;

    k=32;
    while (time((long *)NULL) < t)
         if (kbhit()) {
              k=getch();
              break;
              }

    if (k=='q' || k=='Q' || k==27) {
         returntotext();
         exit(0);
         }

    return k;
}



void help(char *type)
{
    int i;

    switch(type[0]) {
    case 'h':
         puts(prname);
         puts("\nThe syntax is:");
         puts("Showpix <options> <files> <more options> <more files> etc.");
         puts("Where <options> are:");
         puts("-a         enables autosave (default no save)");
         puts("-k         wait for a key (default for image)");
         puts("-w<secs>   wait for key or go on after <secs> seconds, image");
         puts("-W<secs>   wait for key or go on after <secs> seconds, title (default 10)");
         puts("-s         show image titles (default don't show)");
         puts("-c         centers the image in the physical screen (default don't center)");
         puts("-r -g -b   only display the red, green or blue plane");
         puts("-f         display the image in full colors (default for colormapped)");
         puts("-m         display the image in black & white (default for non-mapped)");
         puts("-t<mode>[pattern] use the tricky dithering");
         puts("           Read the docs for the values of <mode> and <pattern>");
         puts("-v<num>    select the display adapter type");
         puts("<files>    [path]filename.ext[(<xpos>, <ypos>)] [+] ..more files....");
         puts("If no extension is specified Showpix will try '.pix' and '.mix'.");
         puts("The translation overrides the -c centering option, '+' means add the images.");
         puts("Use 's' to save the image onscreen in GIF format (same filename),");
         puts("    'q' to quit to dos and any key to go on with the display.");
         break;
    case 'v':
         puts(prname);
         puts("List of supported video adapters (all are 256 colors):\n");
         for (i=1; i<=MAXVIDEO; i++) {
              fromvideotable(videos[i-1][0]-1);
              printf("\t%d\t%dx%d %s\n", i, videoentry.xdots, videoentry.ydots,
                     videoentry.name);
              }
         puts("\nThe video mode must be specified with the -v<number> option.");
         break;
    case 'd':
         puts(prname);
         puts("\nShowpix was created by A.Barsella, using the VORT.LIB to read in the .PIX");
         puts("files and a hacked version of the FRACTINT graphics routines to draw onscreen.");
         puts("Only a small part of the FRACTINT's graphics adapters are used by showpix, so");
         puts("if you have an adapter which is not on the list hack the sources or call me");
         puts("and it will be supported in the next version....");
         break;
    default:
         puts(prname);
         puts("Type 'Showpix h' for help, 'Showpix v' for adapters supported");
         puts("or 'Showpix d' for product description.");
         break;
         }
    exit(-1);
}



void main(int argc, char **argv)
{
    int xs, ys, lastone, single, shft, ct;
    char x, gifname[40], *exten, param[60], *parm, *cor, pixname[40];
    char huge *xyzzy;
    unsigned int o;

    if (argc == 1)
         help("?");

    if (argc==2 && argv[1][1]==0)
         help(argv[1]);

    buildcline(argc, argv);

    /* allocate buffers for maximum possible (likely) image width */
    s[0]= (unsigned char *) malloc(MAX_IMGWIDTH*3);
    r[0]= (unsigned char *) malloc(MAX_IMGWIDTH);
    g[0]= (unsigned char *) malloc(MAX_IMGWIDTH);
    b[0]= (unsigned char *) malloc(MAX_IMGWIDTH);

    s[1]= (unsigned char *) malloc(MAX_IMGWIDTH*3);
    r[1]= (unsigned char *) malloc(MAX_IMGWIDTH);
    g[1]= (unsigned char *) malloc(MAX_IMGWIDTH);
    b[1]= (unsigned char *) malloc(MAX_IMGWIDTH);

    /* allocate extra segment for 'extra.asm' routines */
    xyzzy= halloc(66000l, 1);  /* allocate 66000 bytes */
    extraseg=FP_SEG(xyzzy);
    o=FP_OFF(xyzzy);

    while (o>15) { o-=16; extraseg++; }

    autosave=NO;
    options=FULLCOLORS;
    centering=NO;
    videomode=-1;
    showtitle=NO;
    imagewait=31536000L; /* about 1 year of wait time */
    titlewait=10L;

    if (getnextname(param)==-1) {
         /* eh?, no names? */
         puts("No file specified.");
         exit(-1);
         }

    single=YES;
    parm=param;

disimage:
    cor=strchr(parm, '(');
    shft=YES;
    if (cor==NULL && single==YES) {
         /* not shifted anywhere */
         xs=0;
         ys=0;
         shft=0;
         }
    else
         if (cor!=NULL)
            if (2!=sscanf(cor, "(%d , %d)", &xs, &ys))
               if (2!=sscanf(cor, "(%d %d)", &xs, &ys)) {
                   returntotext();
                   *cor=0;
                   printf("Illegal coordinate specification for file %s.\n",
                          parm);
                   exit(-1);
                   }

    *cor=0;
    if (single==YES)
         strcpy(gifname, parm);

    if (strchr(parm, '.')==NULL) {
         sprintf(pixname, "%s.PIX", parm);
         im = openimage(pixname, "r");
         if (im==(image *)NULL) {
              sprintf(pixname, "%s.MIX", parm);
              im = openimage(pixname, "r");
              if (im==(image *)NULL)
                   sprintf(pixname,"%s (.PIX/.MIX)", parm);
              }
         }
    else {
         strcpy(pixname, parm);
         im = openimage(parm, "r");
         }

    if (im==(image *)NULL) {
         returntotext();
         fprintf(stderr, "Can't open the file %s.\n", pixname);
         exit(-1);
         }

    if (videomode==-1) {
         puts("Video mode number missing.");
         exit(-1);
         }

    if (setvideostats(videomode) != 1) {
         printf("Illegal video mode %d.\n", videomode);
         exit(-1);
         }

    if ( (ct=titlelength(im)) != 0 && single==YES && showtitle==YES) {
         settextmode();
         if (ct<80)
              _settextposition(12, 40-ct/2);
         else
              _settextposition(12, 1);

         puts(imagetitle(im));
         readkey(titlewait);
         }

    display_image(xs, ys, shft, single);

    if (getnextname(param)==-1) {
         lastone=YES;
         goto saveimage;
         }

    if (param[0]!='+') {
         lastone=NO;
         parm=param;
         single=YES;
         goto saveimage;
         }

    single=NO;
    parm=param+1;
    goto disimage;


saveimage:
    if (autosave==NO)
         x=readkey(imagewait);
    else
         x='s';

    if (x=='s') {
         exten=strchr(gifname, '.');
         if (exten==NULL)
              exten=gifname+strlen(gifname);

         strcpy(exten, ".gif");

         savegif(gifname);
         }

    if (lastone!=YES)
         goto disimage;

    returntotext();
}
