#include <stdio.h>
#include "vort.h"

/*
 * readrgbline
 *
 *	reads in a scanline from file in and puts it into red, green, and blue.
 */
int
readrgbline(in, red, green, blue)
	image		*in;
	unsigned char	*red, *green, *blue;
{
	register int	x, i;
	unsigned char	r, g, b, run;

	switch (imagetype(in)) {
	case PIX_CMAP:
		for (x = 0; x < imagewidth(in); x++) {
			if ((i = readbyte(in)) == EOF)
				return(0);
			red[x] = in->red[i];
			green[x] = in->green[i];
			blue[x] = in->blue[i];
		}
		break;
	case PIX_RLECMAP:
		x = 0;
		while (x < imagewidth(in)) {
			if ((i = readbyte(in)) == EOF)
				return(0);
			run = i;
			if (run & 0x80) {
				while ((run & 0x7f) && x < imagewidth(in)) {
					i = readbyte(in);
					red[x] = in->red[i];
					green[x] = in->green[i];
					blue[x] = in->blue[i];
					run--;
					x++;
				}
			} else {
				i = readbyte(in);
				r = red[x] = in->red[i];
				g = green[x] = in->green[i];
				b = blue[x] = in->blue[i];
				x++;
				while (run && x < imagewidth(in)) {
					red[x] = r;
					green[x] = g;
					blue[x] = b;
					run--;
					x++;
				}
			}
		}
		break;
	case PIX_RGB:
		for (x = 0; x < imagewidth(in); x++) {
			if ((i = readbyte(in)) == EOF)
				return(0);
			red[x] = i;
			green[x] = readbyte(in);
			blue[x] = readbyte(in);
		}
		break;
	case PIX_RGBA:
		for (x = 0; x < imagewidth(in); x++) {
			if ((i = readbyte(in)) == EOF)
				return(0);
			red[x] = i;
			green[x] = readbyte(in);
			blue[x] = readbyte(in);
			readbyte(in);
		}
		break;
	case PIX_RLE:
		x = 0;
		while (x < imagewidth(in)) {
			if ((i = readbyte(in)) == EOF)
				return(0);
			run = i;
			if (run & 0x80) {
				while ((run & 0x7f) && x < imagewidth(in)) {
					red[x] = readbyte(in);
					green[x] = readbyte(in);
					blue[x] = readbyte(in);
					run--;
					x++;
				}
			} else {
				r = red[x] = readbyte(in);
				g = green[x] = readbyte(in);
				b = blue[x] = readbyte(in);
				x++;
				while (run && x < imagewidth(in)) {
					red[x] = r;
					green[x] = g;
					blue[x] = b;
					run--;
					x++;
				}
			}
		}
		break;
	case PIX_RLEA:
		x = 0;
		while (x < imagewidth(in)) {
			if ((i = readbyte(in)) == EOF)
				return(0);
			run = i;
			if (run & 0x80) {
				while ((run & 0x7f) && x < imagewidth(in)) {
					red[x] = readbyte(in);
					green[x] = readbyte(in);
					blue[x] = readbyte(in);
					readbyte(in);
					run--;
					x++;
				}
			} else {
				r = red[x] = readbyte(in);
				g = green[x] = readbyte(in);
				b = blue[x] = readbyte(in);
				readbyte(in);
				x++;
				while (run && x < imagewidth(in)) {
					red[x] = r;
					green[x] = g;
					blue[x] = b;
					run--;
					x++;
				}
			}
		}
		break;
	default:
		fprintf(stderr, "readrgbline: bad file format.\n");
		return(0);
	}

	return(1);
}
