/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		snn.c - Symmetric Nearest Neighbour Smoothing. 
*			        Snn is computationally cheaper than knn as no
*			        sorting is required.  The trade-off is that 
*				knn retains the edge sharpness	better than 
*				does snn.
* REVISION:             3.1
* AUTHOR:               DH
* CREATION DATE:	02 Jul 1990        
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	08 Jan 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)snn.c	3.1 7/10/92";
#endif


#include <stdio.h>
#include <stdlib.h>
#include "vip.h"


/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: snn [-n num] [input_image] [-o output_image]\n");
    (void) fprintf(stderr, "       -n size of neighbourhood is (2*num+1) X (2*num+1)\n");
    (void) fprintf(stderr, "          (default:num=1 for 3x3 neighbourhood)\n");
    (void) fprintf(stderr, "default: snn -n 1 <stdin> -o <stdout>\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(m1, m2)
char   *m1, *m2;

/* print error message and exit program. */
{
    (void) fprintf(stderr, "snn: %s %s.\n", m1, m2);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    register int arg;
    char   *infile = NULL, *outfile = NULL;
    IMAGE  *im, *mat;
    int     n = 1;

    for (arg = 1; arg < argc; arg++)
	if (argv[arg][0] == '-')
	    switch (argv[arg][1]) {
	    case 'n':
		if (++arg < argc)
		    n = atoi(argv[arg]);
		else
		    Usage();
		break;
	    case 'o':
		if (++arg < argc)
		    outfile = argv[arg];
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else if (!infile)
	    infile = argv[arg];
	else
	    Usage();

    if (!(im = ( IMAGE * ) Read_Image(infile)))
	exit(1);
    if (!(mat = ( IMAGE * ) Snn_Image(im, n)))
	exit(1);
    Write_Image(mat, outfile);

    exit(0);
}
