/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		ri2cx.c -      Merge two images (the real and the 
*				       imaginary parts) to form a complex 
*				       image. The images to be merged can 
*				       either be floating point or unsigned 
*				       char images.
* REVISION:             3.1
* AUTHOR:               DH
* CREATION DATE:        16 March 1994
* REVISION DATE:	3/16/94        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	16 March 1994
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)ri2cx.c	3.1 3/16/94";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"


void            Usage();
void            Pperror( char * );
IMAGE         *Real_Imaginary_To_Complex( struct struct_vip_IMAGE *,
                                         struct struct_vip_IMAGE * );


/*- Usage -----------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: ri2cx real_file [-i imaginary_file] [-o complex_image_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "ri2cx: %s\n", e);
    exit(1);
}


/*- Real_Imaginary_To_Complex ---------------------------------------

Combine the real component and the imaginary component separately store
in two FLOAT images to form a complex image.

--------------------------------------------------------------------*/

IMAGE  *Real_Imaginary_To_Complex(real, imag)
IMAGE  *real, *imag;
{
    IMAGE  *cimage = NULL;
    register int rr, cc;

    if (!real) {
	VIP_Error_Msg("Real_Imaginary_To_Complex: image for the real part is NULL");
	return (NULL);
    }
    else if (imag && (real->rows != imag->rows || real->cols != imag->cols)) {
	VIP_Error_Msg("Real_Imaginary_To_Complex: input images have inconsistent dimensions.");
	return (NULL);
    }
    else if (imag && (real->type != imag->type)) {
	VIP_Error_Msg("Real_Imaginary_To_Complex: input images have inconsistent type.");
	return (NULL);
    }

    if (!(cimage = ( IMAGE * ) Allocate_Image(0, 0, real->rows, real->cols, COMPLEXTYPE))) {
	VIP_Error_Msg("Real_Imaginary_To_Complex: out of memory");
	return (NULL);
    }

    switch (real->type) {
    case BYTETYPE:
	if (imag) {
	    for (rr = real->rows - 1; rr >= 0; rr--)
		for (cc = real->cols - 1; cc >= 0; cc--) {
		    cimage->i.cx[rr][cc].r = (float)real->i.c[rr][cc];
		    cimage->i.cx[rr][cc].i = (float)imag->i.c[rr][cc];
		}
	}
	else {
	    for (rr = real->rows - 1; rr >= 0; rr--)
		for (cc = real->cols - 1; cc >= 0; cc--) {
		    cimage->i.cx[rr][cc].r = (float)real->i.c[rr][cc];
		    cimage->i.cx[rr][cc].i = 0.0;
		}
	}
	break;
    case FLOATTYPE:
	if (imag) {
	    for (rr = real->rows - 1; rr >= 0; rr--)
		for (cc = real->cols - 1; cc >= 0; cc--) {
		    cimage->i.cx[rr][cc].r = real->i.f[rr][cc];
		    cimage->i.cx[rr][cc].i = imag->i.f[rr][cc];
		}
	}
	else {
	    for (rr = real->rows - 1; rr >= 0; rr--)
		for (cc = real->cols - 1; cc >= 0; cc--) {
		    cimage->i.cx[rr][cc].r = real->i.f[rr][cc];
		    cimage->i.cx[rr][cc].i = 0.0;
		}
	}
	break;
    default:
	VIP_Error_Msg("Real_Imaginary_To_Complex: only able to process images of FLOATTYPE");
	Free_Image(cimage);
	cimage = NULL;
    }

    return (cimage);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *real_arg = NULL;	/* filename for the real part */
    char   *complex_arg = NULL;	/* filename for the complex image */
    char   *imaginary_arg = NULL;	/* filename for the imag.
					 * part */
    IMAGE  *cimage, *real, *imag;	/* the complex, real, and
					 * imag. images */

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		if (++argn < argc)
		    complex_arg = argv[argn];
		else
		    Usage();
		break;
	    case 'i':
		if (++argn < argc)
		    imaginary_arg = argv[argn];
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else if (!real_arg)
	    real_arg = argv[argn];
	else
	    Usage();

    if (!(real = ( IMAGE * ) Read_Image(real_arg)))
	exit(1);
    if (imaginary_arg) {
	if (!(imag = ( IMAGE * ) Read_Image(imaginary_arg)))
		exit(1);
    }
    else imag=NULL;

    if (!(cimage = ( IMAGE * ) Real_Imaginary_To_Complex(real, imag)))
	exit(1);

    Write_Image(cimage, complex_arg);

    exit(0);
}

