/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM:               VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		rgbppm2vip.c - Convert a colour ppm image to a colour
*				       V.I.P. image.
* REVISION:             3.1
* AUTHOR:               CFF
* CREATION DATE:        05 August 1992
* REVISION DATE:	8/5/92
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* CREATION DATE:        05 August 1992
* COMMENT:		A new utility.
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)rgbppm2vip.c	3.1 8/5/92";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "vip.h"
#include "misc.h"
#include "pm.h"
#include "pmfn.h"

void Usage();
void Pperror(char *e);

/*- Usage -----------------------------------------------------------

Print 'usage' message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: rgbppm2vip [rgb ppm_image_file] [-o vip_image_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "rgbppm2vip: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn, a, b, c, i;
    char   *image_arg = NULL, *out_arg = NULL, temp1[10];
    IMAGE  *im;
    PPM	   *ppm;
    FILE   *outfile;

    for (argn = 1; argn < argc; argn++) {
	if (argv[argn][0] == '-') {
	    switch (argv[argn][1]) {
	    case 'o':
		out_arg = argv[++argn];
		break;
	    default:
		Usage();
	    }
        }
	else if (!image_arg) {
	    image_arg = argv[argn];
	}
	else {
	    Usage();
	}
    }

    if (ppm = ( PPM *) Read_RGB_PPM_Image(image_arg)) {
        if (im = ( IMAGE * ) RGB_PPM_To_VIP(ppm)) {

            if (Not_An_Image(im)) {
                VIP_Error_Msg("Write_Image: Attempt to write a non-IMAGE structure");
                return (ERROR);
            }
            if (out_arg) {
                outfile = fopen(out_arg, "wb");
                    if (outfile == NULL) {
                        VIP_Error_Msg("Write_Image could not open file");
                        return (ERROR);
                    }
            }
            else {
                outfile = stdout;
	    }

    /* Write the header, but not the pointer to the image data */

	    (void) fwrite("1001", sizeof(int), 1, outfile);
	    (void) fwrite(" ", sizeof(char), 1, outfile);
            (void) sprintf (temp1, "%d%c", im->rows, '\0');
            (void) fwrite(temp1, sizeof(char) * strlen(temp1), 1, outfile);
	    (void) fwrite(" ", sizeof(char), 1, outfile);
            (void) sprintf (temp1, "%c", '\0');
            (void) sprintf (temp1, "%d%c", im->cols, '\0');
            (void) fwrite(temp1, sizeof(char) * strlen(temp1), 1, outfile);
	    (void) fwrite(" ", sizeof(char), 1, outfile);
            (void) fwrite("0", sizeof(int), 1, outfile);
	    (void) fwrite(" ", sizeof(char), 1, outfile);
            (void) fwrite("0.000000", sizeof(double), 1, outfile);
	    (void) fwrite(" ", sizeof(char), 1, outfile);
            (void) fwrite("0", sizeof(int), 1, outfile);
	    (void) fwrite(" ", sizeof(char), 1, outfile);
            (void) fwrite("0", sizeof(int), 1, outfile);
	    (void) fwrite(" ", sizeof(char), 1, outfile);
            (void) fwrite("0", sizeof(int), 1, outfile);
	    (void) fwrite(" ", sizeof(char), 1, outfile);
            (void) fwrite("0", sizeof(int), 1, outfile);
	    (void) fwrite(" ", sizeof(char), 1, outfile);
            (void) fwrite("0.000000", sizeof(double), 1, outfile);
            (void) fwrite("\n", sizeof(char), 1, outfile);

    	    for (a = 0; a < im->rows; a++) {
       	        for (b = 0; b < im->cols; b++) {
       	            for (c = 0; c < 4; c++) {
       	                (void) fputc(im->i.rgb[a][b][c], outfile);
		    } 
		}
	    }

            (void) fclose(outfile);

            return (OK);

       }
    }

    exit(0);
}
