/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		reflect.c - Create reflection of an image.
* REVISION:             3.1
* AUTHOR:               CA
* CREATION DATE:        1 Dec 1986
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	22 Jan 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)reflect.c	3.1 7/10/92";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"


/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: reflect [image_file] [-r] [-c] [-o out_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "reflect: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];

{
    int     argn, row_arg = 0, column_arg = 0;
    char   *image_arg = NULL;
    char   *out_arg = NULL;
    IMAGE  *im, *outim;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'c':
		column_arg = argn;
		break;
	    case 'r':
		row_arg = argn;
		break;
	    case 'o':
		out_arg = argv[++argn];
		break;
	    default:
		Usage();
	    }
	else if (!image_arg)
	    image_arg = argv[argn];
	else
	    Usage();


    if (!row_arg && !column_arg)
	Usage();

    if (!(im = ( IMAGE * ) Read_Image(image_arg)))
	Pperror("vision system error in Read_Image");

    if (column_arg)
	outim = ( IMAGE * ) Image_Column_Reflect(im);
    else
	/* assume row_arg is 1 */
	outim = ( IMAGE * ) Image_Row_Reflect(im);

    if (outim) {
	Write_Image(outim, out_arg);
	Free_Image(outim);
    }
    Free_Image(im);

    exit(0);
}
