/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		raw2vip.c - Take a headless image (byte, floating point 
*				    or complex) and put a header on it.
* REVISION:             3.1
* AUTHOR:               DH
* CREATION DATE:        11 March 1994
* REVISION DATE:	3/11/94
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 March 1994
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)raw2vip.c	3.1 3/11/94";
#endif

#include <stdio.h>
#include <stdlib.h>

#ifdef DOS

#ifdef MSC
#include <sys\types.h>
#endif

#include <fcntl.h>
#include <sys\stat.h>
#else
#include <sys/file.h>
#endif

#include "misc.h"
#include "vip.h"


/*- Usage -----------------------------------------------------------

 Print message and exit program.

--------------------------------------------------------------------- */

void Usage()
{
    (void) fprintf(stderr, "usage: raw2vip [-t type] [-d nr nc] [image_file] [-o out_file]\n");
    (void) fprintf(stderr, "       -t type of image, can be one of the following:\n");
    (void) fprintf(stderr, "          BYTETYPE, SHORTTYPE, LONGTYPE, FLOATTYPE,\n");
    (void) fprintf(stderr, "          DOUBLETYPE, RGBTYPE, COMPLEXTYPE, RGBTYPE,\n");
    (void) fprintf(stderr, "          HSITYPE (default=BYTETYPE)\n");
    (void) fprintf(stderr, "       -d dimension of raw image (default=256X256)\n");
    (void) fprintf(stderr, "       -o output file name\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

 Print message and exit program.

--------------------------------------------------------------------- */

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "raw2vip: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main program.

--------------------------------------------------------------------- */

main(argc, argv)
int     argc;
char   *argv[];
{
    register int r;
    int     argn;
    char   *image_arg = NULL;
    char   *raw_arg = NULL;
    int     nr = 256, nc = 256;
    int     typ = BYTETYPE;
    IMAGE  *image;
    FILE   *fp;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'd':
		nr = atoi(argv[++argn]);
		nc = atoi(argv[++argn]);
		break;
	    case 'o':
		image_arg = argv[++argn];
		break;
	    case 't':		/* image type */
		if (++argn < argc) {
		    if (!strcmp(argv[argn], "BYTETYPE"))
			typ = BYTETYPE;
		    else if (!strcmp(argv[argn], "SHORTTYPE"))
			typ = SHORTTYPE;
		    else if (!strcmp(argv[argn], "LONGTYPE"))
			typ = LONGTYPE;
		    else if (!strcmp(argv[argn], "FLOATTYPE"))
			typ = FLOATTYPE;
		    else if (!strcmp(argv[argn], "DOUBLETYPE"))
			typ = DOUBLETYPE;
		    else if (!strcmp(argv[argn], "COMPLEXTYPE"))
			typ = COMPLEXTYPE;
		    else if (!strcmp(argv[argn], "RGBTYPE"))
			typ = RGBTYPE;
		    else if (!strcmp(argv[argn], "HSITYPE"))
			typ = HSITYPE;
		    else
			Usage();
		}
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else if (!raw_arg)
	    raw_arg = argv[argn];
	else
	    Usage();


    if (raw_arg) {
	if (!(fp = fopen(raw_arg, "r")))
	    Pperror("Fail to open input file");
    }
    else
	fp = stdin;
    switch (typ) {
    case BYTETYPE:
	image = ( IMAGE * ) Allocate_Image(0, 0, nr, nc, BYTETYPE);
	if (image == NULL)
	    Pperror("Out of memory");
	for (r = 0; r < nr; r++)
	    if (fread((char *) image->i.c[r], sizeof(unsigned char), nc, fp) != nc)
		Pperror("Short read");
	break;
    case SHORTTYPE:
	image = ( IMAGE * ) Allocate_Image(0, 0, nr, nc, SHORTTYPE);
	if (image == NULL)
	    Pperror("Out of memory");
	for (r = 0; r < nr; r++)
	    if (fread((char *) image->i.s[r], sizeof(short), nc, fp) != nc)
		Pperror("Short read");
	break;
    case LONGTYPE:
	image = ( IMAGE * ) Allocate_Image(0, 0, nr, nc, LONGTYPE);
	if (image == NULL)
	    Pperror("Out of memory");
	for (r = 0; r < nr; r++)
	    if (fread((char *) image->i.l[r], sizeof(long), nc, fp) != nc)
		Pperror("Short read");
	break;
    case FLOATTYPE:
	image = ( IMAGE * ) Allocate_Image(0, 0, nr, nc, FLOATTYPE);
	if (image == NULL)
	    Pperror("Out of memory");
	for (r = 0; r < nr; r++)
	    if (fread((char *) image->i.f[r], sizeof(float), nc, fp) != nc)
		Pperror("Short read");
	break;
    case DOUBLETYPE:
	image = ( IMAGE * ) Allocate_Image(0, 0, nr, nc, DOUBLETYPE);
	if (image == NULL)
	    Pperror("Out of memory");
	for (r = 0; r < nr; r++)
	    if (fread((char *) image->i.d[r], sizeof(double), nc, fp) != nc)
		Pperror("Short read");
	break;
    case COMPLEXTYPE:
	image = ( IMAGE * ) Allocate_Image(0, 0, nr, nc, COMPLEXTYPE);
	if (image == NULL)
	    Pperror("Out of memory");
	for (r = 0; r < nr; r++)
	    if (fread((char *) image->i.cx[r], sizeof(COMPLEX), nc, fp) != nc)
		Pperror("Short read");
	break;
    case RGBTYPE:
	image = ( IMAGE * ) Allocate_Image(0, 0, nr, nc, RGBTYPE);
	if (image == NULL)
	    Pperror("Out of memory");
	for (r = 0; r < nr; r++)
	    if (fread((char *) image->i.rgb[r], 3 * sizeof(unsigned char), nc, fp) != nc)
		Pperror("Short read");
	break;
    case HSITYPE:
	image = ( IMAGE * ) Allocate_Image(0, 0, nr, nc, HSITYPE);
	if (image == NULL)
	    Pperror("Out of memory");
	for (r = 0; r < nr; r++)
	    if (fread((char *) image->i.hsi[r], 3 * sizeof(unsigned char), nc, fp) != nc)
		Pperror("Short read");
    default:
	Pperror("Unknown image type");
    }
    fclose(fp);

    if (Write_Image(image, image_arg) != OK)
	Pperror("Fail to write image to file");
    exit(0);
}
