/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		ap2cx.c -      Join the phase image and the amplitude 
*				       image to form a complex image.
* REVISION:             3.2
* AUTHOR:               DH
* CREATION DATE:        16 March1994
* REVISION DATE:	4/8/94
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:	3.2
* DATE:		8 April 1994
* COMMENT:	Fixed compiler warnings
* BY:		BJR
*
* REVISION:	3.1
* DATE:		16 March 1994
* COMMENT:	ANSIfied and SCCS'd
* BY:		CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)ap2cx.c	3.2 4/8/94";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"


void Usage();
void Pperror(char *e);
IMAGE  *Amplitude_Phase_To_Complex(IMAGE *amp, IMAGE *phase);

/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: ap2cx -a amplitude_file -p phase_file [-o output_file]\n");
    exit(1);
}

/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "ap2cx: %s\n", e);
    exit(1);
}


/*- Amplitude_Phase_To_Complex --------------------------------------

Combine two floating point images and return an image of COMPLEXTYPE.

--------------------------------------------------------------------*/

IMAGE  *Amplitude_Phase_To_Complex(amp, phase)
IMAGE  *amp, *phase;

/* get a complex image (or part of it) from the given matrices. */
{
    IMAGE  *cim = NULL;
    register int rr, cc;
    COMPLEX *t;
    float   a, p;

    if (!(cim = ( IMAGE * ) Allocate_Image(0, 0, amp->rows, amp->cols, COMPLEXTYPE))) {
	VIP_Error_Msg("Amplitude_Phase_To_Complex: out of memory");
	return (NULL);
    }

    if (amp->rows != phase->rows || amp->cols != phase->cols) {
	VIP_Error_Msg("Amplitude_Phase_To_Complex: The amplitude and phase images do not have consistent dimensions");
	Free_Image(cim);
	return (NULL);
    }

    if (amp->type != phase->type) {
	VIP_Error_Msg("Amplitude_Phase_To_Complex: The amplitude and phase images do not have consistent type");
	Free_Image(cim);
	return (NULL);
    }
    switch (amp->type) {
    case FLOATTYPE:
	for (rr = amp->rows - 1; rr >= 0; rr--) {
	    t = &cim->i.cx[rr][amp->cols - 1];
	    for (cc = amp->cols - 1; cc >= 0; cc--, t--) {
		a = amp->i.f[rr][cc];
		p = phase->i.f[rr][cc];
		t->r = a * cos((double) p);
		t->i = a * sin((double) p);
	    }
	}
	break;
    default:
	VIP_Error_Msg("Amplitude_Phase_To_Complex: only able to process images of FLOATTYPE");
    }
    return (cim);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

int main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *amp_arg = NULL;	/* filename for the amplitude part */
    char   *complex_arg = NULL;	/* filename for the complex image */
    char   *phase_arg = NULL;	/* filename for the phase part */
    IMAGE  *phase, *amp;	/* phase and amplitude images */
    IMAGE  *cimage;		/* output complex image */

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		if (++argn < argc)
		    complex_arg = argv[argn];
		else
		    Usage();
		break;
	    case 'p':
		if (++argn < argc)
		    phase_arg = argv[argn];
		else
		    Usage();
		break;
	    case 'a':
		if (++argn < argc)
		    amp_arg = argv[argn];
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else
	    Usage();

    if (!(amp = ( IMAGE * ) Read_Image(amp_arg)))
	exit(1);
    if (!(phase = ( IMAGE * ) Read_Image(phase_arg)))
	exit(1);

    if (!(cimage = ( IMAGE * ) Amplitude_Phase_To_Complex(amp, phase)))
	exit(1);

    Write_Image(cimage, complex_arg);

    exit(0);
}
