/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:		SPLASH            
* MODULE:		splashx.c - Splash image displayer.
* REVISION:             3.1
* AUTHOR:               
* CREATION DATE:        
* REVISION DATE:	7/14/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	14 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)splashx.c	3.1 7/14/92";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <ctype.h>
#include <math.h>

#include <X11/Xlib.h>

#include <xview/xview.h>
#include <xview/svrimage.h>
#include <xview/frame.h>
#include <xview/panel.h>
#include <xview/canvas.h>
#include <xview/xv_xrect.h>
#include <xview/cms.h>
#include <xview/notice.h>
#include <xview/font.h>

#include "vip.h"
#include "graphics.h"
#include "splashfn.h"

/* ANSI fn. prototypes in splashfn.h - CFF */

/*
void     quit(), event_proc(), repaint(), Read(), GetFile();
void     SetMagnification();
void     RetrieveXImage(), SplashImage(), ShowImage();
int      testuv2xyz(), testxyz2uv();
void     showtoolsframe(), hidetoolsframe();
void     setgamma();
void     Show_Popup_Frame(), Write_Modified_Image();
*/

/* GLOBALS  */

Frame    frame, toolsframe, popupframe;	/* The frames. */
Canvas   imagecanvas, uvintcanvas, xyzcanvas, slicecanvas, LUTslicecanvas;	/* Canvases. */
Panel    panel;			/* The defn. of a panel, used for each
				 * different panel. */
Panel    imagenamep;		/* panel for collecting image name */

Panel_item      toolbutton;
Panel_item      magbutton;

int firstime=0;
int      magnification = 1;
IMAGE   *image1 = NULL;
SENSOR   sensor;
int      LUT[256];
int      STATE = 0;
int      REDRAWN = FALSE;
char     ARGVIMAGE[40];
char     spl_str[250];

#define CALCXYZ 1

/*------------------------------------------------------------------------*/


main(argc, argv)
int      argc;
char    *argv[];
{
    VIP_STD_ERR = NULL;		/* suppress messages to screen - use alert
				 * boxes */
    (void) xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, XV_NULL);	/* Initialize xview. */
    InitWindows(argc, argv);	/* Initialize the windows. */
}

/*-  ShowImage  ---------------------------------------------------------

This function draws the image to the screen. It is a slow draw, using the
basic pixel drawing capabilities of X through routine DrawPoint

------------------------------------------------------------------------*/

void     ShowImage(image)
IMAGE   *image;
{
    int      i, j, col;

    DrawInto(imagecanvas);

    if (image == NULL)
	return;
    XClearWindow(display, win);	/* Clear the window in case some thing is
				 * alredy there. */
    for (i = 0; i < image->rows; i++)	/* Loop through the number of rows
					 * columns. */
	for (j = 0; j < image->cols; j++) {
	    if (image->i.c[i][j]) {	/* If colour value 0 then don't draw
					 * as the background is alredy that
					 * colour. */
		col = (int) image->i.c[i][j] / 4;	/* Get the colour value
							 * from the image. */
		XSetForeground(display, gc,
			       colour_table[col]);	/* Set the drawing
							 * colour. */
		XDrawPoint(display, win, gc, j, i);	/* Draw the point at vv							 *
							 * j,i. */
	    }
	}
}


/** SplashImage  ----------------------------------------------------------

James Trevelyan  September 1991

Function to quickly draw an image on the screen.  We clear the window, then
retrieve a small section to get the format right and check it for
consistency.  Then, we create a temporary holding area for the image data
and create it using assumed layout of the X colour table.  When the image
has been put into the window, the temporary holding areas are released.

This routine exploits the X image format to speed up the process and may not
be compatible with other hardware platforms.


To find out about X images, I wrote a test function to: (a) create a test
image (in the vision format) and (b) to display it using ShowImage(), (c)
to retrieve it using XGetImage, (d) to print out the header and data. This
showed that the X colour table values consist of the following when the
program is running: 0 - white 1 - black 2,3,4 - frame colours (normal,
light, dark) 5 - background colour 6 - grey frame colour (for scrollbars)
7....  colours generated for image display (from our client) Initially, my
colour(0) was black, so X saves space in its colour table by using a
reference to its colour(1) above.  This would complicate the image
generation, so I arranged for my darkest image shade to be not quite
black.

This done, the routine worked fine by assuming the first 7 colours were not
to be used. Until..........

Well, I put the PROPERTIES display up with all its colour palettes.  And
found that I had a problem. X had placed the palette colours where I
expected mine to be, so I produced a pseudo-colour image.  To get round
this, I decided to generate the 64 shades in my small test image, retrieve
them with the XGetImage call and use the resulting pixel array as a
look-up table.

------------------------------------------------------------------------------*/

#define NBYTE 4			/* number of bytes per word on this machine */
#define NXCOLOR 7		/* number of colours used by Xview for frame,
				 * background etc. */

void     SplashImage(image, sscale)
IMAGE   *image;			/* our image format */
int      sscale;
{
    XImage  *ximage;		/* the X image format  */
    char    *data, *data1, *save;
    int      i, j, saved_bytes, ii, jj, im, nbl, nxc, nyc, imi, imj;


    DrawInto(imagecanvas);

    nxc = Bounded(image->cols * sscale, 0, winwidth);
    nyc = Bounded(image->rows * sscale, 0, winheight);

    XClearWindow(display, win);	/* Clear the window */

    for (i = 0; i < 128; i++) {	/* Loop through the 64 grey shades */
	XSetForeground(display, gc,
		       colour_table[i]);	/* Set the drawing index */
	XDrawPoint(display, win, gc, i, 0);	/* Draw point */
    }


    ximage = XGetImage(display,	/* retrieve the image */
		       win,
		       0, 0, 128, 10, AllPlanes, ZPixmap);

    if (!(			/* check image format */
	  (ximage->byte_order == MSBFirst) &&
	  (ximage->bitmap_bit_order == MSBFirst) &&
	  (ximage->bitmap_unit == NBYTE * 8) &&
	  (ximage->depth == 8) &&
	  (ximage->bits_per_pixel == 8) &&
	  (ximage->xoffset == 0))) {

	printf("SplashImage: Incompatible X image format\n");
	printf("X image data\n");
	if (ximage->byte_order == LSBFirst)
	    printf("LSBFirst\n");
	if (ximage->byte_order == MSBFirst)
	    printf("MSBFirst\n");
	if (ximage->bitmap_bit_order == LSBFirst)
	    printf("bits: LSBFirst\n");
	if (ximage->bitmap_bit_order == MSBFirst)
	    printf("bits: MSBFirst\n");
	printf("bitmap_unit: %d\n", ximage->bitmap_unit);
	printf("depth: %d\n", ximage->depth);
	printf("bytes_per_line: %d\n", ximage->bytes_per_line);
	printf("bits_per_pixel: %d\n", ximage->bits_per_pixel);
	printf("width %d\n", ximage->width);
	printf("height %d\n", ximage->height);
	printf("xoffset %d\n", ximage->xoffset);
    } else {
	save = ximage->data;	/* retain original saved data pointer */

	nbl = (((nxc - 1) / NBYTE + 1) * NBYTE);	/* bytes per line */

	ximage->data = (char *) malloc(nbl * nyc * sizeof(char));
	if (ximage->data == NULL) {
	    VIP_Error_Msg("SplashImage: Unable to allocate memory for image");
	    return;
	} else {
	    saved_bytes = ximage->bytes_per_line;
	    ximage->bytes_per_line = nbl;

	    for (j = 0, imj = 0; j < nyc; j += sscale, imj++) {
		data = ximage->data + j * ximage->bytes_per_line;
		for (i = 0, imi = 0; i < nxc; i += sscale, imi++) {
		    im = *data = save[LUT[image->i.c[imj][imi]] / 2];	/* use array of pixel
									 * values as the lookup
									 * table */
		    data++;
		    for (ii = 1; ii < sscale; ii++, data++)
			*data = im;
		}
		for (jj = 1; (jj < sscale) && (j + jj < nyc); jj++) {
		    data1 = ximage->data + j * ximage->bytes_per_line;
		    data = data1 + jj * ximage->bytes_per_line;
		    for (i = 0; i < nxc; i++, data++, data1++)
			*data = *data1;
		}
	    }

	    ximage->width = nxc;
	    ximage->height = nyc;

	    XPutImage(display, win, gc,	/* now plonk the image into the
					 * window */
		      ximage,
		      0, 0,
		      0, 0,
		      nxc, nyc);

	    free((char *) ximage->data);	/* free up the temporary area */

	    ximage->width = 128;
	    ximage->height = 10;
	    ximage->bytes_per_line = saved_bytes;	/* restore original
							 * ximage */
	    ximage->data = save;/* structure */

	    XDestroyImage(ximage);	/* free up that memory too */

	}
    }
    REDRAWN = TRUE;
    return;
}


/*- InitWindows  ----------------------------------------------------------*/

void InitWindows(argc, argv)
int      argc;
char    *argv[];
{
    int      i, j;
    int      rgb[3];		/* red, green blue values */
    static Xv_singlecolor colour[231];	/* The colour table. */
    Cms      cms;		/* The Colour Map Segment. Used to initialize
				 * the color table. */
    Display *disp;

    if (argc == 2)
	strcpy(ARGVIMAGE, argv[1]);
    else
	strcpy(ARGVIMAGE, "\0");

    Set_Look_Up_Table(LUT, 1.0);

    SetUpColours(colour);

    /* Create the colour map segment. */
    cms = (Cms) xv_create(XV_NULL, CMS,
			  CMS_SIZE, 231,
			  CMS_COLORS, colour,
			  XV_NULL);

    /* Create the link to the global colour_table. */
    colour_table = (unsigned long *) xv_get(cms, CMS_INDEX_TABLE);



    /* Create a frame setting the label, width and height. */
    frame = (Frame) xv_create(XV_NULL, FRAME,
			      FRAME_LABEL, "SPLASH",
			      XV_X, 1,
			      XV_Y, 1,
			      XV_WIDTH, 512,
			      XV_HEIGHT, 100,
			      XV_NULL);

    /* Create a panel. */
    panel = (Panel) xv_create(frame, PANEL, XV_NULL);

    (void) xv_create(panel, PANEL_BUTTON,
		     XV_X, 10,
		     XV_Y, 30,
		     PANEL_LABEL_STRING, "Quit",
		     PANEL_NOTIFY_PROC, quit,
		     XV_NULL);


    toolbutton = xv_create(panel, PANEL_BUTTON,
		     XV_X, 200,
		     XV_Y, 90,
		     PANEL_LABEL_STRING, "tools",
                     PANEL_INACTIVE, !image1,
		     PANEL_NOTIFY_PROC, showtoolsframe,
		     XV_NULL);


    magbutton = xv_create(panel, PANEL_CHOICE,
		     XV_X, 70,
		     XV_Y, 30,
		     PANEL_LABEL_STRING, "Magnification",
                     PANEL_INACTIVE, !image1,
		     PANEL_CHOICE_STRINGS,
		     "1", "2", "3", "4", "5", "6", XV_NULL,
		     PANEL_VALUE, 0,	/* the first item */
		     PANEL_NOTIFY_PROC, SetMagnification,
		     XV_NULL);


    (void) xv_create(panel, PANEL_TEXT,
		     XV_X, 10,
		     XV_Y, 60,
		     PANEL_LABEL_STRING, "Image filename ",
		     PANEL_VALUE, ARGVIMAGE,
		     PANEL_VALUE_DISPLAY_LENGTH, 40,
		     PANEL_NOTIFY_PROC, GetFile,
		     PANEL_NOTIFY_STRING, "\n\r",
		     XV_NULL);




    /*
     * Create a canvas thats parent is the frame. Give it a width and height.
     * Tell it what CMS to use.
     */


    uvintcanvas = (Canvas) xv_create(frame, CANVAS,
				     XV_X, 0,
				     XV_Y, 100,
				     XV_WIDTH, 150,
				     XV_HEIGHT, 40,
				     CANVAS_WIDTH, 150,
				     CANVAS_HEIGHT, 30,
				     CANVAS_AUTO_SHRINK, FALSE,
				     CANVAS_AUTO_EXPAND, TRUE,
				     WIN_CMS, cms,
				     XV_NULL);



    imagecanvas = (Canvas) xv_create(frame, CANVAS,
				     XV_X, 0,
				     XV_Y, 140,
				     XV_WIDTH, 512,
				     XV_HEIGHT, 512,
				     WIN_CMS, cms,
				     XV_NULL);


    SaveDpy( xv_get (frame, XV_DISPLAY ),
                xv_get(canvas_paint_window(imagecanvas),XV_XID),
                xv_get( imagecanvas, XV_WIDTH),
                xv_get( imagecanvas, XV_HEIGHT));


    /*
     * Define all of the events that can occur in the canvas. When one of
     * these events occur it will call event_proc.
     */

    xv_set(canvas_paint_window(imagecanvas),
	   WIN_CONSUME_EVENTS,
           WIN_VISIBILITY_NOTIFY,
	   WIN_MOUSE_BUTTONS, WIN_ASCII_EVENTS, LOC_MOVE,
	   KBD_USE, KBD_DONE,
	   XV_NULL,
	   WIN_EVENT_PROC, event_proc,
	   XV_NULL);

    window_fit(frame);





    /* Tools Frame */

    toolsframe = (Frame) xv_create(XV_NULL, FRAME,
				   FRAME_LABEL, "TOOLS",
				   XV_X, 500,
				   XV_Y, 100,
				   XV_WIDTH, 400,
				   XV_HEIGHT, 100,
				   XV_SHOW, FALSE,
				   XV_NULL);


    panel = (Panel) xv_create(toolsframe, PANEL, PANEL_LAYOUT, PANEL_VERTICAL, NULL);

    (void) xv_create(panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Close",
		     PANEL_NOTIFY_PROC, hidetoolsframe,
		     XV_NULL);

    (void) xv_create(panel, PANEL_MESSAGE,
		     PANEL_LABEL_STRING, "xyz to uv conversion:",
		     XV_NULL);

    (void) xv_create(panel, PANEL_TEXT,
		     PANEL_LABEL_STRING, "Enter x y z ",
		     PANEL_VALUE_DISPLAY_LENGTH, 12,
		     PANEL_NOTIFY_PROC, testxyz2uv,
		     PANEL_NOTIFY_STRING, "\n\r",
		     XV_NULL);

    (void) xv_create(panel, PANEL_MESSAGE,
		     PANEL_LABEL_STRING, "uv to xyz conversion:",
		     XV_NULL);

    (void) xv_create(panel, PANEL_TEXT,
		     PANEL_LABEL_STRING, "Enter plane file and plane No ",
		     PANEL_VALUE_DISPLAY_LENGTH, 15,
		     PANEL_NOTIFY_PROC, testuv2xyz,
		     PANEL_NOTIFY_STRING, "\n\r",
		     XV_NULL);


    (void) xv_create(panel, PANEL_SLIDER,
		     PANEL_LABEL_STRING, "Gamma x 100",
		     PANEL_VALUE, 100,
		     PANEL_MIN_VALUE, 0,
		     PANEL_MAX_VALUE, 400,
		     PANEL_SLIDER_WIDTH, 300,
		     PANEL_NOTIFY_PROC, setgamma,
		     XV_NULL);


    (void) xv_create(panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Save Modified Image",
		     PANEL_NOTIFY_PROC, Show_Popup_Frame,
		     XV_NULL);


    slicecanvas = (Canvas) xv_create(toolsframe, CANVAS,
				     XV_X, 0,
				     XV_Y, 200,
				     XV_WIDTH, 512,
				     XV_HEIGHT, 150,
				     WIN_CMS, cms,
				     XV_NULL);

    LUTslicecanvas = (Canvas) xv_create(toolsframe, CANVAS,
					XV_X, 0,
					XV_Y, 350,
					XV_WIDTH, 512,
					XV_HEIGHT, 150,
					WIN_CMS, cms,
					XV_NULL);

    xyzcanvas = (Canvas) xv_create(toolsframe, CANVAS,
				   XV_X, 350,
				   XV_Y, 70,
				   XV_WIDTH, 150,
				   XV_HEIGHT, 40,
				   CANVAS_WIDTH, 150,
				   CANVAS_HEIGHT, 30,
				   CANVAS_AUTO_SHRINK, FALSE,
				   CANVAS_AUTO_EXPAND, TRUE,
				   WIN_CMS, cms,
				   XV_NULL);

    window_fit(toolsframe);

    popupframe = (Frame)xv_create(toolsframe, FRAME_CMD,
           XV_WIDTH, 300,
           XV_HEIGHT, 50,
           FRAME_LABEL, "Save Modified Image",
           XV_NULL);

    panel = (Panel)xv_get(popupframe, FRAME_CMD_PANEL);
    (void) xv_create(panel, PANEL_TEXT,
		     PANEL_LABEL_STRING, "Enter image name ",
		     PANEL_VALUE_DISPLAY_LENGTH, 15,
		     PANEL_NOTIFY_PROC, Write_Modified_Image,
		     PANEL_NOTIFY_STRING, "\n\r",
		     XV_NULL); 

    xv_main_loop(frame);
}

/*----------------------------------------------------------------------*/

void     quit()
{
    xv_destroy_safe(toolsframe);
    xv_destroy_safe(frame);
}

/*---------------------------------------------------------------------*/

void     DisplayNotice(message, event, parent)
char     message[60];
Event   *event;
Panel    parent;
{
    int      answer;

    answer = notice_prompt(parent, NULL,
			   NOTICE_FOCUS_XY, event_x(event), event_y(event),
			   NOTICE_MESSAGE_STRINGS, message,
			   NULL,
			   NOTICE_BUTTON_YES, "OK",
			   NULL);
    if (answer == NOTICE_YES)
	return;
}

/*---------------------------------------------------------------------*/

void     event_proc(window, event)	/* Called when there is an event in
					 * the canvas. */
Xv_Window window;
Event   *event;
{
    int      x, y;
    int      action;
    Xv_notice   badfile_notice;
    int      answer;


    if (event_is_ascii(event))
	quit();

    if (event_is_down(event) && event_action(event) == ACTION_SELECT) {
	action = ACTION_SELECT;
    } else if (event_is_down(event) && event_action(event) == ACTION_ADJUST) {
	action = ACTION_ADJUST;
    } else {
	action = 0;
    }
    x = event_x(event);
    y = event_y(event);
    Set_UVInt(x, y);
    (void) Make_Slice(x, y, action);
    if (STATE == CALCXYZ)
	(void) showxyz(x, y);

    /*
     * pass the display and window value to repaint. This is then used to set
     * the global display and window variables.
     */

    repaint((Canvas) NULL, window,
	    (Display *) xv_get(window, XV_DISPLAY),
    	    (Window) xv_get(canvas_paint_window(imagecanvas), XV_XID),
            (Xv_xrectlist *) NULL, event);

  if (firstime==1) {
    if (ARGVIMAGE[0]) {
        Free_Image(image1);
	image1 = ( IMAGE * ) Read_Image(ARGVIMAGE);
	if (image1) {
	    SplashImage(image1, magnification);
            xv_set(toolbutton, PANEL_INACTIVE, FALSE, XV_NULL);
            xv_set(magbutton, PANEL_INACTIVE, FALSE, XV_NULL);
	}
	else {
           int         res_stat;
            firstime=2;

            badfile_notice = xv_create (frame,
                            NOTICE,
                            NOTICE_FOCUS_XY, 60, 60,
                            NOTICE_MESSAGE_STRING, "Error : file not found or invalid ",
                            NOTICE_BUTTON_YES, "Continue",
                            NOTICE_STATUS, &res_stat,
                            XV_SHOW, TRUE,
                            XV_NULL);

            switch (res_stat) {
                case NOTICE_YES:
                  xv_destroy_safe(badfile_notice);
                  res_stat = 0;

                  XWarpPointer(( Display * )xv_get(frame, XV_DISPLAY), None,
                               xv_get(frame, XV_XID), 0, 0, 0, 0, 165, 65);

                  return;
             }
        }
        (void) strcpy(ARGVIMAGE, "\0");
    }
  }

  if (image1) {
     firstime=2;
  }
  else{
     firstime++;
  }


}

/*---------------------------------------------------------------------

Function to handle the digitising of slices


states: 0  - wait for first point
        1  - 1st point digitised - start rubber banding
        2  - 2nd point digitised - display slice


transitions: from 0 - 1 - when left mouse button pressed
             from 1 - 2 - when left mouse button pressed again
             from 2 - 0 - when middle mouse button pressed - clears slice
             from 2 - 1 - when left mouse button pressed - immediately starts new slice

----------------------------------------------------------------------*/



int      Make_Slice(x, y, action)
int      x, y, action;
{
    static int state = 0;
    static int x0, sy0;
    static int x1, sy1;
    static int xlast, ylast;


    if (image1 && x > 0 && x < image1->rows * magnification && y > 0 && y < image1->cols * magnification) {

	DrawInto(imagecanvas);

	XSetForeground(display, gc, colour_table[XORDRAW]);

	switch (state) {

	case 0:
	    if (action == ACTION_SELECT) {
		x0 = xlast = x;
		sy0 = ylast = y;
		state = 1;
	    }
	    break;


	case 1:
	    if (action == ACTION_SELECT) {	/* draw slice */
		x1 = xlast;
		sy1 = ylast;
		PlotSlice(x0, sy0, x1, sy1);
		state = 2;

	    } else {		/* rubber band */
		DrawSliceLine(x0, sy0, xlast, ylast);
		DrawSliceLine(x0, sy0, x, y);
		xlast = x;
		ylast = y;
		state = 1;
	    }
	    break;


	case 2:
	    if (action == ACTION_SELECT) {	/* clear slice and start new
						 * one */
		if (!REDRAWN) {
		    DrawSliceLine(x0, sy0, x1, sy1);
		    XDrawPoint(display, win, gc, x0, sy0);
		}
		x0 = xlast = x;
		sy0 = ylast = y;
		state = 1;
	    } else if ((action == ACTION_ADJUST)) {	/* clear slice */
		if (!REDRAWN) {
		    DrawSliceLine(x0, sy0, xlast, ylast);
		    XDrawPoint(display, win, gc, x0, sy0);
		}
		state = 0;
	    }
	    break;


	}			/* switch */
    }
    return (0);
}

/*- DrawSliceLine-----------------------------------------------------*/

int      DrawSliceLine(x0, ly0, x1, ly1)
int      x0, ly0, x1, ly1;
{
    DrawInto(imagecanvas);
    XSetForeground(display, gc, colour_table[XORDRAW]);
    XSetFunction(display, gc, GXxor);
    XDrawLine(display, win, gc, x0, ly0, x1, ly1);
    REDRAWN = FALSE;
    return (0);
}

/*---------------------------------------------------------------------*/

void     repaint(can, paint_window, dpy, xwin, xrects, event)
Canvas   can;			/* Ignored */
Xv_Window paint_window;		/* Ignored */
Display *dpy;
Window   xwin;
Xv_xrectlist *xrects;		/* Ignored */
Event   *event;			/* Ignored */
{

    if (event_action(event) == WIN_REPAINT && image1)
	SplashImage(image1, magnification);

    return;
}


/*----------------------------------------------------------------------*/

void     showtoolsframe()
{
    xv_set(toolsframe, XV_SHOW, TRUE, XV_NULL);
    return;
}

/*----------------------------------------------------------------------*/

void     hidetoolsframe()
{
    xv_set(toolsframe, XV_SHOW, FALSE, XV_NULL);
    return;
}


/*----------------------------------------------------------------------*/

void     Show_Popup_Frame()
{
    xv_set(popupframe, XV_SHOW, TRUE, XV_NULL);
    return;
}

/*----------------------------------------------------------------------*/




void     SetMagnification(item, value, event)
Panel_item item;
unsigned int value;
Event   *event;

{
    magnification = Bounded(( int ) value + 1, 1, 6);
    if (image1)
	SplashImage(image1, magnification);

    return;
}

/*----------------------------------------------------------------------*/


void     GetFile(item, event)
Panel_item item;
Event   *event;

{

    char    *filename;
    Xv_notice   badfile_notice;

    int      result;
    char     message[60];
    int      answer;

    Free_Image(image1);
    image1 = ( IMAGE * ) NULL;
    filename = (char *) xv_get(item, PANEL_VALUE);
    image1 = ( IMAGE * ) Read_Image(filename);
    if (image1) {
	SplashImage(image1, magnification);
        xv_set(toolbutton, PANEL_INACTIVE, FALSE, XV_NULL);
        xv_set(magbutton, PANEL_INACTIVE, FALSE, XV_NULL);
        firstime=2;
    }
    else {
        int     res_stat;
        firstime=2;
        xv_set(toolbutton, PANEL_INACTIVE, TRUE, XV_NULL);
        xv_set(magbutton, PANEL_INACTIVE, TRUE, XV_NULL);

        badfile_notice = xv_create (frame,
                            NOTICE,
                            NOTICE_FOCUS_XY, 60, 60,
                            NOTICE_MESSAGE_STRING,"Error : file not found or invalid",
                            NOTICE_BUTTON_YES, "Continue",
                            NOTICE_STATUS, &res_stat,
                            XV_SHOW, TRUE,
                            XV_NULL);

        switch (res_stat) {
            case NOTICE_YES:
                xv_destroy_safe(badfile_notice);
                res_stat = 0;
                return;
        }
    }
}

/*--------------------------------------------------------------*/

int      Bounded(v, min, max)
int      v, min, max;

{
    if (v < min)
	return (min);
    else if (v > max)
	return (max);
    else
	return (v);
}


/*--------------------------------------------------*/

void Set_UVInt(x, y)
int      x, y;

{
    char     uvstring[30];
    int      u, v;

    DrawInto(uvintcanvas);

    XSetFunction(display, gc, GXcopy);	/* normal line drawing */
    XSetForeground(display, gc, colour_table[WHITE]);
    XFillRectangle(display, win, gc, 0, 0, 150, 40);	/* clear previous text */

    XSetForeground(display, gc, colour_table[BLACK]);

    u = x / magnification;
    v = y / magnification;

/*
    if (image1
	&& u < image1->rows
	&& v < image1->cols)
	sprintf(uvstring, "%3d %3d    %3d", u, v, image1->i.c[v][u]);
    else
	sprintf(uvstring, "%3d %3d ", u, v);
*/


   if (image1 ) {
        if (( v < image1->rows ) && ( u < image1->cols)) {
            if (( v == 0 ) && ( u == 0)) {
                (void) sprintf(uvstring, "%s", "                     ");
            }
            else {
                (void) sprintf(uvstring, "%3d %3d    %3d", u, v, image1->i.c[v][
u]);
            }
        }
        else {
            (void) sprintf(uvstring, "%s", "                     ");
        }
    }
    else {
        (void) sprintf(uvstring, "%s", "                     ");
    }



    XDrawString(display, win, gc, 10, 12, "  u    v    intensity", 21);
    XDrawString(display, win, gc, 10, 32, uvstring, strlen(uvstring));

    return;
}


/*- PlotSlice --------------------------------------------------*/

int      PlotSlice(x0, py0, x1, py1)
int      x0, py0, x1, py1;
{
    int      i, u, v, du, dv, Npixels;
    double  *slice, *LUTslice;
    int      width;
    double   uscale, vscale;

    if (!image1)
	return (0);		/* no image - no slice */

    DrawInto(slicecanvas);
    XSetFunction(display, gc, GXcopy);
    XSetForeground(display, gc, colour_table[WHITE]);
    XFillRectangle(display, win, gc, 0, 0, 512, 256);	/* clear previous text */
    XSetForeground(display, gc, colour_table[BLACK]);


    SaveRetrieveSlicePts(1, &x0, &py0, &x1, &py1);	/* save where the slice
							 * came from */

    x0 /= magnification;
    x1 /= magnification;
    py0 /= magnification;
    py1 /= magnification;

    du = x1 - x0;
    dv = py1 - py0;

    if (abs(du) > abs(dv))	/* line being scanned is more horizontal */
	Npixels = abs(du);
    else			/* line is more vertical */
	Npixels = abs(dv);

    if (Npixels == 0)
	Npixels = 1;

    slice = (double *) malloc(Npixels * sizeof(double));	/* allocate buffer */
    LUTslice = (double *) malloc(Npixels * sizeof(double));	/* allocate buffer */

    /* Copy pixels in image into buffer */

    uscale = (double) du / (double) Npixels;
    vscale = (double) dv / (double) Npixels;

    for (i = 0; i < Npixels; i++) {
	u = x0 + (double) i *uscale;
	v = py0 + (double) i *vscale;

	slice[i] = image1->i.c[v][u];
	LUTslice[i] = LUT[image1->i.c[v][u]];
    }

    Graph(slice, Npixels, 0.0, (double) Npixels, 50.0, 0.0, 255.0, 50.0, "Raw Slice Plot");


    DrawInto(LUTslicecanvas);
    XSetFunction(display, gc, GXcopy);
    XSetForeground(display, gc, colour_table[WHITE]);
    XFillRectangle(display, win, gc, 0, 0, 512, 256);	/* clear previous text */
    XSetForeground(display, gc, colour_table[BLACK]);

    Graph(LUTslice, Npixels, 0.0, (double) Npixels, 50.0, 0.0, 255.0, 50.0,
	  "Slice values through look up table");

    free(( char * ) slice);
    free(( char * ) LUTslice);
    return (0);
}


/*- SaveRetrieveSlicePts ------------------------------------------------------

Function to store or retrieve the end points of the slice line
If flag is TRUE data is saved
IF flag is FALSE data is stored

-------------------------------------------------------------------------------*/

int      SaveRetrieveSlicePts(flag, x0, ry0, x1, ry1)
int      flag, *x0, *ry0, *x1, *ry1;
{
    static int sx0, sy0, sx1, sy1;

    if (flag) {			/* save */
	sx0 = *x0;
	sy0 = *ry0;
	sx1 = *x1;
	sy1 = *ry1;
    } else {			/* retrieve */
	*x0 = sx0;
	*ry0 = sy0;
	*x1 = sx1;
	*ry1 = sy1;
    }

    return (0);
}

/*- testxyz2uv --------------------------------------------------------*/

int      testxyz2uv(item)
Panel_item item;
{
    double   v[3];
    int      uv[2];
    char    *params;

    params = (char *) xv_get(item, PANEL_VALUE);
    (void) sscanf(params, "%lf %lf %lf", &v[0], &v[1], &v[2]);
    xyz2uv(image1->camera, uv, v);
    (void) printf("uv %d %d \n", uv[0], uv[1]);

    v[0] *= magnification;
    v[1] *= magnification;

/*
    uv[0] *= magnification;
    uv[1] *= magnification;
*/

    DrawInto(imagecanvas);
    XSetForeground(display, gc, colour_table[RED]);
    XSetFunction(display, gc, GXcopy);

    XDrawLine(display, win, gc, uv[0] - 22,
                                uv[1] - 2,
                                uv[0] + 18,
                                uv[1] - 2 );

    XDrawLine(display, win, gc, uv[0] - 2,
                                uv[1] - 22,
                                uv[0] - 2,
                                uv[1] + 18);

        if (image1->camera.calib_status == 0 ) {
            (void) sprintf (spl_str, "Warning: uncalibrated image\n");
            splash_error(spl_str, toolsframe);
        }

    return (1);
}


/*- testuv2xyz --------------------------------------------------------*/

int      testuv2xyz(item, event)
Panel_item item;
Event  *event;
{
    char     file[40];
    static char     prev_file[40];
    int      planeNo;
    int      res_rd = 0;
    char    *params;
    int     i = 0;
    extern long PLANEBYTE;

    params = (char *) xv_get(item, PANEL_VALUE);
    (void) sscanf(params, "%s %d", file, &planeNo);

    if (strcmp(prev_file, file)!=0) {
        /*
         PLANEBYTE = 0;
        */

    }

    (void) strcpy (prev_file,file);

    if (planeNo < FILEPLANEMIN || planeNo > FILEPLANEMAX) {
        (void) strcpy(spl_str, "Error : plane number out of range\n 1 <= plane number <= 39\
n please try again\n");
        splash_error(spl_str, toolsframe);
        return (1);
    }

    res_rd = Read_Plane_List(file, planeNo);

    if (res_rd==9) {
        (void) strcpy (spl_str, "Error : invalid file name specified\n please try again\n");
        splash_error(spl_str, toolsframe);
        return (1);
    }

    if (res_rd==8) {
        (void) strcpy (spl_str, "Error : plane number requested not specified in plane file\
n please try again \n");
        splash_error(spl_str, toolsframe);
        return (1);
    }

    if (res_rd==5) {
        (void) strcpy (spl_str, "Error : plane number in plane file out of range\n
                             1 <= plane number <= 39\n please edit file and try again\n");
        splash_error(spl_str, toolsframe);
        return (1);
    }

    Print_Matrix_d(PLANE[planeNo], 3, 3);

    Calc_Sensor(image1->camera, PLANE[planeNo], &sensor);

    if (image1->camera.calib_status  == 0) {
       (void) sprintf (spl_str, "Warning: uncalibrated image\n");
       splash_error(spl_str, toolsframe);
    }

    STATE = CALCXYZ;

    return (1);
}

/*- showxyz  --------------------------------------------------------*/

int      showxyz(u, v)
int      u, v;
{
    int      uv[2];
    double   xyz[3];
    char     xyzstring[30];


    uv[0] = u / magnification;
    uv[1] = v / magnification;

    if (image1 && uv[0] < image1->rows && uv[1] < image1->cols
	&& uv[0] > 0 && uv[1] > 0) {

	uv2xyz(uv, xyz, sensor);

	DrawInto(xyzcanvas);


	XSetFunction(display, gc, GXcopy);	/* normal line drawing */
	XSetForeground(display, gc, colour_table[WHITE]);
	XFillRectangle(display, win, gc, 0, 0, 150, 40);	/* clear previous text */

	XSetForeground(display, gc, colour_table[BLACK]);


	(void) sprintf(xyzstring, "%6.3lf %6.3lf %6.3lf", xyz[0], xyz[1], xyz[2]);


	XDrawString(display, win, gc, 10, 12, "    x      y      z", 19);
	XDrawString(display, win, gc, 10, 32, xyzstring, strlen(xyzstring));

    }
    return (1);
}

/*- gamma --------------------------------------------------------------*/

void     setgamma(item, event)
Panel_item item;
Event   *event;
{
    int      ipower;
    double   power;
    int      x0, gmy0, x1, gmy1;

    ipower = (int) xv_get(item, PANEL_VALUE);
    power = (double) ipower / 100.0;

    Set_Look_Up_Table(LUT, power);
    if (image1) {
	SplashImage(image1, magnification);
	SaveRetrieveSlicePts(0, &x0, &gmy0, &x1, &gmy1);	/* retrieve where the
							 * slice came from */
	DrawSliceLine(x0, gmy0, x1, gmy1);
	PlotSlice(x0, gmy0, x1, gmy1);
    }
    return;
}


/*-----------------------------------------------------------*/

void Write_Modified_Image(item, event)
Panel_item item;
Event   *event;
{
IMAGE *tmpimage;
int i,j;
char    *filename;

filename = (char *) xv_get(item, PANEL_VALUE);

if (strcmp(filename,"")==0) {
    (void) strcpy (spl_str, "Error : target filename not specified\n please try again");
    splash_error (spl_str, popupframe);
    return;
}

if (image1) {
    tmpimage = ( IMAGE * ) Allocate_Image(0,0,image1->rows,image1->cols,BYTETYPE);
}
else {
    (void) strcpy (spl_str, "Error : source image not specified\n please try again");
    splash_error (spl_str, frame);
    return;
}

for(i = 0; i < image1->rows; i++)
  for(j = 0; j < image1->cols; j++)
   tmpimage->i.c[i][j] = LUT[image1->i.c[i][j]];

Write_Image(tmpimage,filename);
Free_Image(tmpimage);
    xv_set(popupframe, XV_SHOW, FALSE, XV_NULL);
return;
}

void     splash_error(err_str, pframe)
 char   *err_str;
 Frame  pframe;
{

    Xv_notice   badfile_notice;
    int         res_stat;

        badfile_notice = xv_create (pframe,
                            NOTICE,
                            NOTICE_FOCUS_XY, 30, 30,
                            NOTICE_MESSAGE_STRING, err_str,
                            NOTICE_BUTTON_YES, "Continue",
                            NOTICE_STATUS, &res_stat,
                            XV_SHOW, TRUE,
                            XV_NULL);

        switch (res_stat) {
            case NOTICE_YES:
                xv_destroy_safe(badfile_notice);
                res_stat = 0;
                (void) strcpy(err_str,"\0");
        }
}
