/******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:		SPLASH            
* MODULE:		splash_motif.c - miscellaneous motif related code
*					 for splashm.
* REVISION:             3.1
* AUTHOR:               CFF
* CREATION DATE:	16 Dec 1993 
* REVISION DATE:	12/16/93
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	16 Dec 1993
* COMMENT:		Created and SCCS'd ANSI splash_color.c (for Motif build)
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)splash_motif.c	3.1 12/16/93";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <memory.h>
#include <ctype.h>
#include <math.h>

#include <X11/Intrinsic.h>
#include <X11/Xutil.h>
#include <Xm/Xm.h>

#include "graphics.h"
#include "splash_motif.h"
#include "splash_motiffn.h"


/******************************************** GLOBAL DEFS ******************************************/

unsigned long 	*color_table;


void set_colormap (col)
  Xv_singlecolor *col;
{
    int i;
    ColorCell	*colorCells;

  /*
     takes the colour[] array set up by James and maps it to
     colorCells so it can be built into a colour table. 
  */

    colorCells = (ColorCell *) malloc(sizeof(ColorCell) * 256);
    colour_table = (unsigned long *) malloc(sizeof(unsigned long) * 256);


    for (i = 0; i < 256; i++)
    {
        colorCells[i].color.pixel = (unsigned long) i;

        if (i == 255) {
            colorCells[i].color.red   = i * 500;
            colorCells[i].color.green = 0;
            colorCells[i].color.blue  = 0;

	    XAllocColor (display, cmap, &colorCells[i].color);
        }
	else {
            colorCells[i].color.red   = i * 500;
            colorCells[i].color.green = i * 500;
            colorCells[i].color.blue  = i * 500;

	    XAllocColor (display, cmap, &colorCells[i].color);
	}
    }

    for (i = 0; i < 256; i++) 
    {
        colour_table[i] = colorCells[i].color.pixel;
    }
}


void window_fit(win)
  Widget	win;
{
  Arg	args[3];
  
  XtSetArg (args[0], XmNheight, 0);
  XtSetArg (args[1], XmNwidth, 0);
  XtSetValues (win, args, 2);
}

 
