/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            LIB
* MODULE:		ppmrgb.c -  Functions to read and manipulate
*                             	    colour ppm format images.		
* REVISION:             3.3
* AUTHOR:               CFF
* CREATION DATE:	29 July 1992	
* REVISION DATE:	8/16/93
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.3
* REVISION DATE:	16 August 1993
* COMMENT:		Fixed up for DEC build
* BY:			CFF
*
* REVISION:		3.2
* REVISION DATE:	05 August 1992
* COMMENT:		Changed header file names.
* BY:			CFF
*
* REVISION:		3.1
* CREATION DATE:	29 July 1992
* COMMENT:		A new set of library fns.
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)ppmrgb.c	3.3 8/16/93";
#endif


#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>

#include "vip.h"
#include "vipiofn.h"
#include "pmfn.h"
#include "pm.h"
#include "misc.h"




PPM *Read_RGB_PPM_Image(fname)
  char   *fname;
{
  FILE    *fp;
  PPM	  *ppm;
  int     b, c, i, j, k, l, x, y, ppmint=0, *tempint;
  char    ppmitem[4], ppmmagic[4], ppmwidth[4], ppmheight[4], maxcol[3], ppmdata[70];

    b = c = i = j = k = l = x = y = 0;

    ppm = ( PPM * ) malloc (sizeof(struct PPM_STRUCT));

    fp = fopen (fname, "r");

    if (fp == NULL) {
        (void) fprintf(stderr, "read open fails for file \"%s\"!\n", fname);
        exit(0);
    }

    if (fgets (ppmdata, 70, fp) != NULL) {
        while (ppmdata[0] == '#') {
            if (fgets (ppmdata, 70, fp) == NULL) {
                (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                exit(0);
            }
        }

        for (i=0; ppmdata[i] != '\n'; i++) {
	    if (ppmmagic[i] != ' ') {
                ppmmagic[i] = ppmdata[i];
	    }
        }
    }
    else {
        (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
        exit(0);
    }

    ppmmagic[i] = '\0';

    if (fgets (ppmdata, 70, fp) != NULL) {
        while (ppmdata[0] == '#') {
            if (fgets (ppmdata, 70, fp) == NULL) {
                (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                exit(0);
            }
        }

        for (i=0; ppmdata[i] != ' '; i++) {
            if (ppmdata[i] != '\n') {
                ppmwidth[x] = ppmdata[i];
                x++;
            }
            else {
                i=-1;
                if (fgets (ppmdata, 70, fp) != NULL) {
        	    while (ppmdata[0] == '#') {
                        if (fgets (ppmdata, 70, fp) == NULL) {
                            (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                	    exit(0);
                        }
                    }
                    break;
	        }
                else {
        	    (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                     exit(0);
		}
            }

        }
    }
    else {
        (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
        exit(0);
    }


    ppmwidth[x] = '\0'; i++; x=0;

    for (; ppmdata[i] != ' '; i++) {
         if (ppmdata[i] != '\n') {
             ppmheight[x] = ppmdata[i];
             x++;
         } 
         else {
             i=-1;
             if (fgets (ppmdata, 70, fp) != NULL) {
                 while (ppmdata[0] == '#') {
                    if (fgets (ppmdata, 70, fp) == NULL) {
                        (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                        exit(0);
                    }
                 }
                 break;
     	     }
	     else {
                 (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                 exit(0);
             }
	     
         }
     }
 
     ppmheight[x] = '\0'; i++; x=0;
 
     for (; ppmdata[i] != ' '; i++) {
         if (ppmdata[i] != '\n') {
             maxcol[x] = ppmdata[i];
             x++;
         }
         else {
             break;
         }
     }
         
     maxcol[i] = '\0';
     i=0; x=0; ppmdata[i] = '\0';
 
     if ((strcmp(maxcol, "")) == 0) {
         if (fgets (ppmdata, 70, fp) != NULL) {
             while (ppmdata[0] == '#') {
                 if (fgets (ppmdata, 70, fp) == NULL) {
                     (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                     exit(0);
                 }
             }

             for (i=0; ppmdata[i] != '\n'; i++) {
                maxcol[i] = ppmdata[i];
             }
     	     maxcol[i] = '\0';
         }
         else {
             (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
             exit(0);
         }
     }

     ppm->coords = (int ***) malloc (sizeof(int) * atoi(ppmheight));
 
     for (b=0; b<atoi(ppmheight); b++) {
         ppm->coords[b] = (int **) malloc (sizeof(int) * atoi(ppmwidth));
         for (c=0; c<atoi(ppmwidth); c++) {
             ppm->coords[b][c] = (int *) malloc (sizeof(int) * 3);
         }
     }

     ppm->magic_no = ppmmagic;

     ppm->width = atoi(ppmwidth);
     ppm->height = atoi(ppmheight);
     ppm->maxcol = atoi(maxcol);

     if (strcmp(ppmmagic, "P3") == 0) {
         tempint = (int *) malloc (sizeof (int) 
		                   * atoi(ppmwidth) * atoi(ppmheight) * 3);
     }

     i=0;
     ppmwidth[i]=ppmheight[i]=maxcol[i]=ppmdata[i]='\0';

     if (strcmp(ppmmagic, "P6") == 0) {
        for (j =0; j < ppm->height; j++) {
            for (k =0; k < ppm->width; k++) {
                for (l =0; l < 3; l++) {
                    if ((ppmint = fgetc (fp)) > -1) {
                        ppm->coords[j][k][l] = ppmint;
                    }
                    else {
                        break;
                        break;
                        break;
                    }
            	}
            }
        }

        return (ppm);
     }

     if (strcmp(ppmmagic, "P3") == 0) {
        if (fgets (ppmdata, 70, fp) == NULL) {
            (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
            exit(0);
	}

        while (ppmdata[0] == '#') {
              if (fgets (ppmdata, 70, fp) == NULL) {
                   (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                   exit(0);
              }
        }

        for (;;) {
            if (ppmdata[i] == '\n') {
                i = 0; ppmdata[0] = '\0';
                if (fgets (ppmdata, 70, fp) == NULL) {
                    y=0;
                    for (j=0; j<ppm->height; j++) {
                        for (k=0; k<ppm->width; k++) {
                            for (l=0; l<3; l++, tempint[y++]) {
                                ppm->coords[j][k][l] = tempint[y];
                            }
                        }
                    }
                    return (ppm);
                }

                while (ppmdata[0] == '#') {
                    if (fgets (ppmdata, 70, fp) == NULL) {
                        (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                        exit(0);
                    }
                }

	    }

            while (ppmdata[i] == ' ') {
                i++;
                if (ppmdata[i] == '\n') {
                    break;
                }
            }

            for (x=0; ppmdata[i] != '\n'; i++) {
                if (ppmdata[i] != ' ') {
                    ppmitem[x] = ppmdata[i];
                    x++;
                }
                else {
                    ppmitem[x] = '\0';
                    tempint[y] = (int) atoi(ppmitem);
                    tempint[y++];
		    x=0;
                    ppmitem[x] = '\0';

                    while (ppmdata[i+1] == ' ') {
                        i++;
                        if (ppmdata[i] == '\n') {
                            break;
                        }
                    }
                }
            }   

            if (ppmdata[i] == '\n') {
                ppmitem[x] = '\0';
                if (strlen(ppmitem)>0) {
                    tempint[y] = atoi(ppmitem);
                    tempint[y++];
                    ppmitem[0] = '\0';
                    x=0;
                }
            }
        } /* for loop */
    }

    return (NULL);
}

IMAGE *RGB_PPM_To_VIP(ppm)
  PPM *ppm;
{
  IMAGE *im;
  int j, k, l;

    if (!(im = ( IMAGE * ) Allocate_Image(0, 0, ppm->height, ppm->width, RGBTYPE)))    {
            VIP_Error_Msg("PPM_To_VIP: out of memory");
            return (NULL);
    }

    for (j = 0; j < ppm->height; j++) {
       for(k = 0; k < ppm->width; k++ ) {
           for(l = 0; l < 4; l++) {
               im->i.rgb[j][k][l] = ppm->coords[j][k][l];
	   }
       }
    }

    return(im);
}
