/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            LIB
* MODULE:		pm.c -  Functions to read and manipulate
*                             	images of ppm, pgm or pbm format.		
* REVISION:             3.4
* AUTHOR:               CFF
* CREATION DATE:	05 August 1992	
* REVISION DATE:	4/11/94
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.4
* CREATION DATE:	11 April 1994
* COMMENT:		Fixed compiler warnings
* BY:			BJR
*
* REVISION:		3.3
* CREATION DATE:	16 August 1993	
* COMMENT:		Fixed up for DEC build
* BY:			CFF
*
* REVISION:		3.2
* CREATION DATE:	24 Nov 1992	
* COMMENT:		Fixed pbm bitmap handling.
* BY:			CFF
*
* REVISION:		3.1
* CREATION DATE:	05 August 1992	
* COMMENT:		A new set of library fns.
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)pm.c	3.4 4/11/94";
#endif


#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>

#include "vip.h"
#include "vipiofn.h"
#include "pm.h"
#include "pmfn.h"
#include "misc.h"




PPM *Read_PPM_Image(fname)
  char   *fname;
{
  FILE    *fp;
  struct PPM_STRUCT  *ppm;
  int     b, c, i, j, k, l, m, x, y, 
	  max_factor=0, ppmint=0, *tempint = NULL;
  char    ppmitem[4], ppmmagic[4], ppmwidth[4], ppmheight[4],
	  maxcol[3], ppmdata[70];
  unsigned char status, ppchar;

    b = c = i = j = k = l = m = x = y = 0;

    





    ppm = (  PPM * ) malloc (sizeof(struct PPM_STRUCT));

    fp = fopen (fname, "r");

    if (fp == NULL) {
        (void) fprintf(stderr, "read open fails for file \"%s\"!\n", fname);
        exit(0);
    }

    if (fgets (ppmdata, 70, fp) != NULL) {
        while (ppmdata[0] == '#') {
            if (fgets (ppmdata, 70, fp) == NULL) {
                (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                exit(0);
            }
        }

        for (i=0; ppmdata[i] != '\n'; i++) {
	    if (ppmmagic[i] != ' ') {
                ppmmagic[i] = ppmdata[i];
	    }
        }
    }
    else {
        (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
        exit(0);
    }

    ppmmagic[i] = '\0';

    if (fgets (ppmdata, 70, fp) != NULL) {
        while (ppmdata[0] == '#') {
            if (fgets (ppmdata, 70, fp) == NULL) {
                (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                exit(0);
            }
        }

        for (i=0; ppmdata[i] != ' '; i++) {
            if (ppmdata[i] != '\n') {
                ppmwidth[x] = ppmdata[i];
                x++;
            }
            else {
                i=-1;
                if (fgets (ppmdata, 70, fp) != NULL) {
        	    while (ppmdata[0] == '#') {
                        if (fgets (ppmdata, 70, fp) == NULL) {
                            (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                	    exit(0);
                        }
                    }
                    break;
	        }
                else {
        	    (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                     exit(0);
		}
            }

        }
    }
    else {
        (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
        exit(0);
    }


    ppmwidth[x] = '\0'; i++; x=0;

    for (; ppmdata[i] != ' '; i++) {
         if (ppmdata[i] != '\n') {
             ppmheight[x] = ppmdata[i];
             x++;
         } 
         else {
      	     if (strcmp(ppmmagic, "P4") == 0) {
	         break;
	     }

      	     if (strcmp(ppmmagic, "P1") == 0) {
	         break;
	     }
 

             i=-1;
             if (fgets (ppmdata, 70, fp) != NULL) {
                 while (ppmdata[0] == '#') {
                    if (fgets (ppmdata, 70, fp) == NULL) {
                        (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                        exit(0);
                    }
                 }
                 break;
     	     }
	     else {
                 (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                 exit(0);
             }
	     
         }
     }
 
     if ((strcmp(ppmmagic, "P1")) == 0) {
         strcpy (maxcol, "255");
         ppmheight[x] = '\0'; i=0; x=0;
     }
     else if ((strcmp(ppmmagic, "P4")) == 0) {
             strcpy (maxcol, "255");
             ppmheight[x] = '\0'; i=0; x=0;
     }
     else {
         ppmheight[x] = '\0'; i++; x=0;
 
         for (; ppmdata[i] != ' '; i++) {
             if (ppmdata[i] != '\n') {
                 maxcol[x] = ppmdata[i];
                 x++;
             }
             else {
                 break;
             }
         }
         
         maxcol[i] = '\0';
         i=0; x=0; ppmdata[i] = '\0';
 
         if ((strcmp(maxcol, "")) == 0) {
             if (fgets (ppmdata, 70, fp) != NULL) {
                 while (ppmdata[0] == '#') {
                     if (fgets (ppmdata, 70, fp) == NULL) {
                         (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                         exit(0);
                     }
                 }

                 for (i=0; ppmdata[i] != '\n'; i++) {
                    maxcol[i] = ppmdata[i];
                 }
     	         maxcol[i] = '\0';
             }
             else {
                 (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                 exit(0);
             }
         }
    }

     ppm->coordc = (int **) malloc (sizeof(int) * atoi(ppmheight));
 
     for (b=0; b<atoi(ppmheight); b++) {
         ppm->coordc[b] = (int *) malloc (sizeof(int) * atoi(ppmwidth));
     }

     ppm->magic_no = ppmmagic;

     ppm->width = atoi(ppmwidth);
     ppm->height = atoi(ppmheight);
     ppm->maxcol = atoi(maxcol);
     
     max_factor = 255/ppm->maxcol;

printf("magic %s width  %d height %d maxcol %d \n",ppmmagic, ppm->width,ppm->height,ppm->maxcol);

     if (strcmp(ppmmagic, "P4") == 0) {
/*
         tempint = (int *) malloc (sizeof (int) 
		                   * atoi(ppmwidth) * atoi(ppmheight));
*/
         tempint = (int *) malloc ((sizeof (int) 
		                   * (atoi(ppmwidth) * atoi(ppmheight)))*8); /* was 2 */
     }

     if (strcmp(ppmmagic, "P3") == 0) {
         tempint = (int *) malloc (sizeof (int) 
		                   * atoi(ppmwidth) * atoi(ppmheight) * 3);
     }

     if (strcmp(ppmmagic, "P2") == 0) {
         tempint = (int *) malloc (sizeof (int) 
		                   * atoi(ppmwidth) * atoi(ppmheight));
     }

     if (strcmp(ppmmagic, "P1") == 0) {
/*
         tempint = (int *) malloc (sizeof (int) 
		                   * atoi(ppmwidth) * atoi(ppmheight));
*/

         tempint = (int *) malloc ((sizeof (int) 
		                   * (atoi(ppmwidth) * atoi(ppmheight)))*2);
     }

     i=0;
     ppmwidth[i]=ppmheight[i]=maxcol[i]=ppmdata[i]='\0';

     y=0;
 
     if (strcmp(ppmmagic, "P4") == 0) {
        for (;;) {
            if ((ppmint = fgetc (fp)) > -1) {
                ppchar = ppmint;

  		if (ppchar != '\n' || ppchar != ' ') {
                    for (m=0; m<8; m++) {
	                status = ppchar << m;
                        if (status & 128) {
                            tempint[y] = 0;
		        }
		        else {
                            tempint[y] = 255;
		        }
		        y++;
                    }
	        }
            }
	    else {
	        k=ppm->width;
		j=ppm->height;
		break;
	    }
	  } 

	y=0;

        for (j=0; j < ppm->height; j++) {
            for (k=0; k < ppm->width+7; k++) {
                ppm->coordc[j][k] = tempint[y];
	  	y++;
	    }
        }

        return (ppm);
     }

     if (strcmp(ppmmagic, "P1") == 0) {
        if (fgets (ppmdata, 70, fp) == NULL) {
            (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
            exit(0);
	}

        while (ppmdata[0] == '#') {
              if (fgets (ppmdata, 70, fp) == NULL) {
                   (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                   exit(0);
              }
        }

	y=0;

        for (;;) {
            for (i=0; ppmdata[i] != '\n'; i++) {
                if (ppmdata[i] != ' ') {
                    if (ppmdata[i] == '1') {
	                tempint[y] = 0;
		    }
		    else {
		        tempint[y] = 255;
		    }
		    y++;
		}
	    }

	    if (ppmdata[i] == '\n') {
	        ppmdata[0] = '\0';
	        if (fgets (ppmdata, 70, fp) == NULL) {
                    y=0;
                    for (j=0; j<ppm->height; j++) {
                        for (k=0; k<ppm->width; k++) {
                            ppm->coordc[j][k] = tempint[y];
			    y++;
                        }
                    }
                    return (ppm);
                }

                while (ppmdata[0] == '#') {
                    if (fgets (ppmdata, 70, fp) == NULL) {
                        (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                        exit(0);
                    }
	 	}
	    }
 	}
     } /* end of P1 */

     if (strcmp(ppmmagic, "P5") == 0) {
/* what this was meant to do I don't know but I have commented it out - BJR */
/*
        ppm->width;
    	ppm->height;	
*/
        for (j =0; j < ppm->height; j++) {
            for (k =0; k < ppm->width; k++) {
                    if ((ppmint = fgetc (fp)) > -1) {
                                ppm->coordc[j][k] = max_factor*ppmint;
                    }
                    else {
		        k=ppm->width;
			j=ppm->height;
                    }
            }
        }

	return (ppm);
     }

     if (strcmp(ppmmagic, "P6") == 0) {
        for (j =0; j < ppm->height; j++) {
            for (k =0; k < ppm->width; k++) {
                for (l =0; l < 3; l++) {
                    if ((ppmint = fgetc (fp)) > -1) {
                        ppm->coordc[j][k] = max_factor*ppmint;
                    }
                    else {
                        break;
                        break;
                        break;
                    }
            	}
            }
        }

        return (ppm);
     }

     if (strcmp(ppmmagic, "P2") == 0) {
        if (fgets (ppmdata, 70, fp) == NULL) {
            (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
            exit(0);
	}

        while (ppmdata[0] == '#') {
              if (fgets (ppmdata, 70, fp) == NULL) {
                   (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                   exit(0);
              }
        }

        for (;;) {
            if (ppmdata[i] == '\n' || ppmdata[i] == '\0') {
                i = 0; ppmdata[0] = '\0';
                if (fgets (ppmdata, 70, fp) == NULL) {
                    y=0;
                    for (j=0; j<ppm->height; j++) {
                        for (k=0; k<ppm->width; k++) {
                            ppm->coordc[j][k] = max_factor*tempint[y];
			    y++;
                        }
                    }
                    return (ppm);
                }

                while (ppmdata[0] == '#') {
                    if (fgets (ppmdata, 70, fp) == NULL) {
                        (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                        exit(0);
                    }
                }

	    }

            while (ppmdata[i] == ' ') {
                i++;
                if (ppmdata[i] == '\n' || ppmdata[i] == '\0') {
                    break;
                }
            }

            for (x=0; ppmdata[i] != '\n' && ppmdata[i] != '\0'; i++) {
                if (ppmdata[i] != ' ') {
                    ppmitem[x] = ppmdata[i];
                    x++;
                }
                else {
                    ppmitem[x] = '\0';
                    tempint[y] = (int) atoi(ppmitem);
                    y++;
		    x=0;
                    ppmitem[x] = '\0';

                    while (ppmdata[i+1] == ' ') {
                        i++;
                        if (ppmdata[i] == '\n') {
                            break;
                        }
                    }
                }
            }   

            if (ppmdata[i] == '\n' || ppmdata[i] == '\0') {
                ppmitem[x] = '\0';
                if (strlen(ppmitem)>0) {
                    tempint[y] = atoi(ppmitem);
                    y++;
                    ppmitem[0] = '\0';
                    x=0;
                }
            }
        } 
    } /* P2 */

     if (strcmp(ppmmagic, "P3") == 0) {
        if (fgets (ppmdata, 70, fp) == NULL) {
            (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
            exit(0);
	}

        while (ppmdata[0] == '#') {
              if (fgets (ppmdata, 70, fp) == NULL) {
                   (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                   exit(0);
              }
        }

        for (;;) {
            if (ppmdata[i] == '\n') {
                i = 0; ppmdata[0] = '\0';
                if (fgets (ppmdata, 70, fp) == NULL) {
                    y=0;
                    for (j=0; j<ppm->height; j++) {
                        for (k=0; k<ppm->width; k++) {
                            for (l=0; l<3; l++, y++) {
                                ppm->coordc[j][k] = max_factor*tempint[y];
                            }
                        }
                    }
                    return (ppm);
                }

                while (ppmdata[0] == '#') {
                    if (fgets (ppmdata, 70, fp) == NULL) {
                        (void) fprintf(stderr, "read fails for file \"%s\"!\n", fname);
                        exit(0);
                    }
                }

	    }

            while (ppmdata[i] == ' ') {
                i++;
                if (ppmdata[i] == '\n') {
                    break;
                }
            }

            for (x=0; ppmdata[i] != '\n'; i++) {
                if (ppmdata[i] != ' ') {
                    ppmitem[x] = ppmdata[i];
                    x++;
                }
                else {
                    ppmitem[x] = '\0';
                    tempint[y] = (int) atoi(ppmitem);
                    y++;
		    x=0;
                    ppmitem[x] = '\0';

                    while (ppmdata[i+1] == ' ') {
                        i++;
                        if (ppmdata[i] == '\n') {
                            break;
                        }
                    }
                }
            }   

            if (ppmdata[i] == '\n') {
                ppmitem[x] = '\0';
                if (strlen(ppmitem)>0) {
                    tempint[y] = atoi(ppmitem);
                    y++;
                    ppmitem[0] = '\0';
                    x=0;
                }
            }
        } /* for loop */
    }

    return (NULL);
}

IMAGE *PPM_To_VIP(ppm)
  PPM *ppm;
{
  IMAGE *im;
  int j, k;

    if (!(im = ( IMAGE * ) Allocate_Image(0, 0, ppm->height, ppm->width, BYTETYPE))) {
            VIP_Error_Msg("PPM_To_VIP: out of memory");
            return (NULL);
    }

    for (j = 0; j < ppm->height; j++) {
       for(k = 0; k < ppm->width; k++ ) {
           im->i.c[j][k] = ppm->coordc[j][k];
       }
    }

    return(im);
}
