/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright 1988 University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            LIB
* MODULE:		mapcolor.c - colormap language interpretation
*				     routines.               
* REVISION:             3.3
* AUTHOR:               James Cooper
* CREATION DATE:        29 April 1988
* REVISION DATE:        4/11/94
*
********************************************************************************
*
* REVISION LOG
*
* REVISION NO:		3.3
* REVISION DATE:	11 April 1994
* COMMENT:		Fixed compiler warnings
* BY:			BJR
*
* REVISION NO:		3.2
* REVISION DATE:	15 August 1993
* COMMENT:		Fixed for DEC build		
* BY:			CFF
*
* REVISION NO:		3.1
* REVISION DATE:	9 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)mapcolor.c	3.3 4/11/94";
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifdef XVIEW
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/scrollbar.h>
#endif

#include "mapcolor.h"
#include "mapcolorfn.h"


#define true -1
#define false 0
#define newline(fp) {fscanf(fp,"%*[^\n]"); getc(fp);}

FILE *fp;
int charnum;
int debug = 0;
unsigned char rgb[3][256]; 
/*-------------------------------------------------------------------------
printf("%d-%d:(%d,%d,%d)-(%d,%d,%d)\n",,,,,,,,);
-------------------------------------------------------------------------*/

void do_error(ch1,ch2,str)
char ch1,ch2,*str;
{
    fprintf(stderr,"%s\n",str);
    fprintf(stderr,"syntax error: expected '%c' but found %c.\n",ch1,ch2);
}

/*-------------------------------------------------------------------------*/

char get_next_char(str)
char *str;
{
    return str[charnum++];
}

/*-------------------------------------------------------------------------*/

void unget_next_char(ch)
char ch;
{
    charnum--;
}

/*-------------------------------------------------------------------------*/

int read_number(str,num)
char *str;
float *num;
{
    int inval, i;
    char ch=get_next_char(str);
    char col_str[80];

    if (!isdigit(ch)){
        unget_next_char(ch);
        return false;
        }
    unget_next_char(ch);
    for (i=0; i< 80; i++){
        col_str[i] = get_next_char(str);
        if ((col_str[i] == ' ' ) ||
            (col_str[i] == '-' ) ||
            (col_str[i] == ',' ) ||
            (col_str[i] == '#') || 
            (col_str[i] == ')' ) ||
            (col_str[i] == '(' ) ||
            (col_str[i] == ':' ) ||
            (col_str[i] == '\n') ||
            (col_str[i] == '\0')){
            unget_next_char(col_str[i]);
            break;
            }
        }
    col_str[i] = 0;
    sscanf(col_str,"%d",&inval);
    if (inval > 255) {
        fprintf(stderr,"error: number must be between 0 and 255 ");
        fprintf(stderr,"but  was %d\n",inval);
        return false;
        }
    *num = (float) inval;
    return true;
}

/*-------------------------------------------------------------------------*/

int read_color(str,triple)
char *str;
float *triple;
{
    char col_str[80];
    int i, j;

    for (i=0; i< 80; i++){
        col_str[i] = get_next_char(str);
        if ((col_str[i] == '-') || 
            (col_str[i] == '#') || 
            (col_str[i] == ' ') || 
                    (col_str[i] == '\0') || 
            (col_str[i] == '\n')){
            unget_next_char(col_str[i]);
            break;
            }
        }
    col_str[i] = 0;
    for (i=0; i<MAX_COLOURS; i++){
        if (!palette[i].name){
            fprintf(stderr,"%s\nerror: ",str);
            fprintf(stderr,"%s not a recognised color.",col_str);
            return false;
            }
        if (!strcmp(col_str,palette[i].name))
            break;
        }
    for (j=0; j<3; j++)
        triple[j] = palette[i].val[j];
    return true;
}

/*-------------------------------------------------------------------------*/

int read_range(str,num1,num2)
char *str;
float *num1,*num2;
{
    char ch;
    if (read_number(str,num1)) {
        if ((ch=get_next_char(str)) == '-'){
            if (!read_number(str,num2))
                return false;
            }
        else {
            unget_next_char(ch);
            *num2 = *num1;
            return true;
            }
        }
    return true;
}

/*-------------------------------------------------------------------------*/

int read_triple(str,triple)
char *str;
float *triple;
{
    char ch=get_next_char(str);
    int i;
    float num;
    if (ch != '('){
        unget_next_char(ch);
        if (read_number(str,&num)){
            for (i=0; i<3; i++)
                triple[i] = num;
            return true;
            }
        else
            return read_color(str,triple);
        }

    if (!read_number(str,&triple[0])) return false;
    if ((ch = get_next_char(str)) != ','){
        do_error(',',ch,str);
        return false;
        }
    if (!read_number(str,&triple[1])) return false;
    if ((ch = get_next_char(str)) != ','){
        do_error(',',ch,str);
        return false;
        }
    if (!read_number(str,&triple[2])) return false;
    if ((ch = get_next_char(str)) != ')'){
        do_error(')',ch,str);
        return false;
        }
    return true;
}

/*-------------------------------------------------------------------------*/

int get_instruction(str,cm_min,cm_max,triple_min,triple_max)
char *str;
float *cm_min, *cm_max, *triple_min, *triple_max;
{
    int i;
    char ch;
    if (!read_range(str,cm_min,cm_max)) return false;
    if ((ch = get_next_char(str)) != ':'){
        do_error(':',ch,str);
        printf("found %c %c\n",ch,get_next_char(str));
        return false;
        }
    if (!read_triple(str,triple_min)) return false;
    switch (ch = get_next_char(str)) {
        case '\n': case ' ': case '\0':
            for (i=0; i<3; i++)
                triple_max[i] = triple_min[i];
            return true;
            break;
        case '-':
            return read_triple(str,triple_max);
            break;
        default:
            fprintf(stderr,"error: in %s extra character ",str);
            fprintf(stderr,"'%c' found after colormap",ch);
            fprintf(stderr,"instruction.\n");
            return false;
        }
    return false;
}

/*-------------------------------------------------------------------------*/

int do_instruction(str,rgb)
char *str;
unsigned char rgb[3][256];
{
    float cm_high, cm_low, val_high[3], val_low[3], step_size, scale, temp;
    int high, low, i, j;

    charnum = 0;
    if (!get_instruction(str,&cm_low,&cm_high,val_low,val_high))
        return false;
    if (debug)
        printf("%d-%d:(%d,%d,%d)-(%d,%d,%d)\n",(int)cm_low,(int)cm_high,
            (int)val_low[0],(int)val_low[1],(int)val_low[2],
            (int)val_high[0],(int)val_high[1],(int)val_high[2]);
    if (cm_high < cm_low){
        temp = cm_high;    cm_high = cm_low;     cm_low = temp;
        for (i=0; i<3; i++){
            temp = val_high[i];    
            val_high[i] = val_low[i];     
            val_low[i] = temp;
            }
        }
    high = (int) cm_high;
    low = (int) cm_low;
    for (i=0; i<3; i++){
        step_size = cm_high - cm_low;
        scale = (step_size != 0)? (val_high[i] - val_low[i])/step_size: 1.0;
        for (j=low; j<=high; j++) {
            rgb[i][j] = (int) (0.5+ val_low[i] + (float)(j-low)*scale);
            }
        }
    return true;
}

/*-------------------------------------------------------------------------*/

int read_instruction_string(fp,inst_str)
FILE *fp;
char *inst_str;
{
    int worked;
    do{
        worked = fscanf(fp,"%80s",inst_str);
        if (feof(fp))
            return false;
        else if (inst_str[0] == '#')
            newline(fp)
        else return worked;
    }while (!feof(fp));
}

/*-------------------------------------------------------------------------*/

int find_map(fp,map_name)
FILE *fp;
char *map_name;
{
    char str[80];
    for ( ; ; ) {
        fscanf(fp,"%80s",str);
        if (feof(fp))
            return false;
        if (strcmp(str,map_name))
            newline(fp)
        else return true;
        }
}

/*-------------------------------------------------------------------------*/

int interpret_colormap_file(file_name,map_name,rgb)
char *file_name, *map_name; 
unsigned char rgb[3][256];
{
    FILE *fp=stdin;
    char str[80];
    if (map_name)
        if (!strcmp(file_name,map_name)){
            if (!(fp=fopen(file_name,"r")))
                return false;
            }
        else if(!(fp=fopen(file_name,"r")) || (!find_map(fp,map_name)))
            return false;
    while (read_instruction_string(fp,str)){
        if (!strcmp(str,"$include")){
            fscanf(fp,"%80s",str);
            newline(fp);
            read_map(str,rgb, 0) ;
            }
        if (!strcmp(str,"$define")){
            fscanf(fp,"%80s",palette[num_colors].name);
            fscanf(fp,"%80s",str);
            if (str[0] != '('){
                do_error('(',str[0],str);
                palette[num_colors].name[0] = 0;
                }
            charnum = 0;
            read_triple(str,palette[num_colors++].val);
            newline(fp);
            }
        else if (!isdigit(str[0]))
            break;
        else if (!do_instruction(str,rgb)) {
            fprintf(stderr, "instruction failed\n");
            exit(1);
            }
        }
    return true;
}
/*
    for (i=20; i<25; i++)
    printf("%d: (%3d,%3d,%3d)\n",i,rgb[0][i],rgb[1][i],rgb[2][i]);
*/

/*-------------------------------------------------------------------------*/

int read_map(map_name,rgb, map_size)
char *map_name;
unsigned char rgb[3][256];
int map_size;
{
    static char home_rc[80];

    sprintf(home_rc,"%s/.colormap.rc",getenv("HOME"));
    if (!interpret_colormap_file(map_name,map_name,rgb))
        if (!interpret_colormap_file("colormap.rc",map_name,rgb))
            if (!interpret_colormap_file(home_rc,map_name,rgb)){
                fprintf(stderr,"error: '%s' not found.\n",map_name);
                return false;
                }
     return true;
}

/*-------------------------------------------------------------------------*/


#ifdef XVIEW
char *define_color_map(pw,map_name,instructions, map_size)
Pixwin  *pw; 
char *map_name, instructions[10][80];
int map_size;
{
    int i=0;
    static char name[80];
    /*
    do_instruction("0-255:black-white",rgb);
    */
    if (map_name[0])    
        if (!read_map(map_name,rgb, 0))
                return false;
    for (i=0; i<10; i++)
        if (instructions[i][0])
            do_instruction(instructions[i],rgb);
        else break;
    if (!map_name[0])
        sprintf(name,"%dmap", getpid());
    else
        sprintf(name,"%dmap_name", getpid());
    sprintf(name,"%d", getpid());
    /*
    pw_setcmsname(pw, name);
    pw_putcolormap(pw, 0, map_size, rgb[0], rgb[1], rgb[2]); 
    */ 
   return(name);
}
#endif


/*
main (argc, argv)
 int argc;
 char *argv[];
{
 
}
*/

