/** VIPEXAMPLE.C  ------------------------------------------------

Sample program that illustrates use of the VIP library.

This program thresholds an image.  Values in the input image that are
below the threshold are set to zero (black), values greater than the
threshold are set to 255 (white).

See also the Makefile in this directory.

Peter Kovesi  March 1992

-------------------------------------------------------------------*/

#include <stdio.h>
#include <malloc.h>
#include <math.h>
#include "vip.h"		/* the VIP include file */

main(argc, argv)
int     argc;
char   *argv[];
{

    IMAGE  *inimage, *outimage;	/* pointers to the images we will use */
    int     rows, cols, row, col;
    int     threshold;

    if (argc != 4) {
	printf("usage: vipexample in_image threshold  out_image \n");
	return;
    }

/* Read the image into memory.  */

    inimage = Read_Image(argv[1]);

/* Check that we read the data from the file.  Note Read_Image will report any errors
   so the following printf is not really necessary.
 */

    if (!inimage) {
	printf("Could not open %s\n", argv[1]);
	return;
    }

    threshold = atoi(argv[2]);

    rows = inimage->rows;
    cols = inimage->cols;

/* Allocate space for the output image */

    outimage = Allocate_Image(0, 0, rows, cols, BYTETYPE);

    if (!outimage) {
	printf("Could not allocate space for output image\n");
	return;
    }

/*
     Now do the thresholding
     Note that there is a VIP library function to do this
     and the code below could simply be replaced with:

     outimage = Thresh_Image(inimage, threshold);
*/

    for (row = 0; row < rows; row++) {
	for (col = 0; col < cols; col++) {
	    if (inimage->i.c[row][col] > threshold)
		outimage->i.c[row][col] = 255;
	    else
		outimage->i.c[row][col] = 0;
	}
    }


/* Note that in the code above we refer to pixels using:
   inimage->i.c[row][col]

   The i.c indicates that we wish to treat each pixel as an unsigned
   char.  Two other types of images that you may wish to use are:

   LONGTYPE   ( use inimage->i.l[row][col] to refer to pixels )
   FLOATTYPE  ( use inimage->i.f[row][col] )

*/


/* Write the image to a file */

    Write_Image(outimage, argv[3]);

/* Free the memory allocated for images */

    Free_Image(inimage);
    Free_Image(outimage);

    return;
}
