/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            INCLUDE
* MODULE:		misc.h - various useful definitions and macros.  
*				 These are intended to make programs more
*				 readable.		
* REVISION:             3.3
* AUTHOR:               PK
* CREATION DATE:        Oct 1986
* REVISION DATE:	3/21/94        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:             3.3
* REVISION DATE:	21 March 1994
* COMMENT:		Merged vector.h into misc.h
* BY:			CFF
*
* REVISION:             3.2
* REVISION DATE:	28 July 1993
* COMMENT:		Fixed up for DOS build
* BY:			CFF
*
* REVISION:             3.1
* REVISION DATE:	10 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* @(#)misc.h	3.3 3/21/94
*
*******************************************************************************/

#define __vector_h

#ifdef DOS
  #define TRUE   1L          /* Logical TRUE/FALSE */
  #define FALSE  0L
  #define ON     1L
  #define OFF    0L
  #define YES    1L
  #define NO     0L

  #define OK       1L        /*  Function returns */
  #define ERROR    0L

  #define AND  &&           /*  Alternate names for logical operators */
  #define OR   ||


  #define TWO_ROOT2   2.828427124L
  #ifndef PI
  #define PI          3.141592654L
  #endif
  #define SQRT_2PI    2.506628274L


  /*  Return the sign of an expression */

  #define SIGN(exp)  (((exp) < 0L) ? (-1L) : ( ((exp) == 0L) ? (0L) : (1L) ))


  /*  Return the minimum of two expressions  */

  #undef MIN
  #define MIN(exp1,exp2)  (((exp1) < (exp2)) ? (exp1) : (exp2))


  /*  Return the maximum of two expressions  */

  #undef MAX
  #define MAX(exp1,exp2)  (((exp1) > (exp2)) ? (exp1) : (exp2))

  #define SQR(a) ((a)*(a))

  /** Function declarations  **/
       

  /* ANSI fn. prtotypes in miscfn.h */

  /* in misc.c */
  /*
  void getline();
  char *leftjust();
  int Round(); */
#else  /* NOT a DOS machine */
  #define TRUE   1          /* Logical TRUE/FALSE */
  #define FALSE  0
  #define ON     1
  #define OFF    0
  #define YES    1
  #define NO     0

  #define OK       1        /*  Function returns */
  #define ERROR    0

  #define AND  &&           /*  Alternate names for logical operators */
  #define OR   ||


  #define TWO_ROOT2   2.828427124
  #ifndef PI
  #define PI          3.141592654
  #endif
  #define SQRT_2PI    2.506628274


  /*  Return the sign of an expression */

  #define SIGN(exp)  (((exp) < 0) ? (-1) : ( ((exp) == 0) ? (0) : (1) ))


  /*  Return the minimum of two expressions  */

  #undef MIN
  #define MIN(exp1,exp2)  (((exp1) < (exp2)) ? (exp1) : (exp2))


  /*  Return the maximum of two expressions  */

  #undef MAX
  #define MAX(exp1,exp2)  (((exp1) > (exp2)) ? (exp1) : (exp2))

  #define SQR(a) ((a)*(a))

  /** Function declarations  **/

  /* Absolute value macro */

  #define ABS(a)  ((a)>=0 ? (a):(-(a)))

  /* ANSI fn. prtotypes in miscfn.h */

  /* in misc.c */
  /*
  void getline();
  char *leftjust();
  int Round(); */
#endif

/*---------------------------------------------------------------

Various useful type definitions for vector and matrix operations

----------------------------------------------------------------*/

typedef double VEC_2[2];
typedef double VEC_3[3];
typedef double VEC_4[4];

typedef int IVEC_2[2];
typedef int IVEC_3[3];
typedef int IVEC_4[4];

typedef double MATRIX_2X2[2][2];
typedef double MATRIX_3X3[3][3];
typedef double MATRIX_4X4[4][4];
typedef double MATRIX_3X4[3][4];/* Used for camera calibration matricies */


/*---------------------------------------------------------------*/



