/*********************************************************************
*                   load_save.c                                      *
*                                                                    *
*  Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info.  *
*                                                                    *
*  This module contains code to load and save TIS images.            *
*                                                                    *
*  270395 -HT- Very first.. Load works with primary image.           *
*  290395 -HT- ..and with secondary image.                           *
*  030495 -HT- Saving of Master image works.                         *
*  090495 -HT- Some reorganization work: images are in one table.    *
*  160595 -HT- Makefile support.                                     *
*********************************************************************/

#include <X11/Xlib.h>
#include "image.h"
#include "externs.h"

Load_Image( nr )
unsigned char nr;
{
  unsigned char result;
  char file_name[30]={""};
  short i;

  switch( nr )
    {
    case 1:
      result = Get_String( &file_name, "Load primary file:" );
      break;
    case 2:
      result = Get_String( &file_name, "Load secondary file:" );
      break;
    default:
      result = Get_String( &file_name, "Load what:" );
      break;
    }
  if( !(result&1) && file_name[0]!=0 )
  {
    /* Any image: */
    if( !Read_XBM_Image( &Fake_Image, &file_name ) )
      {
      for( i=0; i<One_Image[nr].height; i++ )
        if( One_Image[nr].Colour_Map_Size>0 )
          free( One_Image[nr].data.map_lines[i] );
      if( One_Image[nr].Colour_Map_Size>0 )
        free( One_Image[nr].data.map_lines );
      One_Image[nr].width = Fake_Image.width;
      One_Image[nr].height = Fake_Image.height;
      One_Image[nr].Colour_Map_Size = Fake_Image.Colour_Map_Size;
      One_Image[nr].Colour_Map = Fake_Image.Colour_Map;
      One_Image[nr].data.rgb_lines = Fake_Image.data.rgb_lines;
      One_Image[nr].data.map_lines = Fake_Image.data.map_lines;
      printf("Load image %s\n", file_name );
      result=result|2;
      XClearWindow( theDisplay, theWindow );
      XFlush( theDisplay );          
      MakeImage( nr );
      }
    else
      printf("Cannot load image %s\n", file_name );
  }
  if( result&2 )
    {
    Refresh( nr );
    DrawPanel();
    }
}

Save_Image( nr )
unsigned char nr;
{
  unsigned char result;
  char file_name[30]={""};

  result = Get_String( &file_name, "Save Master image:" );
  if( !(result&1) && file_name[0]!=0 )
    {
    /* Master image: */
    Save_XBM_Image( &One_Image[3], &file_name );
    }
  if( result&2 )
    {
    Refresh( nr );
    DrawPanel();
    }
}
