/********************************************************************
*                    empty.c                                        *
*                                                                   *
* Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info.  *
*                                                                   *
*  This module contains code to generate empty image.               *
*                                                                   *
* 250395 -HT- Seem to work.                                         *
* 070495 -HT- Now image size is taken as argument.                  *
* 200495 -HT- Now we are also clearing image data here.             *
* 160595 -HT- Makefile support.                                     *
********************************************************************/

#include <X11/Xlib.h>
#include "image.h"
#include "externs.h"

Make_Empty_Image( Image, Width, Height )
struct Image_Struct *Image;
unsigned int Width, Height;
{
  /*unsigned int Width=10, Height=10;*/
  unsigned char *data, *map_line;
  int x, y, i;

  /* Let's mallocate some memory. */
  if( (Image->Colour_Map=(IMAGE_COLOUR *)malloc(2 * sizeof(IMAGE_COLOUR)))==NULL ) {      
      printf("Failed to allocate memory for Color Map.\n");
      Close();
      }
  Image->Colour_Map[0].Red=255;
  Image->Colour_Map[0].Green=255;
  Image->Colour_Map[0].Blue=255;
  Image->Colour_Map[1].Red=0;
  Image->Colour_Map[1].Green=0;
  Image->Colour_Map[1].Blue=0;
  if( (Image->data.map_lines = (unsigned char **)
       malloc(Height * sizeof(unsigned char *)))==NULL ) {
    printf("Failed to allocate memory for Image Data.\n");
    Close();
    }
 for( i=0; i<Height; i++ )
    {
    if( (map_line=(unsigned char *)malloc(Width*sizeof(unsigned char)))==NULL ) {      
      printf("Failed to allocate memory for Image Data.\n");
      Close();
      }
    Image->data.map_lines[i] = map_line;
    }

  Image->Colour_Map_Size=2;
  Image->width = Width;
  Image->height = Height;

  for( y=0; y<Image->height; y++ )
    for( x=0; x<Image->width; x++ )
      Image->data.map_lines[y][x] = 0;
}
