#ifndef lint
static char rcsid[] = "$Header: /usr/people/sam/tiff/libtiff/RCS/tif_unix.c,v 1.2 92/09/01 15:44:20 sam Exp $";
#endif

/*
 * Copyright (c) 1988, 1989, 1990, 1991, 1992 Sam Leffler
 * Copyright (c) 1991, 1992 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

/*
 * TIFF Library UNIX-specific Routines.
 */
#include "tiffioP.h"

static int
_tiffReadProc(fd, buf, size)
	int fd;
	char *buf;
	u_int size;
{
	return (read(fd, buf, size));
}

static int
_tiffWriteProc(fd, buf, size)
	int fd;
	char *buf;
	u_int size;
{
	return (write(fd, buf, size));
}

static long
_tiffSeekProc(fd, off, whence)
	int fd;
	long off;
	int whence;
{
	return (lseek(fd, off, whence));
}

static int
_tiffCloseProc(fd)
	int fd;
{
	return (close(fd));
}

#include <sys/stat.h>

static long
_tiffSizeProc(fd)
	int fd;
{
	struct stat sb;
	return (fstat(fd, &sb) < 0 ? 0 : sb.st_size);
}

#ifdef MMAP_SUPPORT
#include <sys/mman.h>

static int
_tiffMapProc(fd, pbase, psize)
	int fd;
	char **pbase;
	long *psize;
{
	long size = _tiffSizeProc(fd);
	if (size != -1) {
		*pbase = (char *)mmap(0, size, PROT_READ, MAP_SHARED, fd, 0);
		if (*pbase != (char *)-1) {
			*psize = size;
			return (1);
		}
	}
	return (0);
}

static void
_tiffUnmapProc(fd, base, size)
	int fd;
	char *base;
	long size;
{
	(void) munmap(base, size);
}
#else /* !MMAP_SUPPORT */
static int
_tiffMapProc(fd, pbase, psize)
	int fd;
	char **pbase;
	long *psize;
{
	return (0);
}

static void
_tiffUnmapProc(fd, base, size)
	int fd;
	char *base;
	long size;
{
}
#endif /* !MMAP_SUPPORT */

/*
 * Open a TIFF file descriptor for read/writing.
 */
TIFF *
TIFFFdOpen(fd, name, mode)
	int fd;
	const char *name;
	const char *mode;
{
	TIFF *tif;

	tif = TIFFClientOpen(name, mode,
	    (void*) fd,
	    _tiffReadProc, _tiffWriteProc, _tiffSeekProc, _tiffCloseProc,
	    _tiffSizeProc, _tiffMapProc, _tiffUnmapProc);
	if (tif)
		tif->tif_fd = fd;
	return (tif);
}

/*
 * Open a TIFF file for read/writing.
 */
TIFF *
TIFFOpen(name, mode)
	const char *name;
	const char *mode;
{
	static char module[] = "TIFFOpen";
	int m, fd;

	m = _TIFFgetMode(mode, module);
	if (m == -1)
		return ((TIFF *)0);
	fd = open(name, m, 0666);
	if (fd < 0) {
		TIFFError(module, "%s: Cannot open", name);
		return ((TIFF *)0);
	}
	return (TIFFFdOpen(fd, name, mode));
}

#if defined(__MACH__) || defined(THINK_C)
extern	void *malloc(size_t size);
extern	void *realloc(void *ptr, size_t size);
#else /* !__MACH__ && !THINK_C */
#if defined(_IBMR2)
#include <stdlib.h>
#else /* !_IBMR2 */
extern	char *malloc();
extern	char *realloc();
#endif /* _IBMR2 */
#endif /* !__MACH__ */

void *
_TIFFmalloc(s)
	size_t s;
{
	return (malloc(s));
}

void
_TIFFfree(p)
	void *p;
{
	free(p);
}

void *
_TIFFrealloc(p, s)
	void *p;
	size_t s;
{
	return (realloc(p, s));
}
