#import "p3m1.h"

@implementation p3m1
- resizeGenerator
{
  latticesize.height = 2.0 * bounds.size.height;
  latticesize.width = bounds.size.width * 2.0;
  upx = bounds.size.width;
  upy = 3.0/ 2.0 * bounds.size.height;
  overx = latticesize.width;
  return self;
}
- clip: (NXCoord) x: (NXCoord) y 
{ 
  PSnewpath();
  PSmoveto(x,y);
  PSrlineto(0,bounds.size.height);
  PSrlineto(bounds.size.width, -bounds.size.height / 2.0);
  PSclosepath();
  PSclip();
  return self;
}
 
- makeLatticeUnitAt: (NXPoint *) point fromImage: srcimg 
{
  id imgrep;
  NXPoint pt;
  
  pt.x = - point->x;
  pt.y = - point->y;

  imgrep = [srcimg bestRepresentation];
  DOCLIP(0.0,0.0,[imgrep drawAt: &pt]);
  reflect(30.0);
  DOCLIP(0.0,0.0,[imgrep drawAt: &pt]);
  PSrotate(120.0);
  DOCLIP(0.0,0.0,[imgrep drawAt: &pt]);
  reflect(30.0);
  DOCLIP(0.0,0.0,[imgrep drawAt: &pt]);
  PSrotate(-120.0);
  DOCLIP(0.0,0.0,[imgrep drawAt: &pt]);
  reflect(30.0);
  DOCLIP(0.0,0.0,[imgrep drawAt: &pt]);
  return self;
}

- sizeKludge: (float *) x : (float *) y
{
  *x = [self equi: *y];
  return self;
}
@end
