/*+-----------------------------------------------------------------------+
 *| TMS34020 Hardware Specifics                                           |
 *|                                                                       |
 *| Author: Michael S. A. Robb         Version: 1.1        Date: 16/06/93 |
 *+-----------------------------------------------------------------------+
 */

#define READ_ZBUFFER( A, Z )\
  { tms34010_setaddress( A );\
    Z.zbuf_hilo.zbuf_hi = tms34010_gethostregister( CPU_SLOWDATA );\
    Z.zbuf_hilo.zbuf_lo = tms34010_gethostregister( CPU_SLOWDATA ); }

#define WRITE_ZBUFFER( A, Z )\
  { tms34010_setaddress( A );\
    tms34010_sethostregister( CPU_SLOWDATA, Z.zbuf_hilo.zbuf_hi );\
    tms34010_sethostregister( CPU_SLOWDATA, Z.zbuf_hilo.zbuf_lo ); }

#define READ_PIXEL( A, P )\
  { tms34010_setaddress( A );\
    P.col_hilo.col_hi = tms34010_gethostregister( CPU_SLOWDATA );\
    P.col_hilo.col_lo = tms34010_gethostregister( CPU_SLOWDATA ); }

#define WRITE_PIXEL( A, P )\
  { tms34010_setaddress( A );\
    tms34010_sethostregister( CPU_SLOWDATA, P.col_hilo.col_hi );\
    tms34010_sethostregister( CPU_SLOWDATA, P.col_hilo.col_lo ); }

#define HARDWARE_PREPARE()\
    tms34010_sethostregister( CPU_CONTROL, HOST_AUTOINCR );

#define HARDWARE_RESTORE()\
    tms34010_sethostregister( CPU_CONTROL, HOST_NOINCR );

#define GRAPHICS_OPEN()\
  { tms34010_mode( &mode512x256x32bit );\
    tms34010_fillblockaddr32( 0L, 0,   0, 512, 256, 0x0L );\
    tms34010_fillblockaddr32( 0L, 0, 256, 512, 256, ZBUFFER_MAX ); }

#define GRAPHICS_CLOSE()\
    tms34010_setvga()
