#ifndef swShader_VertexShader_hpp
#define swShader_VertexShader_hpp

#include "CodeGenerator.hpp"

#include "Types.hpp"
#include "Color.hpp"
#include "XVertex.hpp"

namespace swShader
{
	class VertexShader : protected SoftWire::CodeGenerator
	{
	public:
		virtual void process(int i) = 0;

		virtual void setFloatConstant(int index, const float value[4]) = 0;
		virtual void setIntegerConstant(int index, const int integer[4]) = 0;
		virtual void setBooleanConstant(int index, bool boolean) = 0;

		virtual void setPositionStream(const float4 *position, int usageIndex = 0) = 0;
		virtual void setBlendWeightStream(const float4 *blendWeight) = 0;
		virtual void setBlendIndicesStream(const byte4 *blendIndices) = 0;
		virtual void setNormalStream(const float4 *normal, int usageIndex = 0) = 0;
		virtual void setPSizeStream(const float *pSize) = 0;
		virtual void setTexCoordStream(const float4 *texCoord, int usageIndex = 0) = 0;
		virtual void setTangentStream(const float4 *tangent) = 0;
		virtual void setBinormalStream(const float4 *binormal) = 0;
		virtual void setTessFactorStream(const float *tessFactor) = 0;
		virtual void setPositiontStream(const float4 *positiont) = 0;
		virtual void setColorStream(const Color<byte> *color, int usageIndex = 0) = 0;
		virtual void setFogStream(const float *fog) = 0;
		virtual void setDepthStream(const float *depth) = 0;
		virtual void setSampleStream(const float4 *sample) = 0;

		virtual void setOutputVertex(XVertex *output) = 0;
		virtual FVFFlags getOutputFormat() = 0;
	};
}

#endif swShader_VertexShader_hpp
