#ifndef swShader_Cache_hpp
#define swShader_Cache_hpp

namespace swShader
{
	template<class Key, class Data>
	class Cache
	{
	public:
		Cache(int n);

		~Cache();

		Data *query(const Key &key) const;
		Data *add(const Key &key, Data *data);

		void clear();

	private:
		const unsigned int size;
		unsigned int top;

		Key *key;
		Data **data;
	};
}

namespace swShader
{
	template<class Key, class Data>
	Cache<Key, Data>::Cache(int n) : size(n)
	{
		top = 0;

		key = new Key[n];

		data = new Data*[n];
		for(unsigned int i = 0; i < size; i++) data[i] = 0;
	}

	template<class Key, class Data>
	Cache<Key, Data>::~Cache()
	{
		delete[] key;
		key = 0;

		for(unsigned int i = 0; i < size; i++)
		{
			delete data[i];
			data[i] = 0;
		}

		delete[] data;
		data = 0;
	}

	template<class Key, class Data>
	Data *Cache<Key, Data>::query(const Key &key) const
	{
		for(unsigned int i = 0; i < size; i++)
		{
			unsigned int j = (top - i) % size;

			if(key == this->key[j])
			{
				return data[j];
			}
		}

		return 0;   // Not found
	}
	
	template<class Key, class Data>
	Data *Cache<Key, Data>::add(const Key &key, Data *data)
	{
		top++;
		unsigned int i = top % size;

		this->key[i] = key;
	
		delete this->data[i];
		this->data[i] = data;

		return data;
	}

	template<class Key, class Data>
	void Cache<Key, Data>::clear()
	{
		for(unsigned int i = 0; i < size; i++)
		{
			delete data[i];
			data[i] = 0;
		}
	}
}

#endif   // swShader_Cache_hpp
