#include "Keyboard.hpp"

#include "Error.hpp"

namespace swShader
{
	Keyboard::Keyboard(HWND windowHandle)
	{
		keyboardInterface = 0;

		init(windowHandle);
	}

	Keyboard::~Keyboard()
	{
		release();
	}

	void Keyboard::init(HWND windowHandle)
	{
		if(!directInput) Input::init(windowHandle);

		release();

		directInput->CreateDevice(GUID_SysKeyboard, &keyboardInterface, 0);
		keyboardInterface->SetDataFormat(&c_dfDIKeyboard);
		keyboardInterface->SetCooperativeLevel(windowHandle, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);

		acquire();
	}

	bool Keyboard::acquire()
	{
		if(!keyboardInterface) throw INTERNAL_ERROR;

		switch(keyboardInterface->Acquire())
		{
		case DI_OK:
		case S_FALSE:
			return true;
		case DIERR_OTHERAPPHASPRIO:
			return false;
		case DIERR_INVALIDPARAM:
		case DIERR_NOTINITIALIZED:
		default:
			throw INTERNAL_ERROR;
		}
	}

	void Keyboard::unacquire()
	{
		if(!keyboardInterface) throw INTERNAL_ERROR;

		keyboardInterface->Unacquire();
	}

	void Keyboard::input()
	{
		if(!keyboardInterface) throw INTERNAL_ERROR;

		keyboardInterface->GetDeviceState(sizeof(key), &key);
	}

	bool Keyboard::keyPressed(int k) const
	{
		return (key[k] & 0x80) != 0;
	}

	void Keyboard::release()
	{
		if(keyboardInterface)
		{
			unacquire();

			keyboardInterface->Release();
			keyboardInterface = 0;
		}
	}
}