/**
 ** sipp - SImple Polygon Processor
 **
 **  A general 3d graphic package
 **
 **  Copyright Jonas Yngvesson  (jonas-y@isy.liu.se) 1988/89/90/91
 **            Inge Wallin      (ingwa@isy.liu.se)         1990/91
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 1, or any later version.
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 ** You can receive a copy of the GNU General Public License from the
 ** Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 **/

/**
 ** viewpoint.h - Types and interface to viewpoint.c
 **/

#ifndef VIEWPOINT_H
#define VIEWPOINT_H

#include <geometric.h>

#define ZCLIPF 100.0        /* Magic number used when defining hither & yon */


/*
 * Viewpoint definition
 */
typedef struct {
    double x0, y0, z0;    /* viewpoint position */
    double x, y, z;       /* point to look at */
    Vector vec;           /* vector from point to eye, used in shading calc. */
    Vector up;            /* Up direction in the view */ 
    double focal_ratio;
} Viewpoint;


extern Viewpoint camera;          /* Viewpoint of the scene  */
extern double    hither;          /* Hither z-clipping plane */
extern double    yon;             /* Yonder z-clipping plane */

extern void      view_vec_eval();
extern void      get_view_transf();


#endif /* VIEWPOINT_H */
