/**
 ** sipp - SImple Polygon Processor
 **
 **  A general 3d graphic package
 **
 **  Copyright Jonas Yngvesson  (jonas-y@isy.liu.se) 1988/89/90/91
 **            Inge Wallin      (ingwa@isy.liu.se)         1990/91
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 1, or any later version.
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 ** You can receive a copy of the GNU General Public License from the
 ** Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 **/

/**
 ** rendering.h - Types and interface to the rendering.c
 **/

#ifndef RENDERING_H
#define RENDERING_H

#include <sipp.h>


/*
 * Modes for storing the image.
 */
#define PBM_FILE   0
#define PPM_FILE   1
#define PIXMAP     2


/*
 * Temporary storage of transformed vertices.
 */
typedef struct view_coord_3d {
    double                x, y, z;     /* Transformed vertex coordinates */
    double                nx, ny, nz;  /* average normal */
    double                u, v, w;     /* texture parameters */
    struct view_coord_3d *next;        /* next vertex in the list */
} View_coord;


/*
 * Entry in the edge list used in rendering.
 */
typedef struct edges_3d {
    int              y, y_stop;   /* Current point and interpolation steps */
    double           x, xstep;            
    double           z, zstep;
    double           nx, nxstep;  /* Current normal and interp. steps */
    double           ny, nystep;
    double           nz, nzstep;
    double           u, ustep;    /* Current texture coordinates and */
    double           v, vstep;    /* interp. steps                   */
    double           w, wstep;
    int              polygon;     /* Uniqe polygon id of the polygon to */
                                  /* which the edge belongs */
    Surface         *surface;     /* Surface that the edge belongs to */
    struct edges_3d *next;        /* Next edge on this scanline */
} Edge;


#endif /* RENDERING_H */
