/*
 * marble shader - simulates marble using noise & turbulence
 */

#include <math.h>
#include <stdio.h>

#include "sipp.h"
#include "noise.h"
#include "shaders.h"


extern bool noise_ready;


static void
marble(p, color, md)
    Vector *p;
    Color *color;
    Marble_desc *md;
{
    double x, t;

    x = p->x + turbulence(p, (double)(1.0 / 100.0)) * 5;
    x = sin(x);
    if (x > -0.1 && x < 0.1) {
        color->red = md->strip.red;
        color->grn = md->strip.grn;
        color->blu = md->strip.blu;
    } else if (x > -0.9 && x < 0.9){
        /* You are not supposed to understand this... */
        t = 7.0 / 6.0 - 1.0 / (6.25 * fabs(x) + 0.375);
        color->red = md->strip.red + t * (md->base.red - md->strip.red);
        color->grn = md->strip.grn + t * (md->base.grn - md->strip.grn);
        color->blu = md->strip.blu + t * (md->base.blu - md->strip.blu);
    } else {
        color->red = md->base.red;         
        color->grn = md->base.grn;
        color->blu = md->base.blu;
    }
}



void
marble_shader(nx, ny, nz, u, v, w, view_vec, lights, md, color)
    double  nx, ny, nz, u, v, w;
    Vector  view_vec;
    Lightsource *lights;
    Marble_desc *md;
    Color *color;
{
    Vector     tmp;
    Surf_desc  surface;

    if (!noise_ready) {
        noise_init();
    }

    tmp.x = u * md->scale;
    tmp.y = v * md->scale;
    tmp.z = w * md->scale;
    marble(&tmp, &surface.color, md);
    surface.ambient  = md->ambient;
    surface.specular = md->specular;
    surface.c3       = md->c3;
    basic_shader(nx, ny, nz, u, v, w, view_vec, lights, &surface, color);
}
