#include <stdio.h>
#include <math.h>

#include <sipp.h>
#include <primitives.h>
#include <shaders.h>


#define SPHERERES 40
#define CYLRES    40

#define SIGNBIT(bit, i)   (((i >> bit) & 1) ? -1.0 : 1.0)

Surf_desc surf = {
    0.4,
    0.7, 
    0.1, 
    {0.8, 0.6, 0.3}
    };
    
Bumpy_desc bumpy_surf = {
    basic_shader, 
    &surf, 
    14.0, 
    FALSE, 
    TRUE
};

main(argc, argv)
    int    argc;
    char **argv;
{
    Object  *sphere;
    Object  *cyl;
    Object  *structure;
    FILE    *fp ;
    Surf_desc cyl_surf;
    int      size;
    int      i;


    if (argc != 2) {
        size = 256;
    } else {
        size = atoi(argv[1]);
    }

    sipp_init();

    lightsource_push(1.0, 1.0, 1.0, 0.9);
    lightsource_push(-1.0, -1.0, 0.5, 0.4);

    cyl_surf.ambient = 0.5;
    cyl_surf.color.red = 0.5;
    cyl_surf.color.grn = 0.6;
    cyl_surf.color.blu = 0.8;
    cyl_surf.specular = 0.4;
    cyl_surf.c3 = 0.3;
    
    structure = object_create();

    sphere = sipp_sphere(1.0, SPHERERES, &bumpy_surf, bumpy_shader);
    for (i = 0; i < 8; i++) {
        if (i) {
            sphere = object_instance(sphere);
        }
        object_move(sphere, 2.0 * SIGNBIT(2, i), 2.0 * SIGNBIT(1, i), 
                    2.0 * SIGNBIT(0, i));
        object_add_subobj(structure, sphere);
    }

    cyl = sipp_cylinder(0.25, 4.0, CYLRES, &cyl_surf, basic_shader);
    for (i = 0; i < 4; i++) {
        if (i) {
            cyl = object_instance(cyl);
        }
        object_move(cyl, 2.0 * SIGNBIT(1, i), 2.0 * SIGNBIT(0, i), 0.0);
        object_add_subobj(structure, cyl);
    }
    for (i = 0; i < 4; i++) {
        cyl = object_instance(cyl);
        object_rot_x(cyl, M_PI / 2.0);
        object_move(cyl, 2.0 * SIGNBIT(1, i), 0.0, 2.0 * SIGNBIT(0, i));
        object_add_subobj(structure, cyl);
    }
    for (i = 0; i < 4; i++) {
        cyl = object_instance(cyl);
        object_rot_y(cyl, M_PI / 2.0);
        object_move(cyl, 0.0, 2.0 * SIGNBIT(1, i), 2.0 * SIGNBIT(0, i));
        object_add_subobj(structure, cyl);
    }
    
    object_install(structure);

    view_from(10.0, -5.0, 15.0);
    view_at(0.0, 0.0, 0.0);
    view_up(0.0, 0.0, 1.0);
    view_focal(0.25);

    printf("Rendering, wait...");
    fflush(stdout);

    fp = fopen("structure.ppm", "w");
    render_image(size, size, fp);
    printf("Done.\n");
}

