#include <stdio.h>
#include <math.h>

#include <sipp.h>
#include <primitives.h>



#define SMALLRES 15
#define BIGRES   40


main(argc, argv)
    int    argc;
    char **argv;
{
    Object  *torus;
    Object  *torus_pair;
    Object  *chain;
    FILE    *fp ;
    Surf_desc surf;
    int      side;


    if (argc != 2) {
        side = 256;
    } else {
        side = atoi(argv[1]);
    }

    sipp_init();

    lightsource_push(1.0, 1.0, 1.0, 0.9);
    lightsource_push(-1.0, -1.0, 0.5, 0.4);

    surf.ambient = 0.5;
    surf.color.red = 0.8;
    surf.color.grn = 0.6;
    surf.color.blu = 0.3;
    surf.specular = 0.6;
    surf.c3 = 0.2;
    
    torus = sipp_torus(1.0, 0.23, BIGRES, SMALLRES, &surf, basic_shader);
    torus_pair = object_create();
    object_add_subobj(torus_pair, torus);
    torus = object_instance(torus);
    object_move(torus, 0.0, -1.375, 0.0);
    object_rot_y(torus, M_PI / 2.0);
    object_add_subobj(torus_pair, torus);
    
    chain = object_create();
    object_move(torus_pair, -1.375, 1.375, 0.0);
    object_add_subobj(chain, torus_pair);
    torus_pair = object_instance(torus_pair);
    object_rot_z(torus_pair, M_PI / 2.0);
    object_move(torus_pair, -1.375, -1.375, 0.0);
    object_add_subobj(chain, torus_pair);
    torus_pair = object_instance(torus_pair);
    object_rot_z(torus_pair, M_PI);
    object_move(torus_pair, 1.375, -1.375, 0.0);
    object_add_subobj(chain, torus_pair);
    torus_pair = object_instance(torus_pair);
    object_rot_z(torus_pair, 3.0 * M_PI / 2.0);
    object_move(torus_pair, 1.375, 1.375, 0.0);
    object_add_subobj(chain, torus_pair);
    
    object_install(chain);

    view_from(5.0, -2.0, 15.0);
    view_at(0.5, 0.0, 0.0);
    view_up(0.0, 0.0, 1.0);
    view_focal(0.25);

    printf("Rendering, wait...");
    fflush(stdout);

    fp = fopen("chain.ppm", "w");
    render_image(side, side, fp);
    printf("Done.\n");

    exit(0);
}
